/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.usecases;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.usecases.BMBean2IF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSContext;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.Properties;

@TransactionManagement(value=TransactionManagementType.BEAN)
@Stateless(name="CDIUseCasesBMBEAN2")
public class BMBean2
implements BMBean2IF {
    private static final long serialVersionUID = 1L;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    JMSContext context;
    @Resource(name="jms/MyConnectionFactory")
    ConnectionFactory cfactory;
    @Resource(name="jms/MY_QUEUE")
    Queue queue;
    @Resource(name="jms/MY_TOPIC")
    Topic topic;

    @PostConstruct
    public void postConstruct() {
        System.out.println("BMBean2:postConstruct()");
        System.out.println("queue=" + this.queue);
        System.out.println("topic=" + this.topic);
        System.out.println("cfactory=" + this.cfactory);
        if (this.queue == null || this.topic == null || this.context == null || this.cfactory == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        TestUtil.logMsg((String)"BMBean2.init()");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("BMBean2.init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("BMBean2.init: failed");
        }
    }

    @Override
    public void method2() {
        TestUtil.logMsg((String)("BMBean2.method2(): JMSContext context=" + this.context));
        TestUtil.logMsg((String)"Sending message [Message 2]");
        this.context.createProducer().send((Destination)this.queue, "Message 2");
    }
}

