/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.exceptions;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.exceptions.Coffee;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.Query;
import jakarta.persistence.QueryTimeoutException;
import jakarta.persistence.RollbackException;
import jakarta.persistence.TransactionRequiredException;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.logTrace("Cleanup data");
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void TransactionRequiredExceptionTest() throws Exception {
        boolean pass = false;
        Coffee newCoffee = new Coffee(1, "hazelnut", 1.0f);
        try {
            this.logTrace("Invoked persist without an active transaction");
            this.getEntityManager().persist((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            this.logTrace("In JavaEE, Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass && this.isStandAloneMode()) {
            this.logTrace("In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("TransactionRequiredExceptionTest failed");
        }
    }

    public void TransactionRequiredException2Test() throws Exception {
        this.logTrace("Test TransactionRequiredExceptionNullMsg");
        boolean pass = true;
        try {
            throw new TransactionRequiredException();
        }
        catch (TransactionRequiredException eee) {
            this.logTrace("TransactionRequiredException Caught as Expected");
            if (eee.getMessage() != null) {
                this.logErr("TransactionRequiredException should have had null message, actual message=" + eee.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception Caught", e);
            pass = false;
        }
        this.logMsg("Test TransactionRequiredExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new TransactionRequiredException(expected);
        }
        catch (TransactionRequiredException eee) {
            this.logTrace("TransactionRequiredException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                    pass = false;
                }
            } else {
                this.logErr("TransactionRequiredException returned null message");
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception Caught", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("TransactionRequiredException2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest2() throws Exception {
        this.logTrace("Begin exceptionTest2");
        Coffee newCoffee = new Coffee(2, "french roast", 9.0f);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            this.logTrace("try flush");
            this.getEntityManager().flush();
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception :", re);
            }
        }
        if (!pass) {
            throw new Exception("exceptionTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest3() throws Exception {
        this.logTrace("Begin exceptionTest3");
        boolean pass = false;
        Coffee newCoffee = new Coffee(3, "french roast", 9.0f);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Persist Coffee ");
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            this.logTrace("Call refresh without an active transaction");
            this.getEntityManager().refresh((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected Exception Caught rolling back TX:", fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            this.logTrace("In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("exceptionTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest4() throws Exception {
        this.logTrace("Begin exceptionTest4");
        Coffee newCoffee = new Coffee(5, "breakfast blend", 3.0f);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            this.logTrace("Call remove without an active transaction");
            this.getEntityManager().remove((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected Exception Caught rolling back TX:", fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            this.logTrace("In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("exceptionTest4 failed");
        }
    }

    public void exceptionTest5() throws Exception {
        this.logTrace("Begin exceptionTest5");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().close();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + ise);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected Exception Caught rolling back TX:", fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            this.logTrace("In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("exceptionTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionTest6() throws Exception {
        this.logTrace("Begin exceptionTest6");
        boolean pass = false;
        Coffee newCoffee = new Coffee(7, "cinnamon", 7.0f);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.clearCache();
            if (!this.getEntityManager().contains((Object)newCoffee)) {
                this.getEntityManager().refresh((Object)newCoffee);
            } else {
                this.logTrace("Entity is managed, cannot proceed with test");
            }
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Exception Caught as Expected: " + iae);
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("exceptionTest6 failed");
        }
    }

    public void RollbackExceptionTest() throws Exception {
        this.logMsg("Test RollbackExceptionNullMsg");
        boolean pass = true;
        try {
            throw new RollbackException();
        }
        catch (RollbackException re) {
            this.logTrace("RollbackException Caught as Expected");
            if (re.getMessage() != null) {
                pass = false;
                this.logErr("RollbackException should have had null message, actual message=" + re.getMessage());
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception Caught", e);
            pass = false;
        }
        this.logMsg("Test RollbackExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new RollbackException(expected);
        }
        catch (RollbackException re) {
            this.logTrace("RollbackException Caught as Expected");
            String msg = re.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("RollbackException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test RollbackExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new RollbackException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (RollbackException re) {
            this.logTrace("RollbackException Caught as Expected");
            String msg = re.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = re.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("RollbackException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test RollbackExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new RollbackException((Throwable)new IllegalAccessException(expected));
        }
        catch (RollbackException re) {
            this.logTrace("RollbackException Caught as Expected");
            Throwable t = re.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        if (!pass) {
            throw new Exception("RollbackExceptionTest failed");
        }
    }

    public void EntityExistsExceptionTest() throws Exception {
        this.logMsg("Test EntityExistsExceptionNullMsg");
        boolean pass = true;
        try {
            throw new EntityExistsException();
        }
        catch (EntityExistsException eee) {
            this.logTrace("EntityExistsException Caught as Expected");
            if (eee.getMessage() != null) {
                pass = false;
                this.logErr("EntityExistsException should have had null message, actual message=" + eee.getMessage());
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception Caught", e);
            pass = false;
        }
        this.logMsg("Test EntityExistskExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new EntityExistsException(expected);
        }
        catch (EntityExistsException eee) {
            this.logTrace("EntityExistsException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("EntityExistsException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test EntityExistsExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new EntityExistsException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (EntityExistsException eee) {
            this.logTrace("EntityExistsException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = eee.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("EntityExistsException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test EntityExistsExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new EntityExistsException((Throwable)new IllegalAccessException(expected));
        }
        catch (EntityExistsException eee) {
            this.logTrace("EntityExistsException Caught as Expected");
            Throwable t = eee.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        if (!pass) {
            throw new Exception("EntityExistsExceptionTest failed");
        }
    }

    public void EntityNotFoundExceptionTest() throws Exception {
        this.logMsg("Test EntityNotFoundExceptionNullMsg");
        boolean pass = true;
        try {
            throw new EntityNotFoundException();
        }
        catch (EntityNotFoundException enf) {
            this.logTrace("EntityNotFoundException Caught as Expected");
            if (enf.getMessage() != null) {
                pass = false;
                this.logErr("EntityNotFoundException should have had null message, actual message=" + enf.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test EntityNotFoundExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new EntityNotFoundException(expected);
        }
        catch (EntityNotFoundException enf) {
            this.logTrace("EntityNotFoundException Caught as Expected");
            String msg = enf.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("EntityNotFoundException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        if (!pass) {
            throw new Exception("EntityNotFoundExceptionTest failed");
        }
    }

    public void OptimisticLockExceptionTest() throws Exception {
        String msg;
        this.logMsg("Test OptimisticLockExceptionNullMsg");
        boolean pass = true;
        try {
            throw new OptimisticLockException();
        }
        catch (OptimisticLockException ole) {
            this.logTrace("OptimisticLockException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                this.logErr("OptimisticLockException should have had null message, actual message=" + ole.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test OptimisticLockExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new OptimisticLockException(expected);
        }
        catch (OptimisticLockException ole) {
            this.logTrace("OptimisticLockException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    this.logErr("Expected=" + msg2 + ", Actual=" + msg2);
                }
            } else {
                pass = false;
                this.logErr("OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test OptimisticLockExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new OptimisticLockException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (OptimisticLockException ole) {
            this.logTrace("OptimisticLockException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg3 + ", Actual=" + msg3);
                }
            } else {
                pass = false;
                this.logErr("OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test OptimisticLockExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new OptimisticLockException((Throwable)new IllegalAccessException(expected));
        }
        catch (OptimisticLockException ole) {
            this.logTrace("OptimisticLockException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test OptimisticLockExceptionObjectMsg");
        Coffee cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new OptimisticLockException((Object)cExpected);
        }
        catch (OptimisticLockException ol) {
            this.logTrace("OptimisticLockException Caught as Expected");
            Coffee c = (Coffee)ol.getEntity();
            if (c != null) {
                if (!c.equals(cExpected)) {
                    pass = false;
                    this.logErr("Expected=" + cExpected + ", Actual=" + c);
                }
            } else {
                pass = false;
                this.logErr("OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test OptimisticLockExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new OptimisticLockException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (OptimisticLockException ole) {
            this.logTrace("OptimisticLockException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getEntity();
                            if (!c.equals(cExpected)) {
                                pass = false;
                                this.logErr("Expected Entity=" + cExpected + ", Actual=" + c);
                            }
                        } else {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        if (!pass) {
            throw new Exception("OptimisticLockExceptionTest failed");
        }
    }

    public void PersistenceExceptionTest() throws Exception {
        this.logMsg("Test PersistenceExceptionNullMsg");
        boolean pass = true;
        try {
            throw new PersistenceException();
        }
        catch (PersistenceException eee) {
            this.logTrace("PersistenceException Caught as Expected");
            if (eee.getMessage() != null) {
                pass = false;
                this.logErr("PersistenceException should have had null message, actual message=" + eee.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test EntityExistskExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new PersistenceException(expected);
        }
        catch (PersistenceException eee) {
            this.logTrace("PersistenceException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("PersistenceException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test PersistenceExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new PersistenceException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (PersistenceException eee) {
            this.logTrace("PersistenceException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = eee.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("PersistenceException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test PersistenceExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new PersistenceException((Throwable)new IllegalAccessException(expected));
        }
        catch (PersistenceException eee) {
            this.logTrace("PersistenceException Caught as Expected");
            Throwable t = eee.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        if (!pass) {
            throw new Exception("PersistenceExceptionTest failed");
        }
    }

    public void LockTimeoutExceptionTest() throws Exception {
        String msg;
        this.logMsg("Test LockTimeoutExceptionNullMsg");
        boolean pass = true;
        try {
            throw new LockTimeoutException();
        }
        catch (LockTimeoutException ole) {
            this.logTrace("LockTimeoutException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                this.logErr("LockTimeoutException should have had null message, actual message=" + ole.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test LockTimeoutExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new LockTimeoutException(expected);
        }
        catch (LockTimeoutException ole) {
            this.logTrace("LockTimeoutException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    this.logErr("Expected=" + msg2 + ", Actual=" + msg2);
                }
            } else {
                pass = false;
                this.logErr("LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test LockTimeoutExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new LockTimeoutException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (LockTimeoutException ole) {
            this.logTrace("LockTimeoutException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg3 + ", Actual=" + msg3);
                }
            } else {
                pass = false;
                this.logErr("LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test LockTimeoutExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new LockTimeoutException((Throwable)new IllegalAccessException(expected));
        }
        catch (LockTimeoutException ole) {
            this.logTrace("LockTimeoutException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test LockTimeoutExceptionObjectMsg");
        Coffee cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new LockTimeoutException((Object)cExpected);
        }
        catch (LockTimeoutException ol) {
            this.logTrace("LockTimeoutException Caught as Expected");
            Coffee c = (Coffee)ol.getObject();
            if (c != null) {
                if (!c.equals(cExpected)) {
                    pass = false;
                    this.logErr("Expected=" + cExpected + ", Actual=" + c);
                }
            } else {
                pass = false;
                this.logErr("LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test LockTimeoutExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new LockTimeoutException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (LockTimeoutException ole) {
            this.logTrace("LockTimeoutException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getObject();
                            if (!c.equals(cExpected)) {
                                pass = false;
                                this.logErr("Expected Entity=" + cExpected + ", Actual=" + c);
                            }
                        } else {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        if (!pass) {
            throw new Exception("LockTimeoutExceptionTest failed");
        }
    }

    public void PessimisticLockExceptionTest() throws Exception {
        String msg;
        this.logMsg("Test PessimisticLockExceptionNullMsg");
        boolean pass = true;
        try {
            throw new PessimisticLockException();
        }
        catch (PessimisticLockException ole) {
            this.logTrace("PessimisticLockException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                this.logErr("PessimisticLockException should have had null message, actual message=" + ole.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test PessimisticLockExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new PessimisticLockException(expected);
        }
        catch (PessimisticLockException ole) {
            this.logTrace("PessimisticLockException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    this.logErr("Expected=" + msg2 + ", Actual=" + msg2);
                }
            } else {
                pass = false;
                this.logErr("PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test PessimisticLockExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new PessimisticLockException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (PessimisticLockException ole) {
            this.logTrace("PessimisticLockException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg3 + ", Actual=" + msg3);
                }
            } else {
                pass = false;
                this.logErr("PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test PessimisticLockExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new PessimisticLockException((Throwable)new IllegalAccessException(expected));
        }
        catch (PessimisticLockException ole) {
            this.logTrace("PessimisticLockException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test PessimisticLockExceptionObjectMsg");
        Coffee cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new PessimisticLockException((Object)cExpected);
        }
        catch (PessimisticLockException ol) {
            this.logTrace("PessimisticLockException Caught as Expected");
            Coffee c = (Coffee)ol.getEntity();
            if (c != null) {
                if (!c.equals(cExpected)) {
                    pass = false;
                    this.logErr("Expected=" + cExpected + ", Actual=" + c);
                }
            } else {
                pass = false;
                this.logErr("PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        this.logMsg("Test PessimisticLockExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new PessimisticLockException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (PessimisticLockException ole) {
            this.logTrace("PessimisticLockException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getEntity();
                            if (!c.equals(cExpected)) {
                                pass = false;
                                this.logErr("Expected Entity=" + cExpected + ", Actual=" + c);
                            }
                        } else {
                            pass = false;
                            this.logErr("Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                this.logErr("PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception Caught", e);
        }
        if (!pass) {
            throw new Exception("PessimisticLockExceptionTest failed");
        }
    }

    public void QueryTimeoutExceptionTest() throws Exception {
        this.logMsg("Begin QueryTimeoutExceptionNullMsgTest");
        boolean pass = true;
        try {
            throw new QueryTimeoutException();
        }
        catch (QueryTimeoutException ole) {
            this.logTrace("QueryTimeoutException Caught as Expected");
            if (ole.getMessage() != null) {
                this.logErr("QueryTimeoutException should have had null message, actual message=" + ole.getMessage());
                pass = false;
            }
            this.logMsg("Test QueryTimeoutExceptionStringMsg");
            String expected = "This is the String message";
            try {
                throw new QueryTimeoutException(expected);
            }
            catch (QueryTimeoutException ole2) {
                this.logTrace("QueryTimeoutException Caught as Expected");
                String msg = ole2.getMessage();
                if (msg != null) {
                    if (!msg.equals(expected)) {
                        this.logErr("Expected=" + msg + ", Actual=" + msg);
                        pass = false;
                    }
                } else {
                    this.logErr("QueryTimeoutException returned null message");
                    pass = false;
                }
                this.logMsg("Test QueryTimeoutExceptionStringThrowable");
                expected = "This is the String message";
                String expected2 = "This is the Throwable message";
                try {
                    throw new QueryTimeoutException(expected, (Throwable)new IllegalAccessException(expected2));
                }
                catch (QueryTimeoutException ole3) {
                    this.logTrace("QueryTimeoutException Caught as Expected");
                    String msg2 = ole3.getMessage();
                    if (msg2 != null) {
                        if (msg2.equals(expected)) {
                            Throwable t = ole3.getCause();
                            if (t instanceof IllegalAccessException) {
                                msg2 = t.getMessage();
                                if (!msg2.equals(expected2)) {
                                    this.logErr("Expected Throwable msg=" + msg2 + ", Actual=" + msg2);
                                    pass = false;
                                }
                            } else {
                                this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                                pass = false;
                            }
                        } else {
                            this.logErr("Expected=" + msg2 + ", Actual=" + msg2);
                            pass = false;
                        }
                    } else {
                        this.logErr("QueryTimeoutException returned null message");
                        pass = false;
                    }
                    this.logMsg("Test QueryTimeoutExceptionThrowable");
                    expected = "This is the Throwable message";
                    try {
                        throw new QueryTimeoutException((Throwable)new IllegalAccessException(expected));
                    }
                    catch (QueryTimeoutException qte) {
                        String msg3;
                        this.logTrace("QueryTimeoutException Caught as Expected");
                        Throwable t = qte.getCause();
                        if (t instanceof IllegalAccessException) {
                            msg3 = t.getMessage();
                            if (msg3 != null) {
                                if (!msg3.equals(expected)) {
                                    this.logErr("Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                                    pass = false;
                                }
                            } else {
                                this.logErr("t.getMessage() returned null");
                                pass = false;
                            }
                        } else {
                            this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t);
                            pass = false;
                        }
                        this.logMsg("Begin QueryTimeoutExceptionObjectMsgTest");
                        Query qExpected = this.getEntityManager().createQuery("select c from Coffee c");
                        try {
                            throw new QueryTimeoutException(qExpected);
                        }
                        catch (QueryTimeoutException qte2) {
                            this.logTrace("QueryTimeoutException Caught as Expected");
                            Query q = qte2.getQuery();
                            if (q != null) {
                                if (q.equals(qExpected)) {
                                    pass = true;
                                } else {
                                    this.logErr("Expected=" + expected + ", Actual=" + q);
                                    pass = false;
                                }
                            } else {
                                this.logErr("QueryTimeoutException returned null message");
                                pass = false;
                            }
                            this.logMsg("Test QueryTimeoutExceptionStringThrowableObject");
                            expected = "This is the String message";
                            expected2 = "This is the Throwable message";
                            qExpected = this.getEntityManager().createQuery("select c from Coffee c");
                            try {
                                throw new QueryTimeoutException(expected, (Throwable)new IllegalAccessException(expected2), qExpected);
                            }
                            catch (QueryTimeoutException qte3) {
                                this.logTrace("QueryTimeoutException Caught as Expected");
                                msg3 = qte3.getMessage();
                                if (msg3 != null) {
                                    if (msg3.equals(expected)) {
                                        Throwable t2 = qte3.getCause();
                                        if (t2 instanceof IllegalAccessException) {
                                            msg3 = t2.getMessage();
                                            if (msg3 != null) {
                                                if (msg3.equals(expected2)) {
                                                    Query q2 = qte3.getQuery();
                                                    if (q2 != null) {
                                                        if (!q2.equals(qExpected)) {
                                                            this.logErr("Expected Entity=" + qExpected + ", Actual=" + q2);
                                                            pass = false;
                                                        }
                                                    } else {
                                                        this.logErr("getQuery returned null");
                                                        pass = false;
                                                    }
                                                } else {
                                                    this.logErr("Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                                                    pass = false;
                                                }
                                            } else {
                                                this.logErr("t.getMessage returned null");
                                                pass = false;
                                            }
                                        } else {
                                            this.logErr("getCause did not return an instance of IllegalAccessException, instead got " + t2);
                                            pass = false;
                                        }
                                    } else {
                                        this.logErr("Expected=" + msg3 + ", Actual=" + msg3);
                                        pass = false;
                                    }
                                } else {
                                    this.logErr("QueryTimeoutException returned null message");
                                    pass = false;
                                }
                            }
                            catch (Exception e) {
                                this.logErr("Unexpected Exception Caught", e);
                                pass = false;
                            }
                            if (!pass) {
                                throw new Exception("QueryTimeoutExceptionTest failed");
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    public void NonUniqueResultExceptionTest() throws Exception {
        boolean pass = true;
        this.logMsg("Begin NonUniqueResultExceptionNullMsgTest");
        try {
            throw new NonUniqueResultException();
        }
        catch (NonUniqueResultException nure) {
            this.logTrace("NonUniqueResultException Caught as Expected");
            if (nure.getMessage() != null) {
                this.logErr("NonUniqueResultException should have had null message, actual message=" + nure.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception Caught", e);
            pass = false;
        }
        this.logTrace("Testing NonUniqueResultExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new NonUniqueResultException(expected);
        }
        catch (NonUniqueResultException ole) {
            this.logTrace("NonUniqueResultException Caught as Expected");
            String msg = ole.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                    pass = false;
                }
            } else {
                this.logErr("NonUniqueResultException returned null message");
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception Caught", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("NonUniqueResultExceptionTest failed");
        }
    }

    public void NoResultExceptionTest() throws Exception {
        boolean pass = true;
        this.logMsg("Testing NoResultExceptionNullMsg");
        try {
            throw new NoResultException();
        }
        catch (NoResultException nre) {
            this.logTrace("NoResultException Caught as Expected");
            if (nre.getMessage() != null) {
                this.logErr("NoResultException should have had null message, actual message=" + nre.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception Caught", e);
            pass = false;
        }
        this.logMsg("Testing NoResultExceptionStringMsgTest");
        String expected = "This is the String message";
        try {
            throw new NoResultException(expected);
        }
        catch (NoResultException nre) {
            this.logTrace("NoResultException Caught as Expected");
            String msg = nre.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    this.logErr("Expected=" + msg + ", Actual=" + msg);
                    pass = false;
                }
            } else {
                this.logErr("NoResultException returned null message");
                pass = false;
            }
            if (!pass) {
                throw new Exception("NoResultExceptionTest failed");
            }
            return;
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        if (this.getEntityManager().isOpen()) {
            this.removeTestData();
        }
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

