/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.annotated;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.WorkImpl;
import com.sun.ts.tests.common.connector.whitebox.WorkListenerImpl;
import com.sun.ts.tests.common.connector.whitebox.XidImpl;
import com.sun.ts.tests.common.connector.whitebox.annotated.NestedWorkXid1;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class AnnoWorkManager {
    private BootstrapContext bsc = null;
    private WorkManager wmgr;
    private Xid myxid;
    private Xid mynestxid;
    private XATerminator xa;

    public AnnoWorkManager(BootstrapContext val) {
        this.debug("entered constructor");
        this.bsc = val;
        this.wmgr = this.bsc.getWorkManager();
        this.xa = this.bsc.getXATerminator();
        this.debug("leaving constructor");
    }

    public void runTests() {
        this.debug("entered runTests");
        this.doWork();
        this.doTCWork();
        this.submitNestedXidWork();
        this.debug("leaving runTests");
    }

    public void doWork() {
        this.debug("entered doWork");
        try {
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            ExecutionContext ec = new ExecutionContext();
            WorkListenerImpl wl = new WorkListenerImpl();
            this.wmgr.doWork((Work)workimpl, 5000L, ec, (WorkListener)wl);
            ConnectorStatus.getConnectorStatus().logState("AnnoWorkManager Work Object Submitted");
            this.debug("AnnoWorkManager Work Object Submitted");
        }
        catch (WorkException we) {
            System.out.println("AnnoWorkManager WorkException thrown is " + we.getMessage());
        }
        catch (Exception ex) {
            System.out.println("AnnoWorkManager Exception thrown is " + ex.getMessage());
        }
        this.debug("leaving doWork");
    }

    private TransactionContext startTx() {
        TransactionContext tc = new TransactionContext();
        try {
            XidImpl xid = new XidImpl();
            tc.setXid((Xid)xid);
            tc.setTransactionTimeout(5000L);
        }
        catch (Exception ex) {
            Debug.printDebugStack(ex);
        }
        return tc;
    }

    public void doTCWork() {
        try {
            XidImpl myid = new XidImpl();
            WorkImpl workimpl = new WorkImpl(this.wmgr);
            TransactionContext tc = this.startTx();
            tc.setXid((Xid)myid);
            Debug.trace("Creating WorkListener");
            WorkListenerImpl wl = new WorkListenerImpl();
            this.wmgr.doWork((Work)workimpl, 5000L, (ExecutionContext)tc, (WorkListener)wl);
            ConnectorStatus.getConnectorStatus().logState("TransactionContext Work Object Submitted");
            this.xa.commit(tc.getXid(), true);
        }
        catch (XAException xe) {
            Debug.trace("AnnoWorkManager.doTCWork():  XAException" + xe.getMessage());
            Debug.trace("AnnoWorkManager XAException.toString() = " + xe.toString());
            Debug.printDebugStack(xe);
        }
        catch (WorkException we) {
            Debug.trace("TestWorkManager Exception thrown is " + we.getMessage());
        }
    }

    public void setXid(Xid xid) {
        this.myxid = xid;
    }

    public Xid getXid() {
        return this.myxid;
    }

    public void setNestXid(Xid xid) {
        this.mynestxid = xid;
    }

    public Xid getNestXid() {
        return this.mynestxid;
    }

    public void submitNestedXidWork() {
        try {
            XidImpl myid = new XidImpl();
            NestedWorkXid1 workid = new NestedWorkXid1(this.wmgr, myid, NestedWorkXid1.ContextType.EXECUTION_CONTEXT);
            this.setNestXid(myid);
            TransactionContext tc = this.startTx();
            tc.setXid((Xid)myid);
            this.wmgr.doWork((Work)workid, Long.MAX_VALUE, (ExecutionContext)tc, null);
            Debug.trace("Anno based NestedWorkXid1 Submitted");
            ConnectorStatus.getConnectorStatus().logState("anno based NestedWorkXid1 parent context submitted");
            this.xa.commit(tc.getXid(), true);
        }
        catch (XAException xe) {
            Debug.trace("AnnoWorkManager.submitNestedXidWork():  XAException" + xe.getMessage());
            Debug.trace("AnnoWorkManager XAException.toString() = " + xe.toString());
            Debug.printDebugStack(xe);
        }
        catch (WorkException we) {
            Debug.printDebugStack((Exception)((Object)we));
        }
        catch (Exception ex) {
            Debug.printDebugStack(ex);
        }
    }

    public void debug(String out) {
        Debug.trace("AnnoWorkManager:  " + out);
    }
}

