/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.relationaloperator;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.el.api.expression.ExpressionTest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.el.common.elcontext.BarELContext;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.SimpleELContext;
import com.sun.ts.tests.el.common.elcontext.VRContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.elresolver.EmployeeELResolver;
import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.elresolver.VariableELResolver;
import com.sun.ts.tests.el.common.elresolver.VectELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.MethodsBean;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.ResolverType;
import com.sun.ts.tests.el.common.util.SimpleBean;
import com.sun.ts.tests.el.common.util.SimpleInterface;
import com.sun.ts.tests.el.common.util.TestNum;
import com.sun.ts.tests.el.common.util.TypesBean;
import com.sun.ts.tests.el.common.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="el"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="tck-javatest")})
public class ELClientJspTest
extends ServiceEETest {
    static final String VEHICLE_ARCHIVE = "relationaloperator_jsp_vehicle";
    private static final System.Logger logger = System.getLogger(ELClientJspTest.class.getName());
    Properties testProps;
    private List numberList;
    private static final DougType DT = new DougType();
    private static final NickType NT = new NickType();

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public static String inputStreamToString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static String editWebXmlString(InputStream inStream, String jsp_vehicle) throws IOException {
        return ELClientJspTest.inputStreamToString(inStream).replaceAll("el_jsp_vehicle", jsp_vehicle);
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="relationaloperator_jsp_vehicle", order=2)
    public static WebArchive createDeploymentVehicle() throws IOException {
        WebArchive jsp_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"relationaloperator_jsp_vehicle_web.war");
        jsp_vehicle_web.addClasses(new Class[]{EETest.Fault.class, EETest.SetupException.class, EETest.class, ServiceEETest.class, VehicleClient.class, VehicleRunnable.class, VehicleRunnerFactory.class, ExpressionTest.class, EmployeeELResolver.class, FunctionELResolver.class, VariableELResolver.class, VectELResolver.class, BareBonesELContext.class, SimpleELContext.class, SimpleELContext.Resolver.class, FuncMapperELContext.class, BarELContext.class, VRContext.class, VarMapperELContext.class, ELTestUtil.class, SimpleBean.class, SimpleInterface.class, ResolverType.class, NameValuePair.class, ExprEval.class, MethodsBean.class, TestNum.class, TypesBean.class, Validator.class, TCKFunctionMapper.class, ELClientJspTest.class});
        InputStream inStream = ELClientJspTest.class.getResourceAsStream("/vehicle/jsp/jsp_vehicle_web.xml");
        String webXml = ELClientJspTest.editWebXmlString(inStream, VEHICLE_ARCHIVE);
        jsp_vehicle_web.setWebXML((Asset)new StringAsset(webXml));
        URL warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/client.html");
        jsp_vehicle_web.addAsWebResource(warResURL, "/client.html");
        warResURL = ELClientJspTest.class.getResource("/vehicle/jsp/contentRoot/jsp_vehicle.jsp");
        jsp_vehicle_web.addAsWebResource(warResURL, "/jsp_vehicle.jsp");
        return jsp_vehicle_web;
    }

    public static void main(String[] args) {
        ELClientJspTest theTests = new ELClientJspTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup method called");
        this.testProps = p;
        this.numberList = TestNum.getNumberList();
    }

    public void cleanup() throws Exception {
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elEqualOperandLessThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            String expr1 = ExprEval.buildElExpr(false, "<=");
            TestUtil.logTrace((String)("first expression to be evaluated is " + expr1));
            NameValuePair[] values1 = NameValuePair.buildNameValuePair(new Float(-1.0f), new Float(-1.0));
            Object result1 = ExprEval.evaluateValueExpression(expr1, values1, Boolean.class);
            TestUtil.logTrace((String)("first result is " + result1.toString()));
            String expr2 = ExprEval.buildElExpr(true, "le");
            TestUtil.logTrace((String)("second expression to be evaluated is " + expr2));
            NameValuePair[] values2 = NameValuePair.buildNameValuePair(new BigDecimal("1.0"), BigDecimal.ONE);
            Object result2 = ExprEval.evaluateValueExpression(expr2, values2, Boolean.class);
            TestUtil.logTrace((String)("second result is " + result2.toString()));
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.TRUE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elEqualOperandGreaterThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            String expr1 = ExprEval.buildElExpr(false, ">=");
            TestUtil.logTrace((String)("first expression to be evaluated is " + expr1));
            NameValuePair[] values1 = NameValuePair.buildNameValuePair(new Float(-1.0f), new Float(-1.0));
            Object result1 = ExprEval.evaluateValueExpression(expr1, values1, Boolean.class);
            TestUtil.logTrace((String)("first result is " + result1.toString()));
            String expr2 = ExprEval.buildElExpr(true, "ge");
            TestUtil.logTrace((String)("second expression to be evaluated is " + expr2));
            NameValuePair[] values2 = NameValuePair.buildNameValuePair(new BigInteger("1010"), BigInteger.TEN);
            Object result2 = ExprEval.evaluateValueExpression(expr2, values2, Boolean.class);
            TestUtil.logTrace((String)("second result is " + result2.toString()));
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.TRUE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandLessThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 <= nullValue}", null, Object.class);
            TestUtil.logTrace((String)("first result is " + result1.toString()));
            Object result2 = ExprEval.evaluateValueExpression("#{2 le nullValue}", null, Object.class);
            TestUtil.logTrace((String)("second result is " + result2.toString()));
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.FALSE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.FALSE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandGreaterThanOrEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 >= nullValue}", null, Object.class);
            TestUtil.logTrace((String)("first result is " + result1.toString()));
            Object result2 = ExprEval.evaluateValueExpression("#{2 ge nullValue}", null, Object.class);
            TestUtil.logTrace((String)("second result is " + result2.toString()));
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.FALSE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.FALSE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandNotEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 != nullValue}", null, Object.class);
            TestUtil.logTrace((String)("first result is " + result1.toString()));
            Object result2 = ExprEval.evaluateValueExpression("#{2 ne nullValue}", null, Object.class);
            TestUtil.logTrace((String)("second result is " + result2.toString()));
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.TRUE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elNullOperandEqualTest() throws Exception {
        boolean pass = false;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${1 == nullValue}", null, Object.class);
            TestUtil.logTrace((String)("first result is " + result1.toString()));
            Object result2 = ExprEval.evaluateValueExpression("#{2 eq nullValue}", null, Object.class);
            TestUtil.logTrace((String)("second result is " + result2.toString()));
            pass = ExprEval.compareClass(result1, Boolean.class) && ExprEval.compareValue((Boolean)result1, Boolean.FALSE) && ExprEval.compareClass(result2, Boolean.class) && ExprEval.compareValue((Boolean)result2, Boolean.FALSE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalLessThanTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), (Boolean)false, "<");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), (Boolean)false, "lt");
        this.testOperatorBoolean(BigDecimal.valueOf(0.531), (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), (Boolean)false, "<=");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), (Boolean)true, "le");
        this.testOperatorBoolean(BigDecimal.valueOf(-10.531), (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalGreaterThanTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), (Boolean)true, ">");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), (Boolean)false, ">");
        this.testOperatorBoolean(BigDecimal.valueOf(0.531), (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), (Boolean)true, ">=");
        this.testOperatorBoolean(BigDecimal.valueOf(1.0), (Boolean)true, "ge");
        this.testOperatorBoolean(BigDecimal.valueOf(-1.0), (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalEqualToTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), (Boolean)false, "==");
        this.testOperatorBoolean(BigDecimal.valueOf(1L), (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigDecimalNotEqualToTest() throws Exception {
        this.testOperatorBoolean(BigDecimal.valueOf(10.531), (Boolean)true, "!=");
        this.testOperatorBoolean(BigDecimal.valueOf(1L), (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatLessThanTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10.0f), (Boolean)false, "<");
        this.testOperatorBoolean(Float.valueOf(1.0f), (Boolean)false, "<");
        this.testOperatorBoolean(Float.valueOf(-10.0f), (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10.0f), (Boolean)false, "<=");
        this.testOperatorBoolean(Float.valueOf(1.0f), (Boolean)true, "le");
        this.testOperatorBoolean(Float.valueOf(-10.0f), (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatGreaterThanTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), (Boolean)true, ">");
        this.testOperatorBoolean(Float.valueOf(1.0f), (Boolean)false, ">");
        this.testOperatorBoolean(Float.valueOf(-531.0f), (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), (Boolean)true, ">=");
        this.testOperatorBoolean(Float.valueOf(1.0f), (Boolean)true, "ge");
        this.testOperatorBoolean(Float.valueOf(-1.0f), (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatEqualToTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), (Boolean)false, "==");
        this.testOperatorBoolean(Float.valueOf(1.0f), (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elFloatNotEqualToTest() throws Exception {
        this.testOperatorBoolean(Float.valueOf(10531.0f), (Boolean)true, "!=");
        this.testOperatorBoolean(Float.valueOf(1.0f), (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleLessThanTest() throws Exception {
        this.testOperatorBoolean(2.5, (Boolean)false, "<");
        this.testOperatorBoolean(1.0, (Boolean)false, "lt");
        this.testOperatorBoolean(-2.5, (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(2.5, (Boolean)false, "<=");
        this.testOperatorBoolean(1.0, (Boolean)true, "le");
        this.testOperatorBoolean(-1.5, (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleGreaterThanTest() throws Exception {
        this.testOperatorBoolean(10.5, (Boolean)true, ">");
        this.testOperatorBoolean(1.0, (Boolean)false, "gt");
        this.testOperatorBoolean(-10.5, (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(10.0, (Boolean)true, ">=");
        this.testOperatorBoolean(1.0, (Boolean)true, "ge");
        this.testOperatorBoolean(-10.0, (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleEqualToTest() throws Exception {
        this.testOperatorBoolean(10531.0, (Boolean)false, "==");
        this.testOperatorBoolean(1.0, (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elDoubleNotEqualToTest() throws Exception {
        this.testOperatorBoolean(10531.0, (Boolean)true, "!=");
        this.testOperatorBoolean(1.0, (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerLessThanTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), (Boolean)false, "<");
        this.testOperatorBoolean(BigInteger.valueOf(1L), (Boolean)false, "lt");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), (Boolean)false, "<=");
        this.testOperatorBoolean(BigInteger.valueOf(1L), (Boolean)true, "le");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerGreaterThanTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), (Boolean)true, ">");
        this.testOperatorBoolean(BigInteger.valueOf(1L), (Boolean)false, "gt");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), (Boolean)true, ">=");
        this.testOperatorBoolean(BigInteger.valueOf(1L), (Boolean)true, "ge");
        this.testOperatorBoolean(BigInteger.valueOf(-10531L), (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerEqualToTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), (Boolean)false, "==");
        this.testOperatorBoolean(BigInteger.valueOf(1L), (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBigIntegerNotEqualToTest() throws Exception {
        this.testOperatorBoolean(BigInteger.valueOf(10531L), (Boolean)true, "!=");
        this.testOperatorBoolean(BigInteger.valueOf(1L), (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongLessThanTest() throws Exception {
        this.testOperatorBoolean(25000L, (Boolean)false, "<");
        this.testOperatorBoolean(1L, (Boolean)false, "<");
        this.testOperatorBoolean(-25000L, (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(25000L, (Boolean)false, "<=");
        this.testOperatorBoolean(1L, (Boolean)true, "le");
        this.testOperatorBoolean(-25000L, (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongGreaterThanTest() throws Exception {
        this.testOperatorBoolean(10531L, (Boolean)true, ">");
        this.testOperatorBoolean(1L, (Boolean)false, ">");
        this.testOperatorBoolean(-10531L, (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(25000L, (Boolean)true, ">=");
        this.testOperatorBoolean(1L, (Boolean)true, "ge");
        this.testOperatorBoolean(-25000L, (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongEqualToTest() throws Exception {
        this.testOperatorBoolean(25000L, (Boolean)false, "==");
        this.testOperatorBoolean(1L, (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elLongNotEqualToTest() throws Exception {
        this.testOperatorBoolean(25000L, (Boolean)true, "!=");
        this.testOperatorBoolean(1L, (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerLessThanTest() throws Exception {
        this.testOperatorBoolean(25, (Boolean)false, "<");
        this.testOperatorBoolean(1, (Boolean)false, "lt");
        this.testOperatorBoolean(-25, (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(25, (Boolean)false, "<=");
        this.testOperatorBoolean(1, (Boolean)true, "le");
        this.testOperatorBoolean(-25, (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerGreaterThanTest() throws Exception {
        this.testOperatorBoolean(105, (Boolean)true, ">");
        this.testOperatorBoolean(1, (Boolean)false, "gt");
        this.testOperatorBoolean(-105, (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(250, (Boolean)true, ">=");
        this.testOperatorBoolean(1, (Boolean)true, "ge");
        this.testOperatorBoolean(-250, (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerEqualToTest() throws Exception {
        this.testOperatorBoolean(25, (Boolean)false, "==");
        this.testOperatorBoolean(1, (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elIntegerNotEqualToTest() throws Exception {
        this.testOperatorBoolean(25, (Boolean)true, "!=");
        this.testOperatorBoolean(1, (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortLessThanTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), (Boolean)false, "<");
        this.testOperatorBoolean(Short.valueOf("1"), (Boolean)false, "<");
        this.testOperatorBoolean(Short.valueOf("-2"), (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), (Boolean)false, "<=");
        this.testOperatorBoolean(Short.valueOf("1"), (Boolean)true, "le");
        this.testOperatorBoolean(Short.valueOf("-2"), (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortGreaterThanTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), (Boolean)true, ">");
        this.testOperatorBoolean(Short.valueOf("1"), (Boolean)false, ">");
        this.testOperatorBoolean(Short.valueOf("-2"), (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), (Boolean)true, ">=");
        this.testOperatorBoolean(Short.valueOf("1"), (Boolean)true, "ge");
        this.testOperatorBoolean(Short.valueOf("-2"), (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortEqualToTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), (Boolean)false, "==");
        this.testOperatorBoolean(Short.valueOf("1"), (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elShortNotEqualToTest() throws Exception {
        this.testOperatorBoolean(Short.valueOf("2"), (Boolean)true, "!=");
        this.testOperatorBoolean(Short.valueOf("1"), (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteLessThanTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), (Boolean)false, "<");
        this.testOperatorBoolean(Byte.valueOf("1"), (Boolean)false, "lt");
        this.testOperatorBoolean(Byte.valueOf("-2"), (Boolean)true, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), (Boolean)false, "<=");
        this.testOperatorBoolean(Byte.valueOf("1"), (Boolean)true, "le");
        this.testOperatorBoolean(Byte.valueOf("-2"), (Boolean)true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteGreaterThanTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), (Boolean)true, ">");
        this.testOperatorBoolean(Byte.valueOf("1"), (Boolean)false, "gt");
        this.testOperatorBoolean(Byte.valueOf("-2"), (Boolean)false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), (Boolean)true, ">=");
        this.testOperatorBoolean(Byte.valueOf("1"), (Boolean)true, "ge");
        this.testOperatorBoolean(Byte.valueOf("-2"), (Boolean)false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteEqualToTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), (Boolean)false, "==");
        this.testOperatorBoolean(Byte.valueOf("1"), (Boolean)true, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elByteNotEqualToTest() throws Exception {
        this.testOperatorBoolean(Byte.valueOf("2"), (Boolean)true, "!=");
        this.testOperatorBoolean(Byte.valueOf("1"), (Boolean)false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elStringLessThanTest() throws Exception {
        this.testOperatorBoolean("Alpha", DT, true, "<");
        this.testOperatorBoolean("Beta", DT, false, "lt");
        this.testOperatorBoolean("Gamma", DT, false, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elStringLessThanEqualTest() throws Exception {
        this.testOperatorBoolean("Gamma", DT, false, "<=");
        this.testOperatorBoolean("Beta", DT, true, "le");
        this.testOperatorBoolean("Alpha", DT, true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elStringGreaterThanTest() throws Exception {
        this.testOperatorBoolean("Gamma", DT, true, ">");
        this.testOperatorBoolean("Beta", DT, false, "gt");
        this.testOperatorBoolean("Alpha", DT, false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elStringGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean("Gamma", DT, true, ">=");
        this.testOperatorBoolean("Beta", DT, true, "ge");
        this.testOperatorBoolean("Alpha", DT, false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elStringEqualToTest() throws Exception {
        this.testOperatorBoolean("Beta", DT, true, "==");
        this.testOperatorBoolean("Alpha", DT, false, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elStringNotEqualToTest() throws Exception {
        this.testOperatorBoolean("Alpha", DT, true, "!=");
        this.testOperatorBoolean("Beta", DT, false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elOtherLessThanTest() throws Exception {
        this.testOperatorBoolean(DT, NT, true, "<");
        this.testOperatorBoolean(DT, DT, false, "lt");
        this.testOperatorBoolean(NT, DT, false, "lt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elOtherLessThanEqualTest() throws Exception {
        this.testOperatorBoolean(NT, DT, false, "<=");
        this.testOperatorBoolean(DT, DT, true, "le");
        this.testOperatorBoolean(DT, NT, true, "<=");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elOtherGreaterThanTest() throws Exception {
        this.testOperatorBoolean(NT, DT, true, ">");
        this.testOperatorBoolean(DT, DT, false, "gt");
        this.testOperatorBoolean(DT, NT, false, "gt");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elOtherGreaterThanEqualTest() throws Exception {
        this.testOperatorBoolean(NT, DT, true, ">=");
        this.testOperatorBoolean(DT, DT, true, "ge");
        this.testOperatorBoolean(DT, NT, false, "ge");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elOtherEqualToTest() throws Exception {
        this.testOperatorBoolean(DT, DT, true, "==");
        this.testOperatorBoolean(DT, NT, false, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elOtherNotEqualToTest() throws Exception {
        this.testOperatorBoolean(DT, NT, true, "!=");
        this.testOperatorBoolean(DT, DT, false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBooleanEqualToTest() throws Exception {
        this.testOperatorBoolean("true", true, true, "==");
        this.testOperatorBoolean("false", true, false, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elBooleanNotEqualToTest() throws Exception {
        this.testOperatorBoolean("false", true, true, "!=");
        this.testOperatorBoolean("false", false, false, "ne");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elEnumEqualToTest() throws Exception {
        this.testOperatorBoolean((Object)TestEnum.APPLE, "APPLE", true, "==");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "PEAR", true, "eq");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "APPLE", false, "==");
        this.testOperatorBoolean((Object)TestEnum.APPLE, "PEAR", false, "eq");
    }

    @Test
    @TargetVehicle(value="jsp")
    public void elEnumNotEqualToTest() throws Exception {
        this.testOperatorBoolean((Object)TestEnum.APPLE, "PEAR", true, "!=");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "APPLE", true, "ne");
        this.testOperatorBoolean((Object)TestEnum.APPLE, "APPLE", false, "!=");
        this.testOperatorBoolean((Object)TestEnum.PEAR, "PEAR", false, "ne");
    }

    private void testOperatorBoolean(BigDecimal testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"BigDecimal\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are BigDecimal and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"BigDecimal\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(BigInteger testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"BigInteger\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logTrace((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are BigInteger and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"BigInteger\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Float testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"Float\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logTrace((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are Float and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"Float\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Double testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"Double\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logTrace((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are Double and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"Double\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Long testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"Long\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof BigInteger || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logTrace((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are Long and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"Long\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Integer testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"Integer\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Number)) continue;
            if (testNum instanceof BigDecimal || testNum instanceof Float || testNum instanceof BigInteger || testNum instanceof Long || testNum instanceof Double) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logTrace((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are Integer and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"Integer\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Short testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"Short\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Short) && !(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logTrace((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are Short and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"Short\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Byte testVal, Boolean expectedVal, String booleanOperator) throws Exception {
        for (int i = 0; this.numberList.size() > i; ++i) {
            boolean pass;
            TestUtil.logTrace((String)"*** Start \"Byte\" Test Sequence ***");
            Object testNum = this.numberList.get(i);
            if (!(testNum instanceof Byte)) {
                String skipType = testNum.getClass().getSimpleName();
                TestUtil.logTrace((String)("Skip " + skipType + " Data type already tested for this in the " + skipType + " tests."));
                continue;
            }
            NameValuePair[] values = NameValuePair.buildNameValuePair(testVal, testNum);
            try {
                String expr = ExprEval.buildElExpr(false, booleanOperator);
                TestUtil.logTrace((String)("expression to be evaluated is " + expr));
                TestUtil.logTrace((String)("types are Byte and " + testNum.getClass().getName()));
                Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
                TestUtil.logTrace((String)("result is " + result.toString()));
                pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            finally {
                ExprEval.cleanup();
                TestUtil.logTrace((String)"*** End \"Byte\" Test Sequence ***");
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private void testOperatorBoolean(Object testValOne, Object testValTwo, Boolean expectedVal, String booleanOperator) throws Exception {
        boolean pass;
        NameValuePair[] values = NameValuePair.buildNameValuePair(testValOne, testValTwo);
        try {
            TestUtil.logTrace((String)"*** Start \"String\" Test Sequence ***");
            String expr = ExprEval.buildElExpr(false, booleanOperator);
            TestUtil.logTrace((String)("expression to be evaluated is " + expr));
            TestUtil.logTrace((String)"types are String and String");
            Object result = ExprEval.evaluateValueExpression(expr, values, Object.class);
            TestUtil.logTrace((String)("result is " + result.toString()));
            pass = ExprEval.compareClass(result, Boolean.class) && ((Boolean)result).equals(expectedVal);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
            TestUtil.logTrace((String)"*** End \"String\" Test Sequence ***");
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    private static class DougType
    implements Comparable {
        private DougType() {
        }

        public String toString() {
            return "Beta";
        }

        public int compareTo(Object o) {
            if (o == null) {
                return -1;
            }
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof DougType;
        }

        public int hashCode() {
            return 42;
        }
    }

    private static class NickType
    implements Comparable {
        private NickType() {
        }

        public String toString() {
            return "Gamma";
        }

        public int compareTo(Object o) {
            if (o == null) {
                return -1;
            }
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return o instanceof NickType;
        }

        public int hashCode() {
            return 42;
        }
    }

    private static enum TestEnum {
        APPLE,
        PEAR;

    }
}

