/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmsconsumertests;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmsconsumertests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Topic topic = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSConsumer consumer = null;
    private transient JMSProducer producer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList queues = null;
    ArrayList connections = null;
    boolean queueTest = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new Exception("setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            TestUtil.logMsg((String)"Close JMSContext");
            if (this.context != null) {
                this.context.close();
            }
            if (this.queueTest) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            TestUtil.logMsg((String)"Close all connections and resources");
            this.tool.closeAllConnections(this.connections);
            this.tool.closeAllResources();
            this.producer = null;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new Exception("cleanup failed!", e);
        }
    }

    public void queueReceiveTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive() to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive();
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Send and receive the TextMessage again");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long timeout) to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Send and receive the TextMessage again");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveNoWait() to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage == null) {
                TestUtil.logMsg((String)"Did not receive message (THIS IS OK)");
                TestUtil.logMsg((String)"Now block and wait for message via JMSConsumer.receive()");
                actTextMessage = (TextMessage)this.consumer.receive();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage on blocking receive");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Now don't send a message at all");
            TestUtil.logMsg((String)"Calling receiveNoWait() again to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage != null) {
                TestUtil.logErr((String)"actTextMessage != NULL (expected actTextMessage=NULL)");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueReceiveTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueReceiveTests failed");
        }
    }

    public void queueReceiveBodyTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(String.class) to receive message as a String");
            String actMessage = (String)this.consumer.receiveBody(String.class);
            if (actMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in String");
            if (actMessage.equals(message)) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + message + ", received " + actMessage));
                pass = false;
            }
            TestUtil.logMsg((String)"Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            TestUtil.logMsg((String)"Send and receive the ObjectMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(StringBuffer.class, long) to receive message as a StringBuffer");
            StringBuffer actSbuffer = (StringBuffer)this.consumer.receiveBody(StringBuffer.class, this.timeout);
            if (actSbuffer == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Check the value in StringBuffer");
            if (actSbuffer.toString().equals(expSbuffer.toString())) {
                TestUtil.logMsg((String)"ObjectMessage is correct");
            } else {
                TestUtil.logErr((String)("ObjectMessage is incorrect expected " + expSbuffer + ", received " + actSbuffer));
                pass = false;
            }
            TestUtil.logMsg((String)"Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            TestUtil.logMsg((String)"Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(byte[].class, long) to receive message as a byte array");
            byte[] bytes = (byte[])this.consumer.receiveBody(byte[].class, this.timeout);
            if (bytes == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            try {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(bytes));
                TestUtil.logMsg((String)"Check the values in BytesMessage");
                if (di.readByte() == 1) {
                    TestUtil.logMsg((String)"bytevalue is correct");
                } else {
                    TestUtil.logMsg((String)"bytevalue is incorrect");
                    pass = false;
                }
                if (di.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
                try {
                    byte by = di.readByte();
                }
                catch (EOFException e) {
                    TestUtil.logMsg((String)"Caught expected EOFException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            TestUtil.logMsg((String)"Send and receive the MapMessage");
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBodyNoWait(Map.class) to receive message as a Map");
            Map map = (Map)this.consumer.receiveBodyNoWait(Map.class);
            if (map == null) {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    map = (Map)this.consumer.receiveBodyNoWait(Map.class);
                    if (map != null) break;
                }
            }
            if (map == null) {
                TestUtil.logErr((String)"Did not receive MapMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in MapMessage");
                TestUtil.logMsg((String)("map.size()=" + map.size()));
                if (map.size() != 2) {
                    TestUtil.logErr((String)("Map size is " + map.size() + ", expected 2"));
                    pass = false;
                }
                Iterator it = map.keySet().iterator();
                String name = null;
                while (it.hasNext()) {
                    name = (String)it.next();
                    if (name.equals("booleanvalue")) {
                        if (((Boolean)map.get(name)).booleanValue()) {
                            TestUtil.logMsg((String)"booleanvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if ((Integer)map.get(name) == 10) {
                            TestUtil.logMsg((String)"intvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueReceiveBodyTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueReceiveBodyTests failed");
        }
    }

    public void queueReceiveBodyExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create ObjectMessage of type StringBuffer");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            TestUtil.logMsg((String)"Send and receive the ObjectMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass HashMap.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            TestUtil.logMsg((String)"Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBodyNoWait(Class<T>) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass Boolean.class as parameter to receiveBodyNoWait() expect MessageFormatRuntimeException");
            try {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    if (this.consumer.receiveBodyNoWait(Boolean.class) != null) break;
                }
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(Map.class, long) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send(this.destination, (Message)sMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody() on a StreamMessage expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send Message");
            Message msg = this.context.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueReceiveBodyExceptionTests");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(this.destination, msg);
            long deliveryTime = msg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody() on a Message expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueReceiveBodyExceptionTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueReceiveBodyExceptionTests failed");
        }
    }

    public void queueGetMessageSelectorTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = true;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Get message selector expression by calling getMessageSelector() API");
            String msgsel = this.consumer.getMessageSelector();
            TestUtil.logMsg((String)"Expecting message selector to be NULL since we didn't set it");
            if (msgsel != null) {
                TestUtil.logErr((String)("Message selector is NOT NULL (unexpected): <msgsel=" + msgsel + ">, expected NULL"));
                pass = false;
            }
            this.consumer.close();
            TestUtil.logMsg((String)"Create JMSConsumer with message selector 'lastMessage = TRUE'");
            this.consumer = this.context.createConsumer(this.destination, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Get message selector expression by calling getMessageSelector() API");
            msgsel = this.consumer.getMessageSelector();
            TestUtil.logMsg((String)"Expecting message selector to be NOT NULL since we set it to 'lastMessage = TRUE'");
            if (msgsel == null) {
                TestUtil.logErr((String)"Message selector is NULL (unexpected): <msgsel=null>, expected 'lastMessage = TRUE'");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueGetMessageSelectorTest", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("queueGetMessageSelectorTest failed");
        }
    }

    public void queueCloseTest() throws Exception {
        boolean pass;
        block6: {
            pass = true;
            String message = "Where are you!";
            try {
                TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.cf = this.tool.getConnectionFactory();
                this.destination = this.tool.getDefaultDestination();
                this.queue = (Queue)this.destination;
                TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
                this.context = this.cf.createContext(this.user, this.password, 1);
                this.queueTest = true;
                TestUtil.logMsg((String)"Create JMSProducer");
                this.producer = this.context.createProducer();
                TestUtil.logMsg((String)"Create JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Create TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueCloseTest");
                TestUtil.logMsg((String)"Send the TextMessage");
                TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                TestUtil.logMsg((String)"Close the JMSConsumer");
                this.consumer.close();
                TestUtil.logMsg((String)"Try receiving a message on a closed JMSConsumer (expect JMSRuntimeException or no message)");
                try {
                    TextMessage actTextMessage = (TextMessage)this.consumer.receive();
                    if (actTextMessage != null) {
                        TestUtil.logErr((String)("Received a message (expected no message), <recvdMsg=" + actTextMessage + ">"));
                        pass = false;
                        break block6;
                    }
                    TestUtil.logMsg((String)"Did not receive a message (correct)");
                }
                catch (JMSRuntimeException e) {
                    TestUtil.logMsg((String)("Caught expected JMSRuntimeException: " + e));
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("queueCloseTest", e);
            }
        }
        if (!pass) {
            throw new Exception("queueCloseTest failed");
        }
    }

    public void topicReceiveTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive() to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive();
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Send and receive the TextMessage again");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receive(long timeout) to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Send and receive the TextMessage again");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveNoWait() to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage == null) {
                TestUtil.logMsg((String)"Did not receive message (THIS IS OK)");
                TestUtil.logMsg((String)"Now block and wait for message via JMSConsumer.receive()");
                actTextMessage = (TextMessage)this.consumer.receive();
            }
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage on blocking receive");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
            TestUtil.logMsg((String)"Now don't send a message at all");
            TestUtil.logMsg((String)"Calling receiveNoWait() again to receive TextMessage");
            actTextMessage = (TextMessage)this.consumer.receiveNoWait();
            if (actTextMessage != null) {
                TestUtil.logErr((String)"actTextMessage != NULL (expected actTextMessage=NULL)");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicReceiveTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicReceiveTests failed");
        }
    }

    public void topicReceiveBodyTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(String.class) to receive message as a String");
            String actMessage = (String)this.consumer.receiveBody(String.class);
            if (actMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in String");
            if (actMessage.equals(message)) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + message + ", received " + actMessage));
                pass = false;
            }
            TestUtil.logMsg((String)"Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            TestUtil.logMsg((String)"Send and receive the ObjectMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(StringBuffer.class, long) to receive message as a StringBuffer");
            StringBuffer actSbuffer = (StringBuffer)this.consumer.receiveBody(StringBuffer.class, this.timeout);
            if (actSbuffer == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            TestUtil.logMsg((String)"Check the value in StringBuffer");
            if (actSbuffer.toString().equals(expSbuffer.toString())) {
                TestUtil.logMsg((String)"ObjectMessage is correct");
            } else {
                TestUtil.logErr((String)("ObjectMessage is incorrect expected " + expSbuffer + ", received " + actSbuffer));
                pass = false;
            }
            TestUtil.logMsg((String)"Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            TestUtil.logMsg((String)"Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(byte[].class, long) to receive message as a byte array");
            byte[] bytes = (byte[])this.consumer.receiveBody(byte[].class, this.timeout);
            if (bytes == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            try {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(bytes));
                TestUtil.logMsg((String)"Check the values in BytesMessage");
                if (di.readByte() == 1) {
                    TestUtil.logMsg((String)"bytevalue is correct");
                } else {
                    TestUtil.logMsg((String)"bytevalue is incorrect");
                    pass = false;
                }
                if (di.readInt() == 22) {
                    TestUtil.logMsg((String)"intvalue is correct");
                } else {
                    TestUtil.logMsg((String)"intvalue is incorrect");
                    pass = false;
                }
                try {
                    byte by = di.readByte();
                }
                catch (EOFException e) {
                    TestUtil.logMsg((String)"Caught expected EOFException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            TestUtil.logMsg((String)"Send and receive the MapMessage");
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBodyNoWait(Map.class) to receive message as a Map");
            Map map = (Map)this.consumer.receiveBodyNoWait(Map.class);
            if (map == null) {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    map = (Map)this.consumer.receiveBodyNoWait(Map.class);
                    if (map != null) break;
                }
            }
            if (map == null) {
                TestUtil.logErr((String)"Did not receive MapMessage");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Check the values in MapMessage");
                TestUtil.logMsg((String)("map.size()=" + map.size()));
                if (map.size() != 2) {
                    TestUtil.logErr((String)("Map size is " + map.size() + ", expected 2"));
                    pass = false;
                }
                Iterator it = map.keySet().iterator();
                String name = null;
                while (it.hasNext()) {
                    name = (String)it.next();
                    if (name.equals("booleanvalue")) {
                        if (((Boolean)map.get(name)).booleanValue()) {
                            TestUtil.logMsg((String)"booleanvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if ((Integer)map.get(name) == 10) {
                            TestUtil.logMsg((String)"intvalue is correct");
                            continue;
                        }
                        TestUtil.logErr((String)"intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Unexpected name of [" + name + "] in MapMessage"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicReceiveBodyTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicReceiveBodyTests failed");
        }
    }

    public void topicReceiveBodyExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            TestUtil.logMsg((String)"Send and receive the TextMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create ObjectMessage of type StringBuffer");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            TestUtil.logMsg((String)"Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            TestUtil.logMsg((String)"Send and receive the ObjectMessage");
            TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(Class<T>) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass HashMap.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            TestUtil.logMsg((String)"Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            TestUtil.logMsg((String)"Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBodyNoWait(Class<T>) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass Boolean.class as parameter to receiveBodyNoWait() expect MessageFormatRuntimeException");
            try {
                for (int i = 0; i < 5; ++i) {
                    TestUtil.sleepSec((int)1);
                    if (this.consumer.receiveBodyNoWait(Boolean.class) != null) break;
                }
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            TestUtil.logMsg((String)"Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody(Map.class, long) to receive message as wrong type");
            TestUtil.logMsg((String)"Pass Boolean.class as parameter to receiveBody() expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            TestUtil.logMsg((String)"Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send(this.destination, (Message)sMsg);
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody() on a StreamMessage expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Send Message");
            Message msg = this.context.createMessage();
            TestUtil.logMsg((String)"Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "topicReceiveBodyExceptionTests");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(this.destination, msg);
            long deliveryTime = msg.getJMSDeliveryTime();
            TestUtil.logMsg((String)"Call JMSConsumer.receiveBody() on a Message expect MessageFormatRuntimeException");
            try {
                this.consumer.receiveBody(Boolean.class, this.timeout);
                TestUtil.logErr((String)"Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicReceiveBodyExceptionTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicReceiveBodyExceptionTests failed");
        }
    }

    public void topicGetMessageSelectorTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_T");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.queueTest = false;
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.context.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            TestUtil.logMsg((String)"Get message selector expression by calling getMessageSelector() API");
            String msgsel = this.consumer.getMessageSelector();
            TestUtil.logMsg((String)"Expecting message selector to be NULL since we didn't set it");
            if (msgsel != null) {
                TestUtil.logErr((String)("Message selector is NOT NULL (unexpected): <msgsel=" + msgsel + ">, expected NULL"));
                pass = false;
            }
            this.consumer.close();
            TestUtil.logMsg((String)"Create JMSConsumer with message selector 'lastMessage = TRUE'");
            this.consumer = this.context.createConsumer(this.destination, "lastMessage = TRUE");
            TestUtil.logMsg((String)"Get message selector expression by calling getMessageSelector() API");
            msgsel = this.consumer.getMessageSelector();
            TestUtil.logMsg((String)"Expecting message selector to be NOT NULL since we set it to 'lastMessage = TRUE'");
            if (msgsel == null) {
                TestUtil.logErr((String)"Message selector is NULL (unexpected): <msgsel=null>, expected 'lastMessage = TRUE'");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicGetMessageSelectorTest", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("topicGetMessageSelectorTest failed");
        }
    }

    public void topicCloseTest() throws Exception {
        boolean pass;
        block6: {
            pass = true;
            String message = "Where are you!";
            try {
                TestUtil.logMsg((String)"Setup JmsTool for COMMON_T");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.cf = this.tool.getConnectionFactory();
                this.destination = this.tool.getDefaultDestination();
                this.topic = (Topic)this.destination;
                TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
                this.context = this.cf.createContext(this.user, this.password, 1);
                this.queueTest = false;
                TestUtil.logMsg((String)"Create JMSProducer");
                this.producer = this.context.createProducer();
                TestUtil.logMsg((String)"Create JMSConsumer");
                this.consumer = this.context.createConsumer(this.destination);
                TestUtil.logMsg((String)"Create TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicCloseTest");
                TestUtil.logMsg((String)"Send the TextMessage");
                TestUtil.logMsg((String)"Call JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                TestUtil.logMsg((String)"Close the JMSConsumer");
                this.consumer.close();
                TestUtil.logMsg((String)"Try receiving a message on a closed JMSConsumer (expect JMSRuntimeException or no message)");
                try {
                    TextMessage actTextMessage = (TextMessage)this.consumer.receive();
                    if (actTextMessage != null) {
                        TestUtil.logErr((String)("Received a message (expected no message), <recvdMsg=" + actTextMessage + ">"));
                        pass = false;
                        break block6;
                    }
                    TestUtil.logMsg((String)"Did not receive a message (correct)");
                }
                catch (JMSRuntimeException e) {
                    TestUtil.logMsg((String)("Caught expected JMSRuntimeException: " + e));
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("topicCloseTest", e);
            }
        }
        if (!pass) {
            throw new Exception("topicCloseTest failed");
        }
    }
}

