/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.ibanno;

import com.sun.ts.tests.common.connector.util.AppException;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.XAMessageXAResource;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkContext;
import jakarta.resource.spi.work.WorkContextProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.XAResource;

public class IBAnnoMessageWork
implements Work,
WorkContextProvider {
    private String name;
    private boolean stop = false;
    private MessageEndpointFactory factory;
    private XAMessageXAResource msgxa = new XAMessageXAResource();
    private MessageEndpoint ep2;
    private List<WorkContext> contextsList = new ArrayList<WorkContext>();

    public IBAnnoMessageWork(String name, MessageEndpointFactory factory) {
        this.factory = factory;
        this.name = name;
        Debug.trace("IBAnnoMessageWork constructor");
    }

    public void run() {
        while (!this.stop) {
            try {
                MessageEndpoint ep1 = this.factory.createEndpoint(null);
                this.ep2 = this.factory.createEndpoint(null);
                MessageEndpoint xaep = this.factory.createEndpoint((XAResource)this.msgxa);
                if (!this.ep2.equals(ep1)) {
                    Debug.trace("IBAnnoMessageWork XA Unique MessageEndpoint returned");
                }
                this.chkMessageEndpointImpl(ep1);
                Method onMessage = this.getOnMessageMethod();
                ep1.beforeDelivery(onMessage);
                ((TSMessageListenerInterface)ep1).onMessage("IBAnnoMessageWork XA Message To MDB");
                ep1.afterDelivery();
                Method onMessagexa = this.getOnMessageMethod();
                xaep.beforeDelivery(onMessagexa);
                ((TSMessageListenerInterface)xaep).onMessage("IBAnnoMessageWork XA Non Transacted Message To MDB1");
                xaep.afterDelivery();
                boolean de = this.factory.isDeliveryTransacted(onMessagexa);
                this.callSysExp();
                this.callAppExp();
                if (!de) {
                    Debug.trace("IBAnnoMessageWork XA MDB1 delivery is not transacted");
                    break;
                }
                Debug.trace("IBAnnoMessageWork XA MDB1 delivery is transacted");
                break;
            }
            catch (AppException ex) {
                ex.printStackTrace();
            }
            catch (UnavailableException ex) {
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException ns) {
                ns.printStackTrace();
            }
            catch (ResourceException re) {
                re.printStackTrace();
            }
        }
    }

    public void callSysExp() {
        try {
            Debug.trace(" in  IBAnnoMessageWork.callSysExp()");
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw SysException from IBAnnoMessageWork");
        }
        catch (NoSuchMethodException e) {
            System.out.println("IBAnnoMessageWork: NoSuchMethodException");
            e.getMessage();
            e.printStackTrace();
        }
        catch (UnavailableException e) {
            System.out.println("IBAnnoMessageWork: UnavailableException");
            e.printStackTrace();
        }
        catch (ResourceException re) {
            System.out.println("IBAnnoMessageWork: ResourceException");
            re.printStackTrace();
        }
        catch (AppException ae) {
            System.out.println("IBAnnoMessageWork: AppException");
            ae.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("EJBException thrown by NotSupported MDB");
            ConnectorStatus.getConnectorStatus().logState("EJBException thrown by NotSupported");
            e.printStackTrace();
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public void callAppExp() {
        try {
            Debug.trace(" in  IBAnnoMessageWork.callAppExp()");
            Method onMessage = this.getOnMessageMethod();
            this.ep2.beforeDelivery(onMessage);
            ((TSMessageListenerInterface)this.ep2).onMessage("Throw AppException from IBAnnoMessageWork");
        }
        catch (AppException ejbe) {
            System.out.println("AppException thrown by NotSupported MDB");
            ConnectorStatus.getConnectorStatus().logState("AppException thrown by NotSupported");
        }
        catch (NoSuchMethodException ns) {
            ns.printStackTrace();
        }
        catch (ResourceException re) {
            re.printStackTrace();
        }
        finally {
            try {
                this.ep2.afterDelivery();
            }
            catch (ResourceException re2) {
                re2.printStackTrace();
            }
        }
    }

    public Method getOnMessageMethod() {
        Method onMessageMethod = null;
        try {
            Class<TSMessageListenerInterface> msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = new Class[]{String.class};
            onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }

    private void chkMessageEndpointImpl(MessageEndpoint ep) {
        if (ep instanceof MessageEndpoint && ep instanceof TSMessageListenerInterface) {
            Debug.trace("IBANNO XA MessageEndpoint interface implemented");
            Debug.trace("IBANNO XA TSMessageListener interface implemented");
        } else {
            Debug.trace("IBANNO XA MessageEndpoint and TSMessageListenerInterface not implemented");
        }
    }

    public List<WorkContext> getWorkContexts() {
        return this.contextsList;
    }

    public void addWorkContext(WorkContext ic) {
        this.contextsList.add(ic);
    }

    public void release() {
    }

    public void stop() {
        this.stop = true;
    }

    public String toString() {
        return this.name;
    }
}

