/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.topictests;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.DoneLatch;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.SerialTestMessageListenerImpl;
import com.sun.ts.tests.jms.common.SessionThread;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.QueueConnection;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicRequestor;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;

public class TopicTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.topictests.TopicTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    ArrayList topics = null;
    ArrayList connections = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;

    public static void main(String[] args) {
        TopicTests theTests = new TopicTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null ");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void receiveNullClosedSessionTopicTest() throws Exception {
        int waitTime = 15;
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.logMsg("Close default TopicSubscriber");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Create TopicRequestor");
            TopicRequestor qReq = new TopicRequestor(this.tool.getDefaultTopicSession(), this.tool.getDefaultTopic());
            this.logMsg("Create SessionThread");
            SessionThread sT = new SessionThread((QueueConnection)null, this.tool.getDefaultTopicConnection());
            this.logMsg("Tell SessionThread to respond to messages");
            sT.setReplyToMessages(true);
            this.logMsg("Create Subscriber in SessionThread");
            sT.createConsumer((Destination)this.tool.getDefaultTopic());
            this.logMsg("Tell receiver to keep receiving\n(it will throw an exception and stop when it receives the null message)");
            sT.setStayAlive(true);
            this.logMsg("Start the SessionThread");
            sT.start();
            this.logMsg("Send one message and receive reply");
            Message tempMsg = this.tool.getDefaultTopicSession().createMessage();
            tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "receiveNullClosedSessionTopicTest");
            qReq.request(tempMsg);
            this.logMsg("Wait " + waitTime + " seconds for receive() to start again before closing session...");
            for (int i = 0; i < 100000; ++i) {
            }
            this.logMsg("Close the SessionThread's TopicSession");
            sT.getTopicSession().close();
            this.logMsg("Wait for thread to close (will close after receiving null message)");
            sT.join();
            if (sT.isAlive()) {
                this.logErr("thread still waiting on receive() -- BAD [could be timing problem]");
                throw new Exception("receive() call still waiting");
            }
            this.logMsg("receive() properly received a null message -- GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("receiveNullClosedSessionTopicTest");
        }
    }

    public void setClientIDLateTopicTest() throws Exception {
        boolean booleanValue = true;
        boolean pass = true;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            TopicConnection tConn = (TopicConnection)this.tool.getNewConnection(1, this.user, this.password, lookup);
            this.connections.add(tConn);
            TopicSession tSess = tConn.createTopicSession(false, 1);
            Topic topic = this.tool.createNewTopic("MY_TOPIC2");
            TopicPublisher tPublisher = tSess.createPublisher(topic);
            TopicSubscriber tSub = tSess.createSubscriber(topic);
            tConn.start();
            this.logTrace("Creating 1 message");
            MapMessage messageSent = tSess.createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "setClientIDLateTopicTest");
            messageSent.setBoolean("booleanValue", booleanValue);
            this.logTrace("Sending message");
            tPublisher.publish((Message)messageSent);
            this.logTrace("Receiving message");
            MapMessage messageReceived = (MapMessage)tSub.receive(this.timeout);
            messageReceived.getBoolean("booleanValue");
            this.logTrace("Attempt to set Client ID too late");
            try {
                tConn.setClientID("setClientIDLateTopicTest");
                pass = false;
                this.logMsg("Error: Illegal state exception was not thrown");
            }
            catch (IllegalStateException is) {
                this.logTrace("Pass: IllegalStateException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logMsg("Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setClientIDLateTopicTest");
        }
    }

    public void autoAckMsgListenerTopicTest() throws Exception {
        try {
            Message messageSent = null;
            AutoAckMsgListener mListener = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.logTrace("Create and set MessageListener.");
            mListener = new AutoAckMsgListener(new DoneLatch(), this.tool.getDefaultTopicSession());
            this.tool.getDefaultTopicSubscriber().setMessageListener((MessageListener)mListener);
            this.logTrace("Send and receive two messages");
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "autoAckMsgListenerTopicTest");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultTopicPublisher().publish(messageSent);
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish(messageSent);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("waiting until message has been received by message listener...");
            mListener.monitor.waitTillDone();
            if (!mListener.getPassed()) {
                throw new Exception("failed");
            }
        }
        catch (Exception e) {
            this.logMsg("Error: " + e);
            throw new Exception("autoAckMsgListenerTopicTest", e);
        }
    }

    public void serialMsgListenerTopicTest() throws Exception {
        try {
            TextMessage[] tMsg = new TextMessage[3];
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            Topic newT = this.tool.createNewTopic("MY_TOPIC2");
            TopicSubscriber tSub1 = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic());
            TopicSubscriber tSub2 = this.tool.getDefaultTopicSession().createSubscriber(newT);
            this.logMsg("Create two message listeners");
            SerialTestMessageListenerImpl myListener1 = new SerialTestMessageListenerImpl();
            SerialTestMessageListenerImpl myListener2 = new SerialTestMessageListenerImpl();
            tSub1.setMessageListener((MessageListener)myListener1);
            tSub2.setMessageListener((MessageListener)myListener2);
            TopicPublisher tPublisher1 = this.tool.getDefaultTopicSession().createPublisher(this.tool.getDefaultTopic());
            TopicPublisher tPublisher2 = this.tool.getDefaultTopicSession().createPublisher(newT);
            for (int i = 0; i < 3; ++i) {
                this.logMsg("Create and send message " + i);
                tMsg[i] = this.tool.getDefaultTopicSession().createTextMessage();
                tMsg[i].setText("serialMsgListenerTopicTest" + i);
                tMsg[i].setStringProperty("COM_SUN_JMS_TESTNAME", "serialMsgListenerTopicTest" + i);
                if (i == 2) {
                    tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", true);
                    tPublisher1.publish((Message)tMsg[i]);
                    tPublisher2.publish((Message)tMsg[i]);
                    continue;
                }
                tMsg[i].setBooleanProperty("COM_SUN_JMS_TEST_LASTMESSAGE", false);
                if (i % 2 == 0) {
                    tPublisher1.publish((Message)tMsg[i]);
                    continue;
                }
                tPublisher2.publish((Message)tMsg[i]);
            }
            this.logMsg("Start connection");
            this.tool.getDefaultTopicConnection().start();
            myListener1.monitor.waitTillDone();
            myListener2.monitor.waitTillDone();
            if (myListener1.testFailed || myListener2.testFailed) {
                this.logMsg("Test failed in message listener");
                throw new Exception("Concurrent use of MessageListener or JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("serialMsgListenerTopicTest");
        }
    }

    public void setGetChangeClientIDTopicTest() throws Exception {
        boolean pass = true;
        TopicConnection tc2 = null;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(8, this.user, this.password, this.mode);
            TopicConnection tc = (TopicConnection)this.tool.getNewConnection(1, this.user, this.password, lookup);
            this.connections.add(tc);
            tc2 = (TopicConnection)this.tool.getNewConnection(1, this.user, this.password, lookup);
            this.connections.add(tc2);
            TestUtil.logMsg((String)"Setting clientID!");
            tc.setClientID("ctstest");
            TestUtil.logMsg((String)"Getting clientID!");
            String clientid = tc.getClientID();
            if (!clientid.equals("ctstest")) {
                TestUtil.logErr((String)("getClientID() returned " + clientid + ", expected ctstest"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"setClientID/getClientID correct");
            }
            TestUtil.logMsg((String)"Resetting clientID! (excpect IllegalStateException)");
            tc.setClientID("changeIt");
            TestUtil.logErr((String)"Failed: No exception on ClientID reset");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            TestUtil.logErr((String)("Incorrect exception received: " + e.getMessage()));
            pass = false;
        }
        catch (IllegalStateException ee) {
            TestUtil.logMsg((String)("Expected Exception received: " + ee.getMessage()));
        }
        catch (Exception eee) {
            TestUtil.logErr((String)("Incorrect exception received: " + eee.getMessage()));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Set clientID on second connection to value of clientID on first connection");
            TestUtil.logMsg((String)"Expect InvalidClientIDException");
            tc2.setClientID("ctstest");
            TestUtil.logErr((String)"Failed: No exception on ClientID when one already exists");
            pass = false;
        }
        catch (InvalidClientIDException e) {
            TestUtil.logMsg((String)("Expected exception received: " + e.getMessage()));
        }
        catch (Exception eee) {
            TestUtil.logErr((String)("Incorrect exception received: " + eee.getMessage()));
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetChangeClientIDTopicTest");
        }
    }

    public void setGetExceptionListenerTest() throws Exception {
        boolean pass = true;
        Object tc = null;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for TOPIC");
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            TestUtil.logMsg((String)"Create ExceptionListener");
            ExceptionListener foo = new ExceptionListener(){

                public void onException(JMSException e) {
                }
            };
            TestUtil.logMsg((String)"Call setExceptionListener on Connection object");
            this.tool.getDefaultTopicConnection().setExceptionListener(foo);
            ExceptionListener foo2 = this.tool.getDefaultTopicConnection().getExceptionListener();
            if (!foo2.equals(foo)) {
                TestUtil.logErr((String)"getExceptionListener doesn't match setExceptionListener");
                pass = false;
            }
        }
        catch (Exception eee) {
            TestUtil.logErr((String)("Unexpected exception received: " + eee.getMessage()));
            pass = false;
        }
        if (!pass) {
            throw new Exception("setGetExceptionListenerTest");
        }
    }

    public void reverseReceiveClientAckTest() throws Exception {
        boolean pass = true;
        try {
            int i;
            int i2;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            Topic[] t = new Topic[3];
            TopicPublisher[] tPublisher = new TopicPublisher[3];
            TopicSubscriber[] tSubscriber = new TopicSubscriber[3];
            Message[] msg = new Message[3];
            for (i2 = 0; i2 < 3; ++i2) {
                TestUtil.logMsg((String)("Creating Topic " + i2 + " of 2 (3 total)"));
                t[i2] = this.tool.createNewTopic("testT" + i2);
            }
            TestUtil.logMsg((String)"Creating 3 senders");
            for (i2 = 0; i2 < 3; ++i2) {
                TestUtil.logMsg((String)("sender " + i2));
                tPublisher[i2] = this.tool.getDefaultTopicSession().createPublisher(t[i2]);
            }
            TestUtil.logMsg((String)"Creating CLIENT_ACKNOWLEDGE session for receiving");
            TopicSession receiveSession = this.tool.getDefaultTopicConnection().createTopicSession(false, 2);
            TestUtil.logMsg((String)"Creating 3 receivers in receive session");
            for (int i3 = 0; i3 < 3; ++i3) {
                TestUtil.logMsg((String)("receiver " + i3));
                tSubscriber[i3] = receiveSession.createSubscriber(t[i3]);
            }
            this.tool.getDefaultTopicConnection().start();
            Message tempMsg = null;
            for (i = 0; i < 3; ++i) {
                TestUtil.logMsg((String)("Sending message " + i));
                tempMsg = this.tool.getDefaultTopicSession().createMessage();
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "reverseReceiveClientAckTest");
                tPublisher[i].publish(tempMsg);
            }
            TestUtil.logMsg((String)"Receive messages 0-2 in reverse order");
            for (i = 2; i >= 0; --i) {
                TestUtil.logMsg((String)("Receive message " + i));
                msg[i] = tSubscriber[i].receive(this.timeout);
                if (msg[i] == null) {
                    TestUtil.logErr((String)("Did not receive message from subscriber[" + i + "]"));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("msg = " + msg[i]));
                    TestUtil.logMsg((String)("Acknowledge message " + i));
                    msg[i].acknowledge();
                }
                if (i != 2) continue;
                TestUtil.logMsg((String)"session.recover()");
                receiveSession.recover();
            }
            TestUtil.logMsg((String)"Try receiving message from all subscribers again (should not receive any)");
            for (i = 2; i >= 0; --i) {
                msg[i] = tSubscriber[i].receive(this.timeout);
                if (msg[i] == null) continue;
                TestUtil.logErr((String)("Received message from subscriber[" + i + "], expected none"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("reverseReceiveClientAckTest");
        }
        if (!pass) {
            throw new Exception("reverseReceiveClientAckTest");
        }
    }

    public void clientAckTopicTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage sent1 = null;
            TextMessage sent2 = null;
            TextMessage sent3 = null;
            TextMessage sent4 = null;
            TextMessage rec2 = null;
            TextMessage rec4 = null;
            TopicSession tSess = null;
            TopicSubscriber tSub = null;
            TopicPublisher tPublisher = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicSession().close();
            tSess = this.tool.getDefaultTopicConnection().createTopicSession(false, 2);
            TestUtil.logMsg((String)"Start connection");
            this.tool.getDefaultTopicConnection().start();
            sent1 = tSess.createTextMessage();
            sent1.setText("test message 1");
            sent1.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest1");
            sent2 = tSess.createTextMessage();
            sent2.setText("test message 2");
            sent2.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest2");
            sent3 = tSess.createTextMessage();
            sent3.setText("test message 3");
            sent3.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest3");
            sent4 = tSess.createTextMessage();
            sent4.setText("test message 4");
            sent4.setStringProperty("COM_SUN_JMS_TESTNAME", "clientAckTopicTest4");
            tSub = tSess.createSubscriber(this.tool.getDefaultTopic());
            tPublisher = tSess.createPublisher(this.tool.getDefaultTopic());
            TestUtil.logTrace((String)"Send three messages");
            tPublisher.publish((Message)sent1);
            tPublisher.publish((Message)sent2);
            tPublisher.publish((Message)sent3);
            TestUtil.logTrace((String)"Receive three messages");
            tSub.receive(this.timeout);
            TestUtil.logTrace((String)"Received the first message");
            rec2 = (TextMessage)tSub.receive(this.timeout);
            TestUtil.logTrace((String)"Received the second message");
            tSub.receive(this.timeout);
            TestUtil.logTrace((String)"Received the third message");
            TestUtil.logTrace((String)"Acknowledging the second message");
            rec2.acknowledge();
            TestUtil.logTrace((String)"Send the fourth message");
            tPublisher.publish((Message)sent4);
            TestUtil.logTrace((String)"Receive the fourth message");
            rec4 = (TextMessage)tSub.receive(this.timeout);
            TestUtil.logTrace((String)"Received the fourth message");
            TestUtil.logTrace((String)"Call session.recover()");
            tSess.recover();
            TestUtil.logTrace((String)"Attempt to receive unacked message - the fourth message again");
            rec4 = (TextMessage)tSub.receive(this.timeout);
            if (rec4 == null) {
                pass = false;
                TestUtil.logErr((String)"Did not receive unacked message");
            } else {
                if (!rec4.getText().equals(sent4.getText())) {
                    pass = false;
                    TestUtil.logErr((String)("Received wrong message: " + rec4.getText()));
                } else {
                    TestUtil.logMsg((String)("Re-received message: " + rec4.getText()));
                }
                TestUtil.logTrace((String)"Acknowledge the received message");
                rec4.acknowledge();
            }
            if (!pass) {
                throw new Exception("clientAckTopicTest Failed!!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: ", (Throwable)e);
            throw new Exception("clientAckTopicTest", e);
        }
    }

    public void nonAckMsgsRedeliveredTopicTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg;
            int i;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            TestUtil.logTrace((String)"Close TopicSubscriber in default session -- only want one for Topic");
            this.tool.getDefaultTopicSubscriber().close();
            this.tool.getDefaultTopicSession().close();
            TopicSession tSession = this.tool.getDefaultTopicConnection().createTopicSession(false, 2);
            TopicSubscriber tSubscriber = tSession.createSubscriber(this.tool.getDefaultTopic());
            TopicPublisher tPublisher = tSession.createPublisher(this.tool.getDefaultTopic());
            this.tool.getDefaultTopicConnection().start();
            for (i = 0; i < 3; ++i) {
                tempMsg = tSession.createTextMessage();
                tempMsg.setText("test message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "nonAckMsgsRedeliveredTopicTest" + i);
                tPublisher.publish((Message)tempMsg);
                TestUtil.logTrace((String)("sent message " + i));
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)tSubscriber.receive(this.timeout);
                if (tempMsg == null) {
                    pass = false;
                    TestUtil.logErr((String)("Did not receive message " + i));
                    continue;
                }
                TestUtil.logTrace((String)("received message " + i));
            }
            TestUtil.logTrace((String)"Call session recover()");
            tSession.recover();
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)tSubscriber.receive(this.timeout);
                if (tempMsg != null) {
                    tempMsg.acknowledge();
                }
                if (tempMsg == null) {
                    pass = false;
                    TestUtil.logErr((String)("Did not receive message " + i));
                    continue;
                }
                TestUtil.logTrace((String)("received message \"" + tempMsg.getText() + "\" second time"));
            }
            tempMsg = (TextMessage)tSubscriber.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)"Should not have received a message");
                pass = false;
            }
            tPublisher.close();
            tSubscriber.close();
            tSession.close();
            if (!pass) {
                throw new Exception("nonAckMsgsRedeliveredTopicTest failed!!!");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"nonAckMsgsRedeliveredTopicTest failed: ", (Throwable)e);
            throw new Exception("nonAckMsgsRedeliveredTopicTest failed", e);
        }
    }

    public void topicRequestorSimpleSendAndRecvTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TopicRequestor treq = null;
            TestUtil.logMsg((String)"Set up JmsTool for TOPIC");
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("This is the request message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "topicRequestorSimpleSendAndRecvTest");
            TestUtil.logMsg((String)"Set up MessageListener");
            this.tool.getDefaultTopicSubscriber().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultTopicSession()));
            TestUtil.logMsg((String)"Set up TopicRequestor for request/response message exchange");
            TopicSession newts = this.tool.getDefaultTopicConnection().createTopicSession(false, 1);
            treq = new TopicRequestor(newts, this.tool.getDefaultTopic());
            TestUtil.logMsg((String)"Send message request and receive message response using TopicRequestor");
            TestUtil.logMsg((String)("Message request text: \"" + messageSent.getText() + "\""));
            messageReceived = (TextMessage)treq.request((Message)messageSent);
            TestUtil.logMsg((String)("Message response text: \"" + messageReceived.getText() + "\""));
            if (messageReceived.getText().equals("This is the response message")) {
                TestUtil.logMsg((String)"Received correct response message");
            } else {
                TestUtil.logErr((String)"Received incorrect response message");
                pass = false;
            }
            TestUtil.logMsg((String)"Close TopicRequestor");
            treq.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicRequestorSimpleSendAndRecvTest");
        }
        if (!pass) {
            throw new Exception("topicRequestorSimpleSendAndRecvTest failed");
        }
    }

    public void topicRequestorExceptionTests() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Topic invalidDest = null;
            TopicRequestor treq = null;
            TestUtil.logMsg((String)"Set up JmsTool for TOPIC");
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Set up MessageListener");
            this.tool.getDefaultTopicSubscriber().setMessageListener((MessageListener)new RequestorMsgListener(this.tool.getDefaultTopicSession()));
            TopicSession newts = this.tool.getDefaultTopicConnection().createTopicSession(false, 1);
            try {
                TestUtil.logMsg((String)"Set up TopicRequestor with InvalidDestination");
                treq = new TopicRequestor(newts, invalidDest);
                TestUtil.logErr((String)"Didn't throw InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException e) {
                TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
            }
            try {
                TestUtil.logMsg((String)"Set up TopicRequestor with a closed TopicSession");
                newts.close();
                treq = new TopicRequestor(newts, this.tool.getDefaultTopic());
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
            this.tool.closeAllConnections(this.connections);
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logMsg((String)"Set up TopicRequestor");
            treq = new TopicRequestor(this.tool.getDefaultTopicSession(), this.tool.getDefaultTopic());
            TestUtil.logMsg((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "topicRequestorExceptionTests");
            TestUtil.logMsg((String)"Close TopicRequestor");
            treq.close();
            TestUtil.logMsg((String)"Try a request/response message exchange on a closed TopicRequestor");
            try {
                messageReceived = (TextMessage)treq.request((Message)messageSent);
                if (messageReceived != null) {
                    TestUtil.logMsg((String)("messageReceived=" + messageReceived.getText()));
                }
                TestUtil.logErr((String)"Didn't throw JMSException");
                pass = false;
            }
            catch (JMSException e) {
                TestUtil.logMsg((String)"Caught expected JMSException");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("topicRequestorExceptionTests");
        }
        if (!pass) {
            throw new Exception("topicRequestorExceptionTests failed");
        }
    }

    public static class AutoAckMsgListener
    implements MessageListener {
        private boolean passed;
        TopicSession session;
        final DoneLatch monitor;

        public AutoAckMsgListener(DoneLatch latch, TopicSession tSession) {
            this.monitor = latch;
            this.session = tSession;
        }

        public boolean getPassed() {
            return this.passed;
        }

        public void onMessage(Message message) {
            try {
                if (!message.getBooleanProperty("lastMessage")) {
                    TestUtil.logTrace((String)"Received first message.");
                    if (message.getJMSRedelivered()) {
                        TestUtil.logMsg((String)"Error: received first message twice");
                        this.passed = false;
                    }
                } else if (!message.getJMSRedelivered()) {
                    TestUtil.logTrace((String)"Received second message. Calling recover()");
                    this.session.recover();
                } else {
                    TestUtil.logTrace((String)"Received second message again as expected");
                    this.passed = true;
                    this.monitor.allDone();
                }
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)("Exception caught in message listener:\n" + e));
                this.passed = false;
                this.monitor.allDone();
            }
        }
    }

    public static class RequestorMsgListener
    implements MessageListener {
        TopicSession session = null;
        boolean pass = false;

        public RequestorMsgListener(TopicSession session) {
            this.session = session;
        }

        public boolean getPass() {
            return this.pass;
        }

        public void onMessage(Message message) {
            try {
                TestUtil.logMsg((String)"RequestorMsgListener.onMessage()");
                if (message instanceof TextMessage) {
                    TextMessage tmsg = (TextMessage)message;
                    TestUtil.logMsg((String)("Request message=" + tmsg.getText()));
                    if (tmsg.getText().equals("This is the request message")) {
                        TestUtil.logMsg((String)"Received request message is correct");
                        this.pass = true;
                    } else {
                        TestUtil.logErr((String)"Received request message is incorrect");
                        this.pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"Received request message is not a TextMessage");
                    this.pass = false;
                }
                Topic replyT = (Topic)message.getJMSReplyTo();
                TopicPublisher publisher = this.session.createPublisher(replyT);
                TextMessage responseMsg = this.session.createTextMessage();
                responseMsg.setText("This is the response message");
                responseMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "RequestorMsgListenerResponseMsg");
                TestUtil.logMsg((String)"Sending back response message");
                publisher.publish((Message)responseMsg);
            }
            catch (JMSException e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)("Exception caught in RequestorMsgListener:\n" + e));
            }
        }
    }
}

