/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.msginflow;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Properties;
import java.util.Vector;

public class MDBClient
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con = null;
    private String whitebox_tx = null;
    private String whitebox_tx_param = null;
    private String whitebox_ibanno_no_md = null;
    private TSDataSource ds1 = null;
    private TSDataSource ds2 = null;
    private TSDataSource ds3 = null;
    private String uname = null;
    private String password = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.whitebox_tx = p.getProperty("whitebox-tx");
        this.whitebox_tx_param = p.getProperty("whitebox-tx-param");
        this.whitebox_ibanno_no_md = p.getProperty("whitebox-ibanno_no_md");
        this.logMsg("Using: " + this.whitebox_tx);
        this.logMsg("Using: " + this.whitebox_tx_param);
        this.logMsg("Using: " + this.whitebox_ibanno_no_md);
        this.uname = p.getProperty("rauser1");
        this.password = p.getProperty("rapassword1");
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Exception constructing DBSupport object: " + e.getMessage());
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.whitebox_tx);
            this.ds2 = (TSDataSource)this.nctx.lookup(this.whitebox_tx_param);
            this.ds3 = (TSDataSource)this.nctx.lookup(this.whitebox_ibanno_no_md);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testReceiveMessage() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logTrace((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx Message To MDB";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            TestUtil.logTrace((String)("^^^^^^^^^^^^^^^^^^^^^^^^^^^" + str));
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Failed: couldn't find..." + toCheck1);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testProxyInterfaceImp() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx MessageEndpoint interface implemented";
        String toCheck2 = "LocalTx TSMessageListener interface implemented";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        Object errmsg = "";
        if (!b1) {
            errmsg = toCheck1;
        }
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b2) {
            if (!b1) {
                errmsg = (String)errmsg + "   AND  ";
            }
            errmsg = (String)errmsg + toCheck2;
        }
        if (!b1 || !b2) {
            throw new Exception("Failed: couldn't find..." + (String)errmsg);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testUniqueMessageEndpoint() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx Unique MessageEndpoint returned";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Failed: couldn't find..." + toCheck1);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testMessageEndpointFactoryForEquals() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx MessageEndpointFactory equals implemented correctly";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Failed: couldn't find..." + toCheck1);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testUniqueMessageEndpointFactory() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx MessageEndpointFactory is Unique";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Failed: couldn't find..." + toCheck1);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testEndpointActivationName() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Enterred testEndpointActivationName()");
        try {
            log = this.ds3.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "IBAnnotatedResourceAdapterImpl.endpointActivation() getActivationName() returned nonNull name";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            TestUtil.logTrace((String)str);
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Failed: couldn't find..." + toCheck1);
        }
        TestUtil.logMsg((String)"getActivationName() called correctly");
    }

    public void testGetEndpoinClass() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Enterred testGetEndpoinClass()");
        try {
            log = this.ds3.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "IBAnnotatedResourceAdapterImpl.endpointActivation() getEndpointClass() returned: com.sun.ts.tests.connector.mdb.JCAMessageBean";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            TestUtil.logTrace((String)str);
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Failed: couldn't find..." + toCheck1);
        }
        TestUtil.logMsg((String)"getEndpointClass() called correctly");
    }

    public void testMessageDeliveryTransacted() throws Exception {
        String str;
        int i;
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx MDB2 Transacted Message To MDB";
        String toCheck2 = "LocalTxMessageXAResource1.end";
        String toCheck3 = "LocalTx MDB2 delivery is transacted";
        TestUtil.logTrace((String)log.toString());
        Object errmsg = "";
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            errmsg = (String)errmsg + toCheck1;
        }
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b2) {
            errmsg = (String)errmsg + "   AND   " + toCheck2;
        }
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck3)) continue;
            b3 = true;
        }
        if (!b3) {
            errmsg = (String)errmsg + "   AND   " + toCheck3;
        }
        if (!(b1 && b2 && b3)) {
            throw new Exception("Failed: couldn't find..." + (String)errmsg);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testMessageDeliveryNonTransacted() throws Exception {
        String str;
        int i;
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx Non Transacted Message To MDB1";
        String toCheck2 = "LocalTxMessageXAResource.start";
        String toCheck3 = "LocalTx MDB1 delivery is not transacted";
        TestUtil.logTrace((String)log.toString());
        for (int i2 = 0; i2 < log.size(); ++i2) {
            String str2 = (String)log.elementAt(i2);
            if (!str2.equals(toCheck1)) continue;
            b1 = true;
        }
        Object errmsg = "";
        if (!b1) {
            errmsg = (String)errmsg + toCheck1;
        }
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (str.equals(toCheck2)) {
                b2 = false;
                break;
            }
            b2 = true;
        }
        if (!b2) {
            errmsg = (String)errmsg + "   AND   " + toCheck2;
        }
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (!str.equals(toCheck3)) continue;
            b3 = true;
        }
        if (!b3) {
            errmsg = (String)errmsg + "   AND   " + toCheck3;
        }
        if (!(b1 && b2 && b3)) {
            throw new Exception("Failed: couldn't find..." + (String)errmsg);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testMessageDeliveryTransactedUsingXid() throws Exception {
        String str;
        int i;
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTx MDB2 Transacted Message1";
        String toCheck2 = "LocalTxMessageXAResource2.start";
        String toCheck3 = "LocalTxMessageListener committed Xid";
        TestUtil.logTrace((String)log.toString());
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (str.startsWith(toCheck2)) {
                b2 = false;
                break;
            }
            b2 = true;
        }
        for (i = 0; i < log.size(); ++i) {
            str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck3)) continue;
            b3 = true;
        }
        if (!(b1 && b2 && b3)) {
            Object errStr = null;
            if (!b1) {
                errStr = toCheck1;
            }
            if (!b2) {
                errStr = (String)errStr + "   AND  " + toCheck2;
            }
            if (!b3) {
                errStr = (String)errStr + "   AND  " + toCheck3;
            }
            throw new Exception("Failed: couldn't find..." + (String)errStr);
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testActivationSpeccalledOnce() throws Exception {
        StringWriter sw;
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "LocalTxActivationSpec setResourceAdapter 1";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("LocalTxActivationSpec.setResourceAdapter not called .");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Exception dropping table.");
    }

    public void testEJBExceptionNotSupported() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "EJBException thrown by NotSupported";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("EJBException not thrown by Not Supported MDB.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            StringWriter sw = new StringWriter();
            sqle.printStackTrace(new PrintWriter(sw));
            String exceptionAsString = sw.toString();
            TestUtil.logMsg((String)("Exception caught on creating connection:" + exceptionAsString));
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Exception dropping table.");
    }

    public void testEJBExceptionRequired() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "EJBException thrown by Required";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("EJBException not thrown by Required MDB.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Exception dropping table.");
    }

    public void testAppExceptionNotSupported() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "AppException thrown by NotSupported";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("AppException not thrown by NotSupported MDB.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Exception dropping table.");
    }

    public void testAppExceptionRequired() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "AppException thrown by Required";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("AppException not thrown by Required MDB.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new Exception(sqle.getMessage(), sqle);
        }
        TestUtil.logMsg((String)"Exception dropping table.");
    }

    public void testSICMsgPrincipal() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"connecting to the connector server and the internal log...");
        try {
            TestUtil.logMsg((String)"Got RA log.");
            this.ds1.setLogFlag(true);
            this.con = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "mdb executed with proper SIC principal";
        String toCheck2 = "mdb not executed with proper SIC principal";
        TestUtil.logTrace((String)("search string 1 = " + toCheck1));
        TestUtil.logTrace((String)("search string 2 = " + toCheck2));
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || b2) {
            throw new Exception("Setting SIC on msg into MDB did not set principal correctly.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testIBAnnoMsgTransactedUsingXid() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds3.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "IBAnnotatedResourceAdapterImpl Required transaction";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Inbound Annotation Transaction failure.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testActivationSpecImplRAA() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds3.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "IBAnnoActivationSpecChild.setResourceAdatper called";
        String toCheck2 = "IBAnnoActivationSpecChild.getResourceAdapter() not null.";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new Exception("Inbound Annotation Transaction failure.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testIBAnnoASConfigProp() throws Exception {
        Vector log = null;
        boolean b1 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds3.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "IBAnnoActivationSpecChild.propName = IBAnnoConfigPropVal";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new Exception("Inbound Annotation ConfigProperty inheritance failure.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testContextSetupCompleted() throws Exception {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        TestUtil.logMsg((String)"Performing callback verification...");
        try {
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got State LOG!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new Exception(sqle.getMessage(), sqle);
        }
        String toCheck1 = "Context setup completed";
        String toCheck2 = "WorkListenerImpl.workAccepted for:notifications test";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!(b1 & b2)) {
            throw new Exception("failure - workmanager didn't call WorkContextLifecycleListener.contextSetupCompleted() correctly.");
        }
        TestUtil.logMsg((String)"workmanager called contextSetupCompleted() properly");
    }

    public void cleanup() throws Exception {
        try {
            TestUtil.logTrace((String)"Inside cleanup");
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }
}

