/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.CompositeQuestion;
import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Properties2;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class PropertiesQuestion
extends CompositeQuestion {
    private HashMap presentationKeys;
    private HashMap constraints;
    protected Properties value;
    private Properties defaultValue;
    private HashMap keyGroups;

    protected PropertiesQuestion(Interview interview, String tag) {
        super(interview, tag);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected PropertiesQuestion(Interview interview, String tag, Properties props) {
        super(interview, tag);
        this.setProperties(props);
        this.setDefaultValue(this.value);
    }

    protected PropertiesQuestion(Interview interview, String tag, String[] keys) {
        super(interview, tag);
        String blank = "";
        this.setKeys(keys, true);
        this.setDefaultValue(this.value);
    }

    protected void setProperties(Properties props) {
        this.value = (Properties)props.clone();
    }

    protected void setKeys(String[] keys, boolean localize) {
        this.value = new Properties();
        String blank = "";
        for (int i = 0; i < keys.length; ++i) {
            this.value.put(keys[i], blank);
        }
        ResourceBundle b = this.interview.getResourceBundle();
        if (!localize || b == null) {
            this.presentationKeys = null;
        } else {
            this.presentationKeys = new HashMap();
            for (int i = 0; i < keys.length; ++i) {
                String c = keys[i];
                String rn = this.tag + "." + c;
                try {
                    this.presentationKeys.put(keys[i], c == null ? null : b.getString(rn));
                    continue;
                }
                catch (MissingResourceException e) {
                    System.err.println("WARNING: missing resource " + rn);
                    this.presentationKeys.put(keys[i], c);
                }
            }
        }
    }

    public Enumeration getKeys() {
        if (this.value != null) {
            return this.value.keys();
        }
        return null;
    }

    public Properties getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Properties props) {
        this.defaultValue = props;
    }

    public Properties getValue() {
        if (this.value == null) {
            return null;
        }
        return (Properties)this.value.clone();
    }

    public Properties getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        StringBuffer result = new StringBuffer();
        if (this.value != null) {
            String sep = System.getProperty("line.separator");
            Enumeration<?> names = this.value.propertyNames();
            ArrayList<?> list = Collections.list(names);
            Collections.sort(list);
            for (Object o : list) {
                String key = (String)o;
                result.append(key);
                result.append("=");
                result.append(this.value.getProperty(key));
                result.append(sep);
            }
        }
        return result.toString();
    }

    @Override
    public void setValue(String newValue) {
        if (this.value == null || this.value.size() == 0) {
            return;
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.setValue(PropertiesQuestion.load(newValue));
    }

    @Override
    public void setValue(String key, String v) throws Interview.Fault {
        if (key == null || v == null) {
            throw new NullPointerException();
        }
        String check = this.value.getProperty(key);
        if (check == null) {
            throw new Interview.Fault(Interview.i18n, "props.badSubval");
        }
        this.value.put(key, v);
        this.interview.updatePath(this);
        this.interview.setEdited(true);
    }

    @Override
    public boolean isValueValid() {
        String[][] badVals = this.getInvalidKeys();
        return badVals == null;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void load(Map data) {
        Object o = data.get(this.tag);
        if (o != null && o instanceof String) {
            this.setValue(PropertiesQuestion.load((String)o));
        }
    }

    protected static Properties load(String s) {
        Properties2 p2 = new Properties2();
        try {
            p2.load(new StringReader(s));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Properties p = new Properties();
        Enumeration e = p2.propertyNames();
        while (e.hasMoreElements()) {
            Object next = e.nextElement();
            p.put((String)next, p2.get(next));
        }
        return p;
    }

    @Override
    protected void save(Map data) {
        if (this.value == null) {
            return;
        }
        Properties2 p2 = new Properties2();
        p2.load(this.value);
        StringWriter sw = new StringWriter();
        p2.save(sw, null);
        data.put(this.tag, sw.toString());
    }

    public boolean isReadOnlyValue(String key) {
        ValueConstraints c = this.getConstraints(key);
        return c != null && c.isReadOnly();
    }

    public boolean isEntryVisible(String key) {
        ValueConstraints c = this.getConstraints(key);
        return c == null || c.isVisible();
    }

    public String[][] getInvalidKeys() {
        Enumeration<?> names = this.value.propertyNames();
        ArrayList<String> badKeys = new ArrayList<String>();
        ArrayList<String> reasons = new ArrayList<String>();
        while (names.hasMoreElements()) {
            String reason;
            String curr = (String)names.nextElement();
            ValueConstraints rules = this.getConstraints(curr);
            if (rules == null || (reason = rules.isValid(this.value.getProperty(curr))) == null) continue;
            badKeys.add(curr);
            reasons.add(reason);
        }
        if (badKeys.size() > 0) {
            String[][] ret = new String[badKeys.size()][2];
            for (int i = 0; i < badKeys.size(); ++i) {
                ret[i][0] = (String)badKeys.get(i);
                ret[i][1] = (String)reasons.get(i);
            }
            return ret;
        }
        return null;
    }

    public final String isValueValid(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key parameter null!");
        }
        String[][] badVals = this.getInvalidKeys();
        if (badVals == null) {
            return null;
        }
        for (int i = 0; i < badVals.length; ++i) {
            if (!badVals[i][0].equals(key)) continue;
            return badVals[i][1];
        }
        return null;
    }

    public void setValue(Properties props) {
        this.value = props == null ? null : (Properties)props.clone();
        this.interview.updatePath(this);
        this.interview.setEdited(true);
    }

    public void updateProperties(String[][] props) {
        if (props == null || props.length == 0) {
            throw new IllegalArgumentException("Argument is null or zero length.");
        }
        for (int i = 0; i < props.length; ++i) {
            this.updateProperty(props[i][0], props[i][1]);
        }
    }

    public void updateProperty(String key, String val) {
        Object old;
        if (!this.value.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist");
        }
        String strVal = val;
        ValueConstraints rule = this.getConstraints(key);
        if (rule instanceof FloatConstraints) {
            try {
                float propertyValue = Float.parseFloat(strVal);
                float res = ((FloatConstraints)rule).getResolution();
                if (!Float.isNaN(res)) {
                    float k = propertyValue * (res = (float)Math.round(1.0f / res));
                    if ((double)Math.abs(k - (float)((int)k)) >= 0.5) {
                        k += 1.0f;
                    }
                    strVal = Float.toString((float)((int)k) / res);
                }
            }
            catch (NumberFormatException propertyValue) {
                // empty catch block
            }
        }
        if (!(old = this.value.setProperty(key, strVal)).equals(val)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void createGroup(String name) {
        Object o;
        if (this.keyGroups == null) {
            this.keyGroups = new HashMap();
        }
        if ((o = this.keyGroups.get(name)) != null) {
            throw new IllegalStateException("Group " + name + " already exists.");
        }
        ArrayList al = new ArrayList();
        this.keyGroups.put(name, al);
    }

    public void setGroup(String group, String key) {
        if (this.value == null) {
            throw new IllegalStateException("Question has no values, cannot group non-existant key");
        }
        if (!this.value.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist");
        }
        if (this.keyGroups == null) {
            throw new IllegalArgumentException("No such group: " + group);
        }
        ArrayList l = (ArrayList)this.keyGroups.get(group);
        if (l == null) {
            throw new IllegalArgumentException("No such group: " + group);
        }
        for (ArrayList al : this.keyGroups.values()) {
            for (int i = 0; i < al.size(); ++i) {
                if (!al.get(i).equals(key)) continue;
                al.remove(i);
            }
        }
        for (int i = 0; i < l.size(); ++i) {
            if (!l.get(i).equals(key)) continue;
            return;
        }
        l.add(key);
    }

    public void setGroup(String group, String[] keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            this.setGroup(group, keys[i]);
        }
    }

    public String[] getGroups() {
        if (this.keyGroups == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        Set keys = this.keyGroups.keySet();
        if (keys != null) {
            for (Object key : keys) {
                ArrayList al = (ArrayList)this.keyGroups.get(key);
                if (al == null || al.size() == 0) continue;
                result.add(key);
            }
        }
        if (result.size() == 0) {
            return null;
        }
        String[] ret = new String[result.size()];
        ret = result.toArray(ret);
        return ret;
    }

    public String[][] getGroup(String group) {
        if (this.value == null || this.value.size() == 0) {
            return null;
        }
        if (group == null) {
            return this.getUngrouped();
        }
        ArrayList al = (ArrayList)this.keyGroups.get(group);
        if (al == null || al.size() == 0) {
            return null;
        }
        Iterator it = al.iterator();
        String[][] data = new String[al.size()][2];
        int i = 0;
        while (it.hasNext()) {
            data[i][0] = (String)it.next();
            data[i][1] = (String)this.value.get(data[i][0]);
            ++i;
        }
        return data;
    }

    public String[][] getUngrouped() {
        Set keys;
        if (this.value == null || this.value.size() == 0) {
            return null;
        }
        if (this.keyGroups != null && (keys = this.keyGroups.keySet()) != null) {
            String[] gps = this.getGroups();
            Properties copy = (Properties)this.value.clone();
            for (int i = 0; i < gps.length; ++i) {
                String[][] vals = this.getGroup(gps[i]);
                for (int j = 0; j < vals.length; ++j) {
                    copy.remove(vals[j][0]);
                }
            }
            if (copy.size() > 0) {
                Enumeration<?> en = copy.propertyNames();
                String[][] ret = new String[copy.size()][2];
                int i = 0;
                while (en.hasMoreElements()) {
                    String key;
                    ret[i][0] = key = (String)en.nextElement();
                    ret[i][1] = copy.getProperty(key);
                    ++i;
                }
                return ret;
            }
            return null;
        }
        String[][] ret = new String[this.value.size()][2];
        Enumeration<?> en = this.value.propertyNames();
        int i = 0;
        while (en.hasMoreElements()) {
            String key;
            ret[i][0] = key = (String)en.nextElement();
            ret[i][1] = this.value.getProperty(key);
            ++i;
        }
        return ret;
    }

    public String getGroupDisplayName(String group) {
        ResourceBundle b = this.interview.getResourceBundle();
        String rn = this.tag + "." + group + ".group";
        try {
            return b.getString(rn);
        }
        catch (MissingResourceException e) {
            System.err.println("WARNING: missing resource " + rn);
            return rn;
        }
    }

    public String getKeyHeaderName() {
        return Interview.i18n.getString("props.key.name");
    }

    public String getValueHeaderName() {
        return Interview.i18n.getString("props.value.name");
    }

    public void setConstraints(String key, ValueConstraints c) {
        if (this.constraints == null) {
            this.constraints = new HashMap();
        }
        if (this.value == null || this.value.getProperty(key) == null) {
            throw new IllegalArgumentException("No such key: " + key);
        }
        if (c instanceof BooleanConstraints && (this.value.getProperty(key) == null || this.value.getProperty(key).isEmpty())) {
            if (this.defaultValue.getProperty(key) != null && !this.defaultValue.getProperty(key).isEmpty()) {
                this.value.put(key, this.defaultValue.getProperty(key));
            } else if (((BooleanConstraints)c).isYesNo()) {
                this.value.put(key, "No");
            } else {
                this.value.put(key, "False");
            }
        }
        this.constraints.put(key, c);
    }

    public String getConstraintKeyFromRow(Object[] values) {
        if (values != null && values.length > 0) {
            return this.getKeyPropertyName(values[0].toString());
        }
        return "";
    }

    public String getKeyPropertyName(String key) {
        if (this.presentationKeys != null) {
            for (Object keyProperty : this.presentationKeys.keySet()) {
                if (!key.equals(this.presentationKeys.get(keyProperty))) continue;
                return (String)keyProperty;
            }
        }
        return key;
    }

    public HashMap getPresentationKeys() {
        return this.presentationKeys;
    }

    public ValueConstraints getConstraints(String key) {
        if (this.constraints == null) {
            return null;
        }
        return (ValueConstraints)this.constraints.get(key);
    }

    public static class FilenameConstraints
    extends ValueConstraints {
        private File baseDir;
        private boolean baseRelativeOnly;
        private FileFilter[] filters;
        protected File[] suggestions;

        public FilenameConstraints() {
        }

        @Override
        public String isValid(String v) {
            if (v == null || v.length() == 0) {
                return "Value is not set";
            }
            if (this.baseRelativeOnly && this.baseDir != null && !v.startsWith(this.baseDir.getPath())) {
                return "Path is not relative to " + this.baseDir.getPath();
            }
            if (this.filters != null) {
                File fl = new File(v);
                for (FileFilter f : this.filters) {
                    if (f.accept(fl)) continue;
                    return "File is not valid";
                }
            }
            return null;
        }

        public FilenameConstraints(File baseDir, boolean relativeOnly) {
            this();
            this.baseDir = baseDir;
            this.baseRelativeOnly = relativeOnly;
        }

        public FileFilter[] getFilters() {
            return this.filters;
        }

        public void setFilter(FileFilter filter) {
            this.filters = new FileFilter[]{filter};
        }

        public void setFilters(FileFilter[] filters) {
            this.filters = filters;
        }

        public File getBaseDirectory() {
            return this.baseDir;
        }

        public void setBaseDirectory(File dir) {
            this.baseDir = dir;
        }

        public boolean isBaseRelativeOnly() {
            return this.baseRelativeOnly;
        }

        public void setBaseRelativeOnly(boolean b) {
            this.baseRelativeOnly = b;
        }

        public void setSuggestions(File[] sugs) {
            this.suggestions = new File[sugs.length];
            System.arraycopy(sugs, 0, this.suggestions, 0, sugs.length);
        }

        public File[] getSuggestions() {
            return this.suggestions;
        }
    }

    public static class BooleanConstraints
    extends ValueConstraints {
        public static final String YES = "Yes";
        public static final String NO = "No";
        public static final String TRUE = "True";
        public static final String FALSE = "False";
        private boolean yesno = false;

        public BooleanConstraints() {
        }

        public BooleanConstraints(boolean isYesNo) {
            this();
            this.setUseYesNo(isYesNo);
        }

        public BooleanConstraints(boolean isYesNo, boolean unsetAllowed) {
            this();
            this.setUseYesNo(isYesNo);
            this.setUnsetAllowed(unsetAllowed);
        }

        public void setUseYesNo(boolean state) {
            this.yesno = state;
        }

        public boolean isYesNo() {
            return this.yesno;
        }
    }

    public static class StringConstraints
    extends ValueConstraints {
        protected String[] suggestions;
        protected boolean custom = true;
        protected int nominalMaxLength;

        public StringConstraints() {
        }

        public StringConstraints(String[] suggestions) {
            this();
            this.setSuggestions(suggestions);
        }

        public StringConstraints(int maxLen) {
            this();
            this.setNominalMaxLength(maxLen);
        }

        public StringConstraints(String[] suggestions, int maxLen) {
            this();
            this.setSuggestions(suggestions);
            this.setNominalMaxLength(maxLen);
        }

        public void setSuggestions(String[] sugs) {
            this.suggestions = new String[sugs.length];
            System.arraycopy(sugs, 0, this.suggestions, 0, sugs.length);
        }

        public String[] getSuggestions() {
            return this.suggestions;
        }

        public void setCustomValuesAllowed(boolean state) {
            this.custom = state;
        }

        public boolean isCustomValuesAllowed() {
            return this.custom;
        }

        public int getNominalMaxLength() {
            return this.nominalMaxLength;
        }

        public void setNominalMaxLength(int nominalMaxLength) {
            this.nominalMaxLength = nominalMaxLength;
        }
    }

    public static class FloatConstraints
    extends ValueConstraints {
        protected float[] suggestions;
        protected boolean custom = true;
        private float min = Float.MIN_VALUE;
        private float max = Float.MAX_VALUE;
        private float resolution = Float.NaN;

        public FloatConstraints() {
        }

        public FloatConstraints(float min, float max) {
            this();
            this.setBounds(min, max);
        }

        public FloatConstraints(float[] suggestions) {
            this();
            this.setSuggestions(suggestions);
        }

        public FloatConstraints(float min, float max, float[] suggestions) {
            this();
            this.setBounds(min, max);
            this.setSuggestions(suggestions);
        }

        public void setBounds(float min, float max) {
            this.max = max;
            this.min = min;
        }

        public float getLowerBound() {
            return this.min;
        }

        public float getUpperBound() {
            return this.max;
        }

        public float[] getSuggestions() {
            return this.suggestions;
        }

        public void setCustomValuesAllowed(boolean state) {
            this.custom = state;
        }

        public boolean isCustomValuesAllowed() {
            return this.custom;
        }

        public void setSuggestions(float[] sugs) {
            this.suggestions = new float[sugs.length];
            System.arraycopy(sugs, 0, this.suggestions, 0, sugs.length);
        }

        public void setResolution(float resolution) {
            this.resolution = resolution;
        }

        public float getResolution() {
            return this.resolution;
        }

        @Override
        public String isValid(String v) {
            try {
                float number = Float.parseFloat(v);
                return this.isValid(number);
            }
            catch (NumberFormatException e) {
                return "Not an floating point number.";
            }
        }

        public String isValid(float v) {
            if (v < this.min || v > this.max) {
                return "Value out of range ( " + v + "), must be between " + this.min + " and " + this.max;
            }
            return null;
        }
    }

    public static class IntConstraints
    extends ValueConstraints {
        protected int[] suggestions;
        protected boolean custom = true;
        private int min = -2147483647;
        private int max = Integer.MAX_VALUE;

        public IntConstraints() {
        }

        public IntConstraints(int min, int max) {
            this();
            this.setBounds(min, max);
        }

        public IntConstraints(int[] suggestions) {
            this();
            this.setSuggestions(suggestions);
        }

        public IntConstraints(int min, int max, int[] suggestions) {
            this();
            this.setBounds(min, max);
            this.setSuggestions(suggestions);
        }

        public void setBounds(int min, int max) {
            this.max = max;
            this.min = min;
        }

        public int getLowerBound() {
            return this.min;
        }

        public int getUpperBound() {
            return this.max;
        }

        public int[] getSuggestions() {
            return this.suggestions;
        }

        public void setCustomValuesAllowed(boolean state) {
            this.custom = state;
        }

        public boolean isCustomValuesAllowed() {
            return this.custom;
        }

        public void setSuggestions(int[] sugs) {
            this.suggestions = new int[sugs.length];
            System.arraycopy(sugs, 0, this.suggestions, 0, sugs.length);
        }

        @Override
        public String isValid(String v) {
            try {
                int number = Integer.parseInt(v);
                return this.isValid(number);
            }
            catch (NumberFormatException e) {
                return "Not an integer.";
            }
        }

        public String isValid(int v) {
            if (v < this.min || v > this.max) {
                return "Value out of range (" + v + "), must be between " + this.min + " and " + this.max;
            }
            return null;
        }
    }

    public static class ValueConstraints {
        private boolean visible = true;
        private boolean readonly = false;
        private boolean allowUnset = true;

        public ValueConstraints() {
            this(false, true);
        }

        public ValueConstraints(boolean readonly, boolean visible) {
            this.readonly = readonly;
            this.visible = visible;
        }

        public void setReadOnly(boolean state) {
            this.readonly = state;
        }

        public void setVisible(boolean state) {
            this.visible = state;
        }

        public boolean isReadOnly() {
            return this.readonly;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setUnsetAllowed(boolean state) {
            this.allowUnset = state;
        }

        public boolean isUnsetAllowed() {
            return this.allowUnset;
        }

        public String isValid(String v) {
            if (v == null || v.length() == 0) {
                return "Value is not set";
            }
            return null;
        }
    }
}

