/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonreadertests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonreadertests.Reader;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import ee.jakarta.tck.jsonp.common.MyBufferedInputStream;
import ee.jakarta.tck.jsonp.common.MyBufferedReader;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonConfig;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    private boolean compareJsonObjectForUTFEncodedTests(JsonObject jsonObject) {
        JsonArray actArray;
        JsonObject actObject;
        boolean pass = true;
        LOGGER.info("Comparing JsonObject values to expected results.");
        String expString = "stringValue";
        String actString = jsonObject.getJsonString("stringName").getString();
        if (!JSONP_Util.assertEquals((String)expString, (String)actString)) {
            pass = false;
        }
        if (!JSONP_Util.assertEquals((String)(expString = "bar"), (String)(actString = (actObject = jsonObject.getJsonObject("objectName")).getJsonString("foo").getString()))) {
            pass = false;
        }
        if (!(JSONP_Util.assertEquals((int)1, (int)(actArray = jsonObject.getJsonArray("arrayName")).getJsonNumber(0).intValue()) && JSONP_Util.assertEquals((int)2, (int)actArray.getJsonNumber(1).intValue()) && JSONP_Util.assertEquals((int)3, (int)actArray.getJsonNumber(2).intValue()))) {
            pass = false;
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEmptyArrayTest() {
        try (JsonReader reader = null;){
            String expJsonText = "[]";
            LOGGER.info("Testing read of " + expJsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(expJsonText));
            JsonArray array = reader.readArray();
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsEmptyArrayList((List)array), (String)"readEmptyArrayTest Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEscapeCharsInArrayTest() {
        boolean pass = true;
        JsonReader reader = null;
        String resourceFile = "jsonArrayWithEscapeCharsData.json";
        String expString = "popeye\"\\/\b\f\n\r\tolive";
        try {
            LOGGER.info("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString((String)resourceFile);
            LOGGER.info("readerContents=" + readerContents);
            LOGGER.info("Testing read of resource contents: " + readerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(readerContents));
            JsonArray expJsonArray = reader.readArray();
            LOGGER.info("Dump of expJsonArray");
            JSONP_Util.dumpJsonArray((JsonArray)expJsonArray);
            LOGGER.info("Comparing JsonArray values with expected results.");
            String actString = expJsonArray.getJsonString(0).getString();
            if (!JSONP_Util.assertEquals((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Write the JsonArray 'expJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(expJsonArray);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("Create actJsonArray from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonArray actJsonArray = reader.readArray();
            LOGGER.info("Dump of actJsonArray");
            JSONP_Util.dumpJsonArray((JsonArray)actJsonArray);
            LOGGER.info("Compare expJsonArray and actJsonArray for equality");
            if (!JSONP_Util.assertEqualsJsonArrays((JsonArray)expJsonArray, (JsonArray)actJsonArray)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"readEscapeCharsInArrayTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"readEscapeCharsInArrayTest Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEscapeUnicodeCharsInArrayTest() {
        JsonReader reader = null;
        String unicodeTextString = "[\"\\u0000\u00ff\\uff00\uffff\"]";
        String expResult = "\u0000\u00ff\uff00\uffff";
        try {
            LOGGER.info("Reading array of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonArray array = reader.readArray();
            String actResult = array.getJsonString(0).getString();
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expResult, (String)actResult), (String)"readEscapeUnicodeCharsInArrayTest Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"readEscapeUnicodeCharsInArrayTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEscapeUnicodeControlCharsInArrayTest() {
        JsonReader reader = null;
        String unicodeTextString = "[\"\\u0000\\u0001\\u0002\\u0003\\u0004\\u0005\\u0006\\u0007\\u0008\\u0009\\u000a\\u000b\\u000c\\u000d\\u000e\\u000f\\u000A\\u000B\\u000C\\u000D\\u000E\\u000F\\u0010\\u0011\\u0012\\u0013\\u0014\\u0015\\u0016\\u0017\\u0018\\u0019\\u001a\\u001b\\u001c\\u001d\\u001e\\u001f\\u007f\\u001A\\u001B\\u001C\\u001D\\u001E\\u001F\\u007F\\u0080\\u0081\\u0082\\u0083\\u0084\\u0085\\u0086\\u0087\\u0088\\u0089\\u008a\\u008b\\u008c\\u008d\\u008e\\u008f\\u008A\\u008B\\u008C\\u008D\\u008E\\u008F\\u0090\\u0091\\u0092\\u0093\\u0094\\u0095\\u0096\\u0097\\u0098\\u0099\\u009a\\u009b\\u009c\\u009d\\u009e\\u009f\\u009A\\u009B\\u009C\\u009D\\u009E\\u009F\"]";
        String expResult = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u009a\u009b\u009c\u009d\u009e\u009f";
        try {
            LOGGER.info("Reading array of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonArray array = reader.readArray();
            String actResult = array.getJsonString(0).getString();
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expResult, (String)actResult), (String)"readEscapeUnicodeControlCharsInArrayTest Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"readEscapeUnicodeControlCharsInArrayTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEmptyObjectTest() {
        try (JsonReader reader = null;){
            String expJsonText = "{}";
            LOGGER.info("Testing read of " + expJsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(expJsonText));
            JsonObject object = reader.readObject();
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsEmptyObjectMap((Map)object), (String)"readEmptyObjectTest Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEscapeCharsInObjectTest() {
        boolean pass = true;
        JsonReader reader = null;
        String resourceFile = "jsonObjectWithEscapeCharsData.json";
        String expString = "popeye\"\\/\b\f\n\r\tolive";
        try {
            LOGGER.info("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString((String)resourceFile);
            LOGGER.info("readerContents=" + readerContents);
            LOGGER.info("Testing read of resource contents: " + readerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(readerContents));
            JsonObject expJsonObject = reader.readObject();
            LOGGER.info("Dump of expJsonObject");
            JSONP_Util.dumpJsonObject((JsonObject)expJsonObject);
            LOGGER.info("Comparing JsonArray values with expected results.");
            String actString = expJsonObject.getJsonString("escapeChars").getString();
            if (!JSONP_Util.assertEquals((String)expString, (String)actString)) {
                pass = false;
            }
            LOGGER.info("Write the JsonObject 'expJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(expJsonObject);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("Create actJsonObject from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonObject actJsonObject = reader.readObject();
            LOGGER.info("Dump of actJsonObject");
            JSONP_Util.dumpJsonObject((JsonObject)actJsonObject);
            LOGGER.info("Compare expJsonObject and actJsonObject for equality");
            if (!JSONP_Util.assertEqualsJsonObjects((JsonObject)expJsonObject, (JsonObject)actJsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"readEscapeCharsInObjectTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"readEscapeCharsInObjectTest Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEscapeUnicodeCharsInObjectTest() {
        JsonReader reader = null;
        String unicodeTextString = "{\"unicodechars\":\"\\u0000\u00ff\\uff00\uffff\"}";
        String expResult = "\u0000\u00ff\uff00\uffff";
        try {
            LOGGER.info("Reading object of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonObject object = reader.readObject();
            String actResult = object.getJsonString("unicodechars").getString();
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expResult, (String)actResult), (String)"readEscapeUnicodeCharsInObjectTest Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"readEscapeUnicodeCharsInObjectTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readEscapeUnicodeControlCharsInObjectTest() {
        JsonReader reader = null;
        String unicodeTextString = "{\"unicodechars\":\"\\u0000\\u0001\\u0002\\u0003\\u0004\\u0005\\u0006\\u0007\\u0008\\u0009\\u000a\\u000b\\u000c\\u000d\\u000e\\u000f\\u000A\\u000B\\u000C\\u000D\\u000E\\u000F\\u0010\\u0011\\u0012\\u0013\\u0014\\u0015\\u0016\\u0017\\u0018\\u0019\\u001a\\u001b\\u001c\\u001d\\u001e\\u001f\\u007f\\u001A\\u001B\\u001C\\u001D\\u001E\\u001F\\u007F\\u0080\\u0081\\u0082\\u0083\\u0084\\u0085\\u0086\\u0087\\u0088\\u0089\\u008a\\u008b\\u008c\\u008d\\u008e\\u008f\\u008A\\u008B\\u008C\\u008D\\u008E\\u008F\\u0090\\u0091\\u0092\\u0093\\u0094\\u0095\\u0096\\u0097\\u0098\\u0099\\u009a\\u009b\\u009c\\u009d\\u009e\\u009f\\u009A\\u009B\\u009C\\u009D\\u009E\\u009F\"}";
        String expResult = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u009a\u009b\u009c\u009d\u009e\u009f";
        try {
            LOGGER.info("Reading array of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonObject object = reader.readObject();
            String actResult = object.getJsonString("unicodechars").getString();
            Assertions.assertTrue((boolean)JSONP_Util.assertEquals((String)expResult, (String)actResult), (String)"readEscapeUnicodeControlCharsInObjectTest Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"readEscapeUnicodeControlCharsInObjectTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readArrayTest() {
        try (JsonReader reader = null;){
            JsonArray myJsonArray;
            String jsonText = "[true,false,null,\"booyah\",2147483647,9223372036854775807,1.7976931348623157E308,[true,false,null,\"bingo\",-2147483648,-9223372036854775808,4.9E-324],{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1,\"double\":10.4}]";
            LOGGER.info("Create the expected list of JsonArray values");
            ArrayList<Object> expList = new ArrayList<Object>();
            expList.add(JsonValue.TRUE);
            expList.add(JsonValue.FALSE);
            expList.add(JsonValue.NULL);
            expList.add(JSONP_Util.createJsonString((String)"booyah"));
            expList.add(JSONP_Util.createJsonNumber((int)Integer.MAX_VALUE));
            expList.add(JSONP_Util.createJsonNumber((long)Long.MAX_VALUE));
            expList.add(JSONP_Util.createJsonNumber((double)Double.MAX_VALUE));
            JsonArray array = Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE).build();
            JsonObject object = Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4).build();
            expList.add(array);
            expList.add(object);
            LOGGER.info("Testing read of " + jsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(jsonText));
            JsonArray actList = myJsonArray = reader.readArray();
            LOGGER.info("Compare actual list of JsonArray values with expected list of JsonArray values");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsList(expList, (List)actList), (String)"readArrayTest Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readArrayTest2() {
        try (JsonReader reader = null;){
            LOGGER.info("Create the expected list of JsonArray values");
            JsonArray expJsonArray = Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("booyah").add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add(Double.MAX_VALUE).add(Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE)).add(Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4)).build();
            LOGGER.info("Write the JsonArray 'expJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(expJsonArray);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String jsonText = sWriter.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + jsonText);
            LOGGER.info("Testing read of " + jsonText);
            reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString((String)jsonText));
            JsonArray actJsonArray = reader.readArray();
            LOGGER.info("Compare expJsonArray and actJsonArray for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonArrays((JsonArray)expJsonArray, (JsonArray)actJsonArray), (String)"readArrayTest2 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readArrayTest3() {
        try (JsonReader reader = null;){
            String expJsonText = "[true,false,null,\"booyah\",2147483647,9223372036854775807,[true,false,null,\"bingo\",-2147483648,-9223372036854775808],{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1}]";
            LOGGER.info("Testing read of " + expJsonText);
            reader = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig()).createReader((java.io.Reader)new StringReader(expJsonText));
            JsonArray myJsonArray = reader.readArray();
            LOGGER.info("Write the JsonArray 'myJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(myJsonArray);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonText = sWriter.toString();
            LOGGER.info("Compare actual JSON text with expected JSON text");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJsonText, (String)actJsonText), (String)"readArrayTest3 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readArrayTest4() {
        String resourceFile = "jsonArrayWithAllTypesOfData.json";
        try (JsonReader reader = null;){
            LOGGER.info("Read contents of InputStream from resource file: " + resourceFile);
            Map config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory((Map)config).createReader(JSONP_Util.getInputStreamFromResource((String)resourceFile), JSONP_Util.UTF_8);
            JsonArray expJsonArray = reader.readArray();
            LOGGER.info("Dump of expJsonArray");
            JSONP_Util.dumpJsonArray((JsonArray)expJsonArray);
            LOGGER.info("Write the JsonArray 'expJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(expJsonArray);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("Create actJsonArray from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonArray actJsonArray = reader.readArray();
            LOGGER.info("Dump of actJsonArray");
            JSONP_Util.dumpJsonArray((JsonArray)actJsonArray);
            LOGGER.info("Compare expJsonArray and actJsonArray for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonArrays((JsonArray)expJsonArray, (JsonArray)actJsonArray), (String)"readArrayTest4 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readArrayTest5() {
        String resourceFile = "jsonArrayWithLotsOfNestedObjectsData.json";
        try (JsonReader reader = null;){
            LOGGER.info("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString((String)resourceFile);
            LOGGER.info("readerContents=" + readerContents);
            LOGGER.info("Filter readerContents of whitespace for comparison");
            String expJsonText = JSONP_Util.removeWhitespace((String)readerContents);
            LOGGER.info("Read contents of InputStream from resource file: " + resourceFile);
            reader = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig()).createReader(JSONP_Util.getInputStreamFromResource((String)resourceFile), JSONP_Util.UTF_8);
            JsonArray myJsonArray = (JsonArray)reader.read();
            LOGGER.info("Write the JsonArray 'myJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(myJsonArray);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("Dump contents of the JsonWriter as a String");
            LOGGER.info("writerContents=" + writerContents);
            LOGGER.info("Filter writerContents of whitespace for comparison");
            String actJsonText = JSONP_Util.removeWhitespace((String)writerContents);
            LOGGER.info("Compare actual JSON text with expected JSON text");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJsonText, (String)actJsonText), (String)"readArrayTest5 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readArrayEncodingTest() {
        String actString;
        JsonArray jsonArray;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        String expString = "a\u65e8\u452c\u8b9e\u6589\u5c57\u5217z";
        String resourceFileUTF8 = "jsonArrayUTF8.json";
        String resourceFileUTF16BE = "jsonArrayUTF16BE.json";
        Map config = JSONP_Util.getEmptyConfig();
        try {
            LOGGER.info("Reading contents of resource file using UTF-8 encoding " + resourceFileUTF8);
            is = JSONP_Util.getInputStreamFromResource((String)resourceFileUTF8);
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_8);
            jsonArray = reader.readArray();
            LOGGER.info("Comparing JsonArray values with expected results.");
            actString = jsonArray.getJsonString(0).getString();
            if (!JSONP_Util.assertEquals((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"readArrayEncodingTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Reading contents of resource file using UTF-16BE encoding " + resourceFileUTF16BE);
            is = JSONP_Util.getInputStreamFromResource((String)resourceFileUTF16BE);
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_16BE);
            jsonArray = reader.readArray();
            LOGGER.info("Comparing JsonArray values with expected results.");
            actString = jsonArray.getJsonString(0).getString();
            if (!JSONP_Util.assertEquals((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"readArrayEncodingTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"readArrayEncodingTest Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readObjectTest() {
        try (JsonReader reader = null;){
            JsonObject myJsonObject;
            String expJsonText = "{\"true\":true,\"false\":false,\"null\":null,\"booyah\":\"booyah\",\"int\":2147483647,\"long\":9223372036854775807,\"double\":1.7976931348623157E308,\"array\":[true,false,null,\"bingo\",-2147483648,-9223372036854775808,4.9E-324],\"object\":{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1,\"double\":10.4}}";
            LOGGER.info("Create the expected map of JsonObject values");
            HashMap<String, Object> expMap = new HashMap<String, Object>();
            expMap.put("true", JsonValue.TRUE);
            expMap.put("false", JsonValue.FALSE);
            expMap.put("null", JsonValue.NULL);
            expMap.put("booyah", JSONP_Util.createJsonString((String)"booyah"));
            expMap.put("int", JSONP_Util.createJsonNumber((int)Integer.MAX_VALUE));
            expMap.put("long", JSONP_Util.createJsonNumber((long)Long.MAX_VALUE));
            expMap.put("double", JSONP_Util.createJsonNumber((double)Double.MAX_VALUE));
            JsonArray array = Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE).build();
            JsonObject object = Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4).build();
            expMap.put("array", array);
            expMap.put("object", object);
            LOGGER.info("Testing read of " + expJsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(expJsonText));
            JsonObject actMap = myJsonObject = reader.readObject();
            LOGGER.info("Compare actual map of JsonObject values with expected map of JsonObject values");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsMap(expMap, (Map)actMap), (String)"readObjectTest Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readObjectTest2() {
        try (JsonReader reader = null;){
            LOGGER.info("Create the expected list of JsonObject values");
            JsonObject expJsonObject = Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("booyah", "booyah").add("int", Integer.MAX_VALUE).add("long", Long.MAX_VALUE).add("double", Double.MAX_VALUE).add("array", Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE)).add("object", Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4)).build();
            LOGGER.info("Write the JsonObject 'expJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(expJsonObject);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String jsonText = sWriter.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + jsonText);
            LOGGER.info("Testing read of " + jsonText);
            reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString((String)jsonText));
            JsonObject actJsonObject = reader.readObject();
            LOGGER.info("Compare expJsonObject and actJsonObject for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonObjects((JsonObject)expJsonObject, (JsonObject)actJsonObject), (String)"readObjectTest2 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readObjectTest3() {
        try (JsonReader reader = null;){
            String expJsonText = "{\"true\":true,\"false\":false,\"null\":null,\"booyah\":\"booyah\",\"int\":2147483647,\"long\":9223372036854775807,\"array\":[true,false,null,\"bingo\",-2147483648,-9223372036854775808],\"object\":{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1}}";
            LOGGER.info("Testing read of " + expJsonText);
            reader = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig()).createReader((java.io.Reader)new StringReader(expJsonText));
            JsonObject myJsonObject = reader.readObject();
            LOGGER.info("Write the JsonObject 'myJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(myJsonObject);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonText = sWriter.toString();
            LOGGER.info("Compare actual JSON text with expected JSON text");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJsonText, (String)actJsonText), (String)"readObjectTest3 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readObjectTest4() {
        String resourceFile = "jsonObjectWithAllTypesOfData.json";
        try (JsonReader reader = null;){
            LOGGER.info("Read contents of InputStream from resource file: " + resourceFile);
            Map config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory((Map)config).createReader(JSONP_Util.getInputStreamFromResource((String)resourceFile), JSONP_Util.UTF_8);
            JsonObject expJsonObject = reader.readObject();
            LOGGER.info("Dump of expJsonObject");
            JSONP_Util.dumpJsonObject((JsonObject)expJsonObject);
            LOGGER.info("Write the JsonObject 'expJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(expJsonObject);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("Create actJsonObject from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonObject actJsonObject = reader.readObject();
            LOGGER.info("Dump of actJsonObject");
            JSONP_Util.dumpJsonObject((JsonObject)actJsonObject);
            LOGGER.info("Compare expJsonObject and actJsonObject for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonObjects((JsonObject)expJsonObject, (JsonObject)actJsonObject), (String)"readObjectTest4 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readObjectTest5() {
        String resourceFile = "jsonObjectWithLotsOfNestedObjectsData.json";
        try (JsonReader reader = null;){
            LOGGER.info("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString((String)resourceFile);
            LOGGER.info("readerContents=" + readerContents);
            LOGGER.info("Filter readerContents of whitespace for comparison");
            String expJsonText = JSONP_Util.removeWhitespace((String)readerContents);
            LOGGER.info("Read contents of InputStream from resource file: " + resourceFile);
            reader = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig()).createReader(JSONP_Util.getInputStreamFromResource((String)resourceFile), JSONP_Util.UTF_8);
            JsonObject myJsonObject = (JsonObject)reader.read();
            LOGGER.info("Write the JsonObject 'myJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(myJsonObject);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("Dump contents of the JsonWriter as a String");
            LOGGER.info("writerContents=" + writerContents);
            LOGGER.info("Filter writerContents of whitespace for comparison");
            String actJsonText = JSONP_Util.removeWhitespace((String)writerContents);
            LOGGER.info("Compare actual JSON text with expected JSON text");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJsonText, (String)actJsonText), (String)"readObjectTest5 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readObjectEncodingTest() {
        String actString;
        JsonObject jsonObject;
        Map config;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        String expString = "a\u65e8\u452c\u8b9e\u6589\u5c57\u5217z";
        String resourceFileUTF8 = "jsonObjectUTF8.json";
        String resourceFileUTF16LE = "jsonObjectUTF16LE.json";
        try {
            LOGGER.info("Reading contents of resource file using UTF-8 encoding " + resourceFileUTF8);
            is = JSONP_Util.getInputStreamFromResource((String)resourceFileUTF8);
            config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_8);
            jsonObject = reader.readObject();
            LOGGER.info("Comparing JsonObject values with expected results.");
            actString = jsonObject.getJsonString("unicodeChars").getString();
            if (!JSONP_Util.assertEquals((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"readObjectEncodingTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Reading contents of resource file using UTF-16LE encoding " + resourceFileUTF16LE);
            is = JSONP_Util.getInputStreamFromResource((String)resourceFileUTF16LE);
            config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_16LE);
            jsonObject = reader.readObject();
            LOGGER.info("Comparing JsonObject values with expected results.");
            actString = jsonObject.getJsonString("unicodeChars").getString();
            if (!JSONP_Util.assertEquals((String)expString, (String)actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"readObjectEncodingTest Failed: ", (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"readObjectEncodingTest Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readUTFEncodedTests() {
        JsonObject jsonObject;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        Map config = JSONP_Util.getEmptyConfig();
        try {
            LOGGER.info("-----------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-8]");
            LOGGER.info("-----------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF8.json");
            LOGGER.info("Create JsonReader from the InputStream with character encoding UTF-8");
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_8);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-8 encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-16]");
            LOGGER.info("------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16.json");
            LOGGER.info("Create JsonReader from the InputStream with character encoding UTF-16");
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_16);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-16 encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-16LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16LE.json");
            LOGGER.info("Create JsonReader from the InputStream with character encoding UTF-16LE");
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_16LE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-16BE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16BE.json");
            LOGGER.info("Create JsonReader from the InputStream with character encoding UTF-16BE");
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_16BE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-32LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32LE.json");
            LOGGER.info("Create JsonReader from the InputStream with character encoding UTF-32LE");
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_32LE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-32BE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32BE.json");
            LOGGER.info("Create JsonReader from the InputStream with character encoding UTF-32BE");
            reader = Json.createReaderFactory((Map)config).createReader(is, JSONP_Util.UTF_32BE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"readUTFEncodedTests Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readUTFEncodedTests2() {
        JsonObject jsonObject;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        try {
            LOGGER.info("---------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReader(InputStream) as UTF-8]");
            LOGGER.info("---------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF8.json");
            LOGGER.info("Create JsonReader from the InputStream and auto-detect character encoding UTF-8");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-8 encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReader(InputStream) as UTF-16LE]");
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16LE.json");
            LOGGER.info("Create JsonReader from the InputStream and auto-detect character encoding UTF-16LE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReader(InputStream) as UTF-16BE]");
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF16BE.json");
            LOGGER.info("Create JsonReader from the InputStream and auto-detect character encoding UTF-16BE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReader(InputStream) as UTF-32LE]");
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32LE.json");
            LOGGER.info("Create JsonReader from the InputStream and auto-detect character encoding UTF-32LE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createReader(InputStream) as UTF-32BE]");
            LOGGER.info("------------------------------------------------------");
            LOGGER.info("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            is = JSONP_Util.getInputStreamFromResource((String)"jsonObjectEncodingUTF32BE.json");
            LOGGER.info("Create JsonReader from the InputStream and auto-detect character encoding UTF-32BE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing reading of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        Assertions.assertTrue((boolean)pass, (String)"readUTFEncodedTests2 Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void negativeObjectTests() {
        JsonObject value;
        boolean pass = true;
        try (JsonReader reader = null;){
            LOGGER.info("Testing for not an object '[]'");
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonException");
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if incorrect representation for object.");
            LOGGER.info("Reading {\"name\":\"value\",1,2,3}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\":\"value\",1,2,3}"));
            JsonObject jsonObject = reader.readObject();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Testing for missing '['");
            reader = Json.createReader((java.io.Reader)new StringReader("{1,2]}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ']'");
            reader = Json.createReader((java.io.Reader)new StringReader("{[1,2}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing '{'");
            reader = Json.createReader((java.io.Reader)new StringReader("}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing '}'");
            reader = Json.createReader((java.io.Reader)new StringReader("{"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between array elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5\"foo\"]}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between array elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5{}]}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between object elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":\"bar\"5}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between object elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"one\":1[]}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing key name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{:\"bar\"}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing value name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Test for missing double quote on a name");
            reader = Json.createReader((java.io.Reader)new StringReader("{name\" : \"value\"}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Test for missing double quote on a value");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\" : value\"}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value -foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -foo}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value +foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +foo}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value -784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -784foo}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value +784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +784foo}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value 0.1E5E5");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.1E5E5}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value  0.F10");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.F10}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value string");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : string}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value hex numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0x137a}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value octal numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0137}"));
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"negativeObjectTests Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void negativeArrayTests() {
        JsonArray value;
        boolean pass = true;
        try (JsonReader reader = null;){
            LOGGER.info("Testing for not an array '{}'");
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonException");
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.readArray() if incorrect representation for array.");
            LOGGER.info("Reading [foo,10,\"name\":\"value\"]");
            reader = Json.createReader((java.io.Reader)new StringReader("[foo,10,\"name\":\"value\"]"));
            JsonArray jsonArray = reader.readArray();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Testing for missing '['");
            reader = Json.createReader((java.io.Reader)new StringReader("]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ']'");
            reader = Json.createReader((java.io.Reader)new StringReader("["));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing '{'");
            reader = Json.createReader((java.io.Reader)new StringReader("[1,\"name\":\"value\"}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing '}'");
            reader = Json.createReader((java.io.Reader)new StringReader("[1,{\"name\":\"value\"]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between array elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("[5\"foo\"]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between array elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("[5{}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between object elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"foo\":\"bar\"5}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between object elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"one\":1[]}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing key name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("[{:\"bar\"}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing value name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"foo\":}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Test for missing double quote on a name");
            reader = Json.createReader((java.io.Reader)new StringReader("[{name\" : \"value\"}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Test for missing double quote on a value");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"name\" : value\"}]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value -foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[-foo]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value +foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[+foo]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value -784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[-784foo]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value +784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[+784foo]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value 0.1E5E5");
            reader = Json.createReader((java.io.Reader)new StringReader("[0.1E5E5]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value  0.F10");
            reader = Json.createReader((java.io.Reader)new StringReader("[0.F10]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value string");
            reader = Json.createReader((java.io.Reader)new StringReader("[string]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value hex numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("[0x137a]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value octal numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("[0137]"));
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"negativeArrayTests Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void illegalStateExceptionTests() {
        JsonStructure value;
        boolean pass = true;
        JsonReader reader = null;
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            reader.close();
            LOGGER.info("Calling reader.read() after reader.close() is called is illegal.");
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            value = reader.readObject();
            LOGGER.info("Calling reader.readObject() after reader.readObject() was called is illegal.");
            value = (JsonObject)reader.read();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            value = reader.readArray();
            LOGGER.info("Calling reader.read() after reader.readArray() was called is illegal.");
            value = (JsonArray)reader.read();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            reader.close();
            LOGGER.info("Calling reader.readObject() after reader.close() is called is illegal.");
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            value = reader.readObject();
            LOGGER.info("Calling reader.readObject() after reader.readObject() was called is illegal.");
            value = reader.readObject();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            JsonObject obj = reader.readObject();
            LOGGER.info("Calling reader.readArray() after reader.readObject() was called is illegal.");
            JsonArray arr = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            reader.close();
            LOGGER.info("Calling reader.readArray() after reader.close() is called is illegal.");
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            value = reader.readArray();
            LOGGER.info("Calling reader.readArray() after reader.readArray() was called is illegal.");
            value = reader.readArray();
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            JsonArray arr = reader.readArray();
            LOGGER.info("Calling reader.readObject() after reader.readArray() was called is illegal.");
            JsonObject obj = reader.readObject();
            pass = false;
            LOGGER.info("obj=" + obj);
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"illegalStateExceptionTests Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void negativeJsonStructureTests() {
        JsonStructure value;
        JsonStructure jsonStructure;
        boolean pass = true;
        JsonReader reader = null;
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if incorrect representation for array.");
            LOGGER.info("Reading [foo,10,\"name\":\"value\"]");
            reader = Json.createReader((java.io.Reader)new StringReader("[foo,10,\"name\":\"value\"]"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if incorrect representation for object.");
            LOGGER.info("Reading {\"name\":\"value\",1,2,3}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\":\"value\",1,2,3}"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Testing for incorrect representation '{]'");
            reader = Json.createReader((java.io.Reader)new StringReader("{]"));
            LOGGER.info("Calling reader.read() with incorrect representation should throw JsonParsingException");
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Testing for missing '['");
            reader = Json.createReader((java.io.Reader)new StringReader("{1,2]}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ']'");
            reader = Json.createReader((java.io.Reader)new StringReader("{[1,2}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing '{'");
            reader = Json.createReader((java.io.Reader)new StringReader("}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing '}'");
            reader = Json.createReader((java.io.Reader)new StringReader("{"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between array elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5\"foo\"]}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between array elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5{}]}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between object elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":\"bar\"5}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing ',' between object elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"one\":1[]}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing key name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{:\"bar\"}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Testing for missing value name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Test for missing double quote on a name");
            reader = Json.createReader((java.io.Reader)new StringReader("{name\" : \"value\"}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Test for missing double quote on a value");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\" : value\"}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value -foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -foo}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value +foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +foo}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value -784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -784foo}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value +784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +784foo}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value 0.1E5E5");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.1E5E5}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value  0.F10");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.F10}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            LOGGER.info("Incorrect digit value string");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : string}"));
            value = reader.read();
            pass = false;
            LOGGER.warning("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            LOGGER.info("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"negativeJsonStructureTests Failed");
    }

    @Test
    public void jsonReaderIOErrorTests() {
        JsonReader reader;
        MyBufferedReader mbr;
        boolean pass = true;
        String jsonArrayText = "[\"name1\",\"value1\"]";
        String jsonObjectText = "{\"name1\":\"value1\"}";
        try {
            LOGGER.info("Trip JsonException if there is an i/o error on JsonReader.close().");
            LOGGER.info("Reading object " + jsonObjectText);
            InputStream is = JSONP_Util.getInputStreamFromString((String)jsonObjectText);
            MyBufferedInputStream mbi = new MyBufferedInputStream(is);
            try (JsonReader reader2 = Json.createReader((InputStream)mbi);){
                JsonObject jsonObject = reader2.readObject();
                LOGGER.info("jsonObject=" + jsonObject);
                mbi.setThrowIOException(true);
                LOGGER.info("Calling JsonReader.close()");
                mbi.setThrowIOException(true);
            }
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonException for JsonReader.read() if i/o error.");
            LOGGER.info("Reading array " + jsonArrayText);
            mbr = new MyBufferedReader((java.io.Reader)new StringReader(jsonArrayText));
            reader = Json.createReader((java.io.Reader)mbr);
            mbr.setThrowIOException(true);
            LOGGER.info("Calling JsonReader.read()");
            JsonStructure jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonException for JsonReader.readArray() if i/o error.");
            LOGGER.info("Reading array " + jsonArrayText);
            mbr = new MyBufferedReader((java.io.Reader)new StringReader(jsonArrayText));
            reader = Json.createReader((java.io.Reader)mbr);
            mbr.setThrowIOException(true);
            LOGGER.info("Calling JsonReader.readArray()");
            JsonArray jsonArray = reader.readArray();
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonException for JsonReader.read() if i/o error.");
            LOGGER.info("Reading object " + jsonObjectText);
            mbr = new MyBufferedReader((java.io.Reader)new StringReader(jsonObjectText));
            reader = Json.createReader((java.io.Reader)mbr);
            mbr.setThrowIOException(true);
            LOGGER.info("Calling JsonReader.readObject()");
            JsonObject jsonObject = reader.readObject();
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonReaderIOErrorTests Failed");
    }

    @Test
    public void invalidLiteralNamesTest() {
        JsonStructure jsonStructure;
        JsonReader reader;
        boolean pass = true;
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if invalid liternal TRUE instead of true.");
            LOGGER.info("Reading [TRUE]");
            reader = Json.createReader((java.io.Reader)new StringReader("[TRUE]"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if invalid liternal FALSE instead of false.");
            LOGGER.info("Reading [FALSE]");
            reader = Json.createReader((java.io.Reader)new StringReader("[FALSE]"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if invalid liternal NULL instead of null.");
            LOGGER.info("Reading [NULL]");
            reader = Json.createReader((java.io.Reader)new StringReader("[NULL]"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if invalid liternal TRUE instead of true.");
            LOGGER.info("Reading {\"true\":TRUE}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"true\":TRUE}"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if invalid liternal FALSE instead of false.");
            LOGGER.info("Reading {\"false\":FALSE}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"false\":FALSE}"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Trip JsonParsingException for JsonReader.read() if invalid liternal NULL instead of null.");
            LOGGER.info("Reading {\"null\":NULL}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"null\":NULL}"));
            jsonStructure = reader.read();
            LOGGER.warning("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            LOGGER.info("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"invalidLiteralNamesTest Failed");
    }

    @Test
    public void jsonReader11Test() {
        Reader readerTest = new Reader();
        TestResult result = readerTest.test();
        result.eval();
    }

    @Test
    public void testDuplicateKeysDefault() {
        HashMap config = new HashMap();
        JsonReaderFactory factory = Json.createReaderFactory(config);
        String json = "{\"val1\":\"A\",\"val1\":\"B\"}";
        JsonReader reader = factory.createReader((java.io.Reader)new StringReader(json));
        JsonObject object = reader.readObject();
        reader.close();
        Assertions.assertEquals((Object)"B", (Object)object.getString("val1"));
    }

    @Test
    public void testDuplicateKeysNone() {
        HashMap<String, JsonConfig.KeyStrategy> config = new HashMap<String, JsonConfig.KeyStrategy>();
        config.put("jakarta.json.JsonConfig.keyStrategy", JsonConfig.KeyStrategy.NONE);
        JsonReaderFactory factory = Json.createReaderFactory(config);
        String json = "{\"val1\":\"A\",\"val1\":\"B\"}";
        JsonReader reader = factory.createReader((java.io.Reader)new StringReader(json));
        try {
            reader.readObject();
            Assertions.fail((String)"It is expected a JsonException");
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateKeysFirst() {
        HashMap<String, JsonConfig.KeyStrategy> config = new HashMap<String, JsonConfig.KeyStrategy>();
        config.put("jakarta.json.JsonConfig.keyStrategy", JsonConfig.KeyStrategy.FIRST);
        JsonReaderFactory factory = Json.createReaderFactory(config);
        String json = "{\"val1\":\"A\",\"val1\":\"B\"}";
        JsonReader reader = factory.createReader((java.io.Reader)new StringReader(json));
        JsonObject object = reader.readObject();
        reader.close();
        Assertions.assertEquals((Object)"A", (Object)object.getString("val1"));
    }

    @Test
    public void testDuplicateKeysLast() {
        HashMap<String, JsonConfig.KeyStrategy> config = new HashMap<String, JsonConfig.KeyStrategy>();
        config.put("jakarta.json.JsonConfig.keyStrategy", JsonConfig.KeyStrategy.LAST);
        JsonReaderFactory factory = Json.createReaderFactory(config);
        String json = "{\"val1\":\"A\",\"val1\":\"B\"}";
        JsonReader reader = factory.createReader((java.io.Reader)new StringReader(json));
        JsonObject object = reader.readObject();
        reader.close();
        Assertions.assertEquals((Object)"B", (Object)object.getString("val1"));
    }
}

