/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.inheritedapi;

import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.inheritedapi.Task;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.servlet.annotation.WebServlet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;

@WebServlet(value={"/CommonServlet"})
public class CommonServlet
extends TestServlet {
    @Resource
    ManagedExecutorService mes;

    public void testExecute() {
        Task.CommonTask commonTask = new Task.CommonTask(0);
        this.mes.execute((Runnable)commonTask);
        try {
            TimeUnit.SECONDS.sleep(3L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.toString());
        }
    }

    public void testSubmit() {
        Task.CommonTask commonTask = new Task.CommonTask(0);
        Future noRes = this.mes.submit((Runnable)commonTask);
        try {
            TestUtil.waitForTaskComplete(noRes);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    public void testInvokeAny() {
        Task.CommonTask commonTask0 = new Task.CommonTask(0);
        Task.CommonTask commonTask1 = new Task.CommonTask(1);
        ArrayList<Task.CommonTask> tasks = new ArrayList<Task.CommonTask>();
        tasks.add(commonTask0);
        tasks.add(commonTask1);
        int res = -1;
        try {
            res = (Integer)this.mes.invokeAny(tasks);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.toString());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertTrue((boolean)((Task.CommonTask)tasks.get(res)).isRan());
    }

    public void testInvokeAll() {
        Task.CommonTask commonTask0 = new Task.CommonTask(0);
        Task.CommonTask commonTask1 = new Task.CommonTask(1);
        ArrayList<Task.CommonTask> tasks = new ArrayList<Task.CommonTask>();
        tasks.add(commonTask0);
        tasks.add(commonTask1);
        List res = null;
        try {
            res = this.mes.invokeAll(tasks);
            TestUtil.waitForTaskComplete((Future)res.get(0));
            TestUtil.waitForTaskComplete((Future)res.get(1));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertTrue((boolean)commonTask0.isRan());
        Assert.assertTrue((boolean)commonTask1.isRan());
    }

    public void testAtMostOnce() {
        Task.CommonTask commonTask = new Task.CommonTask(0);
        Future future = this.mes.submit((Runnable)commonTask);
        try {
            TestUtil.waitForTaskComplete(future);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        Assert.assertEquals((int)commonTask.runCount(), (int)1);
    }
}

