/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedScheduledExecutorService;

import ee.jakarta.tck.concurrent.common.CallableTask;
import ee.jakarta.tck.concurrent.common.CommonTriggers;
import ee.jakarta.tck.concurrent.common.RunnableTask;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.enterprise.concurrent.Trigger;
import jakarta.servlet.annotation.WebServlet;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;

@WebServlet(value={"/ManagedScheduledExecutorServiceServlet"})
public class ManagedScheduledExecutorServiceServlet
extends TestServlet {
    public static final String CALLABLETESTTASK1_RUN_RESULT = "CallableTestTask1";
    private static final String TEST_JNDI_EVN_ENTRY_VALUE = "hello";
    private static final String TEST_JNDI_EVN_ENTRY_JNDI_NAME = "java:comp/env/ManagedScheduledExecutorService_test_string";
    private static final String TEST_CLASSLOADER_CLASS_NAME = ManagedScheduledExecutorServiceServlet.class.getCanonicalName();

    public void normalScheduleProcess1Test() throws Exception {
        ScheduledFuture result = TestUtil.getManagedScheduledExecutorService().schedule((Runnable)new RunnableTask(TEST_JNDI_EVN_ENTRY_JNDI_NAME, TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME), (Trigger)new CommonTriggers.OnceTrigger());
        TestUtil.waitForTaskComplete(result);
        Object obj = result.get();
        if (obj != null) {
            throw new RuntimeException("expected null, instead got result: " + obj.toString());
        }
    }

    public void nullCommandScheduleProcessTest() {
        Runnable command = null;
        try {
            TestUtil.getManagedScheduledExecutorService().schedule(command, (Trigger)new CommonTriggers.OnceTrigger());
        }
        catch (NullPointerException e) {
            return;
        }
        throw new RuntimeException("NullPointerException should be thrown when arg command is null");
    }

    public void normalScheduleProcess2Test() throws Exception {
        ScheduledFuture result = TestUtil.getManagedScheduledExecutorService().schedule(new CallableTask<String>(TEST_JNDI_EVN_ENTRY_JNDI_NAME, TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME, CALLABLETESTTASK1_RUN_RESULT), (Trigger)new CommonTriggers.OnceTrigger());
        TestUtil.waitForTaskComplete(result);
        Object obj = result.get();
        if (CALLABLETESTTASK1_RUN_RESULT.equals(obj)) {
            return;
        }
        throw new RuntimeException("get wrong result:" + obj);
    }

    public void nullCallableScheduleProcessTest() {
        Callable callable = null;
        try {
            TestUtil.getManagedScheduledExecutorService().schedule(callable, (Trigger)new CommonTriggers.OnceTrigger());
        }
        catch (NullPointerException e) {
            return;
        }
        throw new RuntimeException("NullPointerException should be thrown when arg command is null");
    }
}

