/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.convert;

import com.sun.ts.tests.jpa.core.annotations.convert.Employee2;
import com.sun.ts.tests.jpa.core.annotations.convert.SalaryConverter;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name="EMPLOYEE")
@AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="ID")), @AttributeOverride(name="firstName", column=@Column(name="FIRSTNAME")), @AttributeOverride(name="lastName", column=@Column(name="LASTNAME"))})
@Access(value=AccessType.PROPERTY)
public class FullTimeEmployee
extends Employee2
implements Serializable {
    private String salary;

    public FullTimeEmployee() {
    }

    public FullTimeEmployee(int id, String firstName, char[] lastName, String salary) {
        super(id, firstName, lastName);
        this.salary = salary;
    }

    @Column(name="SALARY")
    @Convert(converter=SalaryConverter.class)
    public String getSalary() {
        return this.salary;
    }

    public void setSalary(String salary) {
        this.salary = salary;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", first: " + this.getFirstName());
        StringBuffer sb = new StringBuffer();
        for (char c : this.getLastName()) {
            sb.append(c);
        }
        result.append(", last: " + sb.toString());
        result.append(", salary: " + this.getSalary());
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        return this.getId() + this.getFirstName().hashCode() + this.getLastName().hashCode() + this.getSalary().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FullTimeEmployee)) {
            return false;
        }
        FullTimeEmployee o1 = (FullTimeEmployee)o;
        boolean result = false;
        StringBuffer sb = new StringBuffer();
        for (char c : this.getLastName()) {
            sb.append(c);
        }
        StringBuffer sb1 = new StringBuffer();
        for (char c : o1.getLastName()) {
            sb1.append(c);
        }
        if (this.getId() == o1.getId() && this.getFirstName().equals(o1.getFirstName()) && sb.toString().equals(sb1.toString()) && this.getSalary().equals(o1.getSalary())) {
            result = true;
        }
        return result;
    }
}

