/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.util.ConfigUtil;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Properties;

public class TSKeywords {
    public static final String KEYWORD_PROP_FILE_NAME = "keyword.properties";
    private Properties mapping;
    private String[] keys;
    private String relativeTestDir;
    private boolean loaded;
    private static TSKeywords instance = new TSKeywords();

    private TSKeywords() {
    }

    public static TSKeywords getInstance(File path) {
        if (instance == null) {
            instance = new TSKeywords();
        }
        instance.init(path);
        return instance;
    }

    private void init(File file) {
        if (!this.loaded) {
            this.mapping = ConfigUtil.loadPropertiesFor(KEYWORD_PROP_FILE_NAME);
            this.keys = ConfigUtil.loadKeysFrom(this.mapping);
            this.loaded = true;
        }
        if (this.mapping != null) {
            this.relativeTestDir = TestUtil.getRelativePath(file.getPath());
        }
    }

    public String[] getKeywordSet() {
        if (this.mapping == null || this.keys == null) {
            return TestUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = ConfigUtil.getMappingValue(this.mapping, this.keys, this.relativeTestDir);
        return result;
    }
}

