/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class Debug {
    private static final String SEPARATOR = ".";
    private static final String DEBUG_PREFIX = "debug.";
    private static final String WILD_SUFFIX = "*";
    private static final String TRUE_STRING = "true";
    private static final String MASTER_KEY = "debug.disable";
    private static Properties givenProps;
    private static Properties dProps;
    private static WildcardProperties wildProps;
    private static PrintWriter out;
    private static boolean defaultBool;
    private static int defaultInt;
    private static boolean masterSwitch;

    private Debug() {
    }

    public static void print(String s) {
        out.print(s);
        out.flush();
    }

    public static void println(String s) {
        out.println(s);
        out.flush();
    }

    public static boolean isEnabled() {
        return masterSwitch;
    }

    public static String getSetting(String key) {
        if (!masterSwitch) {
            return null;
        }
        String match = dProps.getProperty(key);
        if (match != null) {
            return match;
        }
        match = wildProps.search(key);
        return match;
    }

    public static boolean getBoolean(Class<?> c) {
        Debug.init(false);
        if (!masterSwitch) {
            return false;
        }
        String key = Debug.getName(c);
        String setting = Debug.getSetting(key);
        return Debug.convertToBool(setting);
    }

    public static boolean getBoolean(Class<?> c, String suffix) {
        Debug.init(false);
        if (!masterSwitch) {
            return false;
        }
        StringBuilder buf = new StringBuilder(Debug.getName(c));
        if (suffix != null && !suffix.isEmpty()) {
            buf.append(SEPARATOR);
            buf.append(suffix);
        }
        String key = buf.toString();
        String setting = Debug.getSetting(key);
        return Debug.convertToBool(setting);
    }

    public static boolean getBoolean(String s) {
        Debug.init(false);
        if (!masterSwitch || s == null) {
            return false;
        }
        String setting = Debug.getSetting(s);
        return Debug.convertToBool(setting);
    }

    public static int getInt(Class<?> c) {
        Debug.init(false);
        if (!masterSwitch || c == null) {
            return 0;
        }
        String key = Debug.getName(c);
        String setting = Debug.getSetting(key);
        return Debug.convertToInt(setting);
    }

    public static int getInt(Class<?> c, String suffix) {
        Debug.init(false);
        if (!masterSwitch || c == null) {
            return 0;
        }
        StringBuilder buf = new StringBuilder(Debug.getName(c));
        if (suffix != null && !suffix.isEmpty()) {
            buf.append(SEPARATOR);
            buf.append(suffix);
        }
        String key = buf.toString();
        String setting = Debug.getSetting(key);
        return Debug.convertToInt(setting);
    }

    public static int getInt(String s) {
        Debug.init(false);
        if (!masterSwitch) {
            return 0;
        }
        String setting = Debug.getSetting(s);
        return Debug.convertToInt(setting);
    }

    public static PrintWriter getWriter() {
        return out;
    }

    public static void setProperties(Properties props) {
        givenProps = props;
    }

    public static synchronized void init(boolean force) {
        Properties props;
        if (dProps != null && !force) {
            return;
        }
        try {
            props = System.getProperties();
        }
        catch (SecurityException e) {
            props = givenProps;
        }
        if (props == null) {
            masterSwitch = false;
            return;
        }
        Enumeration<?> keys = props.propertyNames();
        dProps = new Properties();
        wildProps = new WildcardProperties();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(DEBUG_PREFIX)) continue;
            if (key.equalsIgnoreCase(MASTER_KEY)) {
                String val = props.getProperty(key);
                if (!val.equalsIgnoreCase(TRUE_STRING)) continue;
                masterSwitch = false;
                continue;
            }
            if (key.endsWith(WILD_SUFFIX)) {
                wildProps.put(key.substring(DEBUG_PREFIX.length()), props.getProperty(key));
                continue;
            }
            dProps.put(key.substring(DEBUG_PREFIX.length()), props.getProperty(key));
        }
    }

    private static String getName(Class<?> c) {
        String name = c.getName();
        name = name.replace('$', '.');
        return name;
    }

    private static boolean convertToBool(String setting) {
        if (setting == null) {
            return false;
        }
        if (setting.equalsIgnoreCase(TRUE_STRING)) {
            return true;
        }
        try {
            int num = Integer.parseInt(setting);
            return num > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int convertToInt(String setting) {
        if (setting == null) {
            return 0;
        }
        if (setting.equalsIgnoreCase(TRUE_STRING)) {
            return 1;
        }
        try {
            return Integer.parseInt(setting);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static void setEnabled(String debugKey, boolean state) {
    }

    private static void setEnabled(String debugKey, int level) {
    }

    private static void setOutput(PrintWriter w) {
        out = w;
    }

    static {
        defaultBool = false;
        defaultInt = 0;
        masterSwitch = true;
        out = new PrintWriter(System.err);
    }

    private static class WildcardProperties
    extends Properties {
        static final String wildTail = ".*";

        private WildcardProperties() {
        }

        public String search(String key) {
            String lowerKey = key.toLowerCase();
            String target = this.trimTarget(lowerKey);
            Enumeration<?> keys = this.propertyNames();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                String lowerK = k.toLowerCase();
                if (!lowerK.startsWith(target)) continue;
                String tail = lowerK.substring(target.length());
                String head = lowerK.substring(0, target.length());
                if (!tail.equals(wildTail) && !head.equals(lowerKey)) continue;
                return this.getProperty(k);
            }
            return null;
        }

        String trimTarget(String t) {
            int index = t.lastIndexOf(Debug.SEPARATOR);
            if (index != -1) {
                return t.substring(0, index);
            }
            return t;
        }
    }
}

