/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;

public class FileUTFConverter {
    private static final Logger LOGGER = Logger.getLogger(FileUTFConverter.class.getName());
    private static final String USAGE = "Usage : java FileUTFConverter [-toUTF|-fromUTF] encoding infile outfile";

    public static void main(String[] args) {
        try {
            if (args.length != 4) {
                LOGGER.warning(USAGE);
                System.exit(1);
            }
            if (args[0].equals("-toUTF")) {
                LOGGER.info("FileUTFConverter-> convert UTF-8 encoded input file (" + args[2] + "), to encoding (" + args[1] + ") and write to output file (" + args[3] + ")");
                FileInputStream fis = new FileInputStream(args[2]);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                FileOutputStream fos = new FileOutputStream(args[3]);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, args[1]));
                String s = "";
                while ((s = br.readLine()) != null) {
                    bw.write(s + System.getProperty("line.separator"));
                    bw.flush();
                }
                bw.close();
                br.close();
            } else if (args[0].equals("-fromUTF")) {
                LOGGER.info("FileUTFConverter-> convert UTF encoded input file (" + args[2] + "), from encoding (" + args[1] + ") and write to UTF-8 encoded output file (" + args[3] + ")");
                FileInputStream fis = new FileInputStream(args[2]);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, args[1]));
                FileOutputStream fos = new FileOutputStream(args[3]);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                String s = "";
                while ((s = br.readLine()) != null) {
                    bw.write(s + System.getProperty("line.separator"));
                    bw.flush();
                }
                bw.close();
                br.close();
            } else {
                LOGGER.warning(USAGE);
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

