/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.util;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;

public class MyEncoder {
    private static final Logger LOGGER = Logger.getLogger(MyEncoder.class.getName());
    private static final int NULL = 0;
    private static final String USAGE = "Usage : java MyEncoder #nulls infile outfile";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 3) {
            LOGGER.warning(USAGE);
            System.exit(1);
        }
        InputStreamReader inputStream = null;
        OutputStreamWriter outputStream = null;
        try {
            int i;
            int c;
            int n = Integer.parseInt(args[0]);
            inputStream = new FileReader(args[1]);
            outputStream = new FileWriter(args[2]);
            LOGGER.info("Null  chars: " + args[0]);
            LOGGER.info("Input  file: " + args[1]);
            LOGGER.info("Output file: " + args[2]);
            LOGGER.info("\nCreating an encoded file with each char preceded by " + n + " null chars.\n");
            int nchars = 0;
            while ((c = inputStream.read()) != -1) {
                ++nchars;
                for (i = 0; i < n; ++i) {
                    outputStream.write(0);
                }
                outputStream.write(c);
            }
            if (nchars == 0) {
                for (i = 0; i < n; ++i) {
                    outputStream.write(0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        System.exit(0);
    }
}

