/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonstringtests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.JsonString;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonStringEqualsTest() {
        boolean pass = true;
        try {
            LOGGER.info("Create sample JsonString 1 for testing");
            JsonString string1 = JSONP_Util.createJsonString((String)"Hello World");
            LOGGER.info("string1=" + JSONP_Util.toStringJsonString((JsonString)string1));
            LOGGER.info("Create sample JsonString 2 for testing");
            JsonString string2 = JSONP_Util.createJsonString((String)"Hello World");
            LOGGER.info("string2=" + JSONP_Util.toStringJsonString((JsonString)string2));
            LOGGER.info("Call JsonString.equals() to compare 2 equal JsonStrings and expect true");
            if (string1.equals((Object)string2)) {
                LOGGER.info("JsonStrings are equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonStrings are not equal - unexpected.");
            }
            LOGGER.info("Create sample JsonString 1 for testing");
            string1 = JSONP_Util.createJsonString((String)"Hello World");
            LOGGER.info("string1=" + JSONP_Util.toStringJsonString((JsonString)string1));
            LOGGER.info("Create sample JsonString 2 for testing");
            string2 = JSONP_Util.createJsonString((String)"Hello USA");
            LOGGER.info("string2=" + JSONP_Util.toStringJsonString((JsonString)string2));
            LOGGER.info("Call JsonString.equals() to compare 2 equal JsonStrings and expect false");
            if (!string1.equals((Object)string2)) {
                LOGGER.info("JsonStrings are not equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonStrings are equal - unexpected.");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonStringEqualsTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonStringEqualsTest Failed");
    }

    @Test
    public void jsonStringHashCodeTest() {
        boolean pass = true;
        try {
            LOGGER.info("Create sample JsonString 1 for testing");
            JsonString string1 = JSONP_Util.createJsonString((String)"Hello World");
            LOGGER.info("string1=" + JSONP_Util.toStringJsonString((JsonString)string1));
            LOGGER.info("string1.hashCode()=" + string1.hashCode());
            LOGGER.info("Create sample JsonString 2 for testing");
            JsonString string2 = JSONP_Util.createJsonString((String)"Hello World");
            LOGGER.info("string2=" + JSONP_Util.toStringJsonString((JsonString)string2));
            LOGGER.info("string2.hashCode()=" + string2.hashCode());
            LOGGER.info("Call JsonString.hashCode() to compare 2 equal JsonStrings and expect true");
            if (string1.hashCode() == string2.hashCode()) {
                LOGGER.info("JsonStrings hashCode are equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonStrings hashCode are not equal - unexpected.");
            }
            LOGGER.info("Create sample JsonString 1 for testing");
            string1 = JSONP_Util.createJsonString((String)"Hello World");
            LOGGER.info("string1=" + JSONP_Util.toStringJsonString((JsonString)string1));
            LOGGER.info("string1.hashCode()=" + string1.hashCode());
            LOGGER.info("Create sample JsonString 2 for testing");
            string2 = JSONP_Util.createJsonString((String)"Hello USA");
            LOGGER.info("string2=" + JSONP_Util.toStringJsonString((JsonString)string2));
            LOGGER.info("string2.hashCode()=" + string2.hashCode());
            LOGGER.info("Call JsonString.hashCode() to compare 2 equal JsonStrings and expect false");
            if (string1.hashCode() != string2.hashCode()) {
                LOGGER.info("JsonStrings hashCode are not equal - expected.");
            } else {
                pass = false;
                LOGGER.warning("JsonStrings hashCode are equal - unexpected.");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonStringHashCodeTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonStringHashCodeTest Failed");
    }

    @Test
    public void jsonStringGetCharsTest() {
        boolean pass = true;
        String helloWorld = "Hello World";
        try {
            LOGGER.info("Create sample JsonString for testing");
            JsonString string = JSONP_Util.createJsonString((String)helloWorld);
            LOGGER.info("string=" + JSONP_Util.toStringJsonString((JsonString)string));
            LOGGER.info("Call JsonString.getChars() to return the char sequence for the JSON string");
            CharSequence cs = string.getChars();
            LOGGER.info("charSequence=" + cs.toString());
            LOGGER.info("Checking char sequence for equality to expected string contents");
            if (!JSONP_Util.assertEquals((String)helloWorld, (String)cs.toString())) {
                pass = false;
            }
            LOGGER.info("Checking char sequence for expected equality to string length");
            if (!JSONP_Util.assertEquals((int)helloWorld.length(), (int)cs.length())) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonStringGetCharsTest Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonStringGetCharsTest Failed");
    }
}

