/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonstreamingtests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void streamingTest1() {
        try (Object reader = null;){
            String expJsonText = "[1,2,3,4,5,6,7,8,9,10]";
            LOGGER.info("expJsonText=" + expJsonText);
            LOGGER.info("Generate stream of Json Text containing a JsonArray");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(1).write(2).write(3).write(4).write(5).write(6).write(7).write(8).write(9).write(10).writeEnd();
            generator.close();
            String actJsonText = JSONP_Util.removeWhitespace((String)sWriter.toString());
            LOGGER.info("actJsonText=" + actJsonText);
            LOGGER.info("Compare expJsonText and actJsonText for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)expJsonText, (String)actJsonText), (String)"streamingTest1 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void streamingTest2() {
        try (JsonReader reader = null;){
            LOGGER.info("Generate data containing a JsonArray");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(2).write(4).write(6).write(8).write(10).writeEnd();
            generator.close();
            LOGGER.info("Read data from Writer stream containing a JsonArray");
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonArray expJsonArray = reader.readArray();
            LOGGER.info("Dump of expJsonArray");
            JSONP_Util.dumpJsonArray((JsonArray)expJsonArray);
            LOGGER.info("Write JsonArray out to a Writer stream");
            sWriter = new StringWriter();
            JsonWriter writer = Json.createWriter((Writer)sWriter);
            writer.writeArray(expJsonArray);
            LOGGER.info("Close JsonWriter");
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("writerContents=" + writerContents);
            LOGGER.info("Re-read data from Writer stream containing a JsonArray");
            reader = Json.createReader((Reader)new StringReader(writerContents));
            JsonArray actJsonArray = reader.readArray();
            LOGGER.info("Dump of actJsonArray");
            JSONP_Util.dumpJsonArray((JsonArray)actJsonArray);
            LOGGER.info("Compare expJsonArray and actJsonArray for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonArrays((JsonArray)expJsonArray, (JsonArray)actJsonArray), (String)"streamingTest2 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void streamingTest3() {
        JsonParser parser = null;
        try (JsonReader reader = null;){
            LOGGER.info("Generate data containing a JsonObject");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("two", 2).write("false", false).writeEnd();
            generator.close();
            LOGGER.info("Read data from Writer stream containing a JsonObject");
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonObject expJsonObject = reader.readObject();
            LOGGER.info("Dump of expJsonObject");
            JSONP_Util.dumpJsonObject((JsonObject)expJsonObject);
            LOGGER.info("Write JsonObject out to a Writer stream");
            sWriter = new StringWriter();
            JsonWriter writer = Json.createWriter((Writer)sWriter);
            writer.writeObject(expJsonObject);
            LOGGER.info("Close JsonWriter");
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            LOGGER.info("writerContents=" + writerContents);
            LOGGER.info("Parse data from Writer stream containing a JsonObject");
            parser = Json.createParser((InputStream)JSONP_Util.getInputStreamFromString((String)writerContents));
            JSONP_Util.resetParseErrs();
            JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.START_OBJECT);
            JSONP_Util.testKeyIntegerValue((JsonParser)parser, (String)"two", (int)2);
            JSONP_Util.testKeyFalseValue((JsonParser)parser, (String)"false");
            JSONP_Util.testEventType((JsonParser)parser, (JsonParser.Event)JsonParser.Event.END_OBJECT);
            int parseErrs = JSONP_Util.getParseErrs();
            Assertions.assertTrue((parseErrs == 0 ? 1 : 0) != 0, (String)("StreamingTest3 Failed. There were " + parseErrs + " parser errors that occurred."));
        }
    }

    @Test
    public void streamingTest4() {
        boolean pass = true;
        JsonReader reader = null;
        Object parser = null;
        String expJsonText = "{\"two\":2,\"false\":false}";
        try {
            LOGGER.info("Generate data containing a JsonObject to an OutputStream");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGenerator((OutputStream)baos);
            generator.writeStartObject().write("two", 2).write("false", false).writeEnd();
            baos.close();
            generator.close();
            LOGGER.info("Compare JSON text generated to what is expected.");
            if (!JSONP_Util.assertEqualsJsonText((String)expJsonText, (String)JSONP_Util.removeWhitespace((String)baos.toString("UTF-8")))) {
                pass = false;
            }
            LOGGER.info("Read data from InputStream containing a JsonObject");
            reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString((String)baos.toString("UTF-8")));
            JsonObject expJsonObject = reader.readObject();
            LOGGER.info("Close JsonReader");
            reader.close();
            LOGGER.info("Dump of expJsonObject");
            JSONP_Util.dumpJsonObject((JsonObject)expJsonObject);
            LOGGER.info("Write JsonObject back out to an OutputStream");
            baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriter((OutputStream)baos);
            writer.writeObject(expJsonObject);
            LOGGER.info("Close JsonWriter");
            baos.close();
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String writerContents = baos.toString("UTF-8");
            LOGGER.info("writerContents=" + writerContents);
            LOGGER.info("Compare again JSON text generated to what is expected.");
            if (!JSONP_Util.assertEqualsJsonText((String)expJsonText, (String)JSONP_Util.removeWhitespace((String)writerContents))) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"streamingTest4 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"streamingTest4 Failed");
    }
}

