/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.common;

import ee.jakarta.tck.jsonp.api.common.JsonValueType;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ObjectBuilder {
    public static JsonObjectBuilder add(JsonObjectBuilder builder, String name, Object value) {
        switch (JsonValueType.getType(value)) {
            case String: {
                return builder.add(name, (String)value);
            }
            case Integer: {
                return builder.add(name, ((Integer)value).intValue());
            }
            case Long: {
                return builder.add(name, ((Long)value).intValue());
            }
            case BigInteger: {
                return builder.add(name, (BigInteger)value);
            }
            case Double: {
                return builder.add(name, ((Double)value).doubleValue());
            }
            case BigDecimal: {
                return builder.add(name, (BigDecimal)value);
            }
            case Boolean: {
                return builder.add(name, ((Boolean)value).booleanValue());
            }
            case JsonValue: {
                return builder.add(name, (JsonValue)value);
            }
            case Null: {
                return builder.addNull(name);
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }
}

