/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSLogger;
import com.sun.ant.taskdefs.common.DoTargetHandler;
import java.io.File;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DoTarget
extends Task {
    private boolean foundTarget = false;
    private String srcdir;
    private String todo;
    private String includes;
    private String excludes;
    private String[] includesArray;
    private String[] excludesArray;
    DoTargetHandler handler = null;
    SAXParserFactory factory = null;
    SAXParser saxParser = null;

    public void setIncludes(String inc) {
        this.includes = inc;
    }

    public void setExcludes(String exc) {
        this.excludes = exc;
    }

    private void setupParser() throws ParserConfigurationException, SAXException {
        this.handler = new DoTargetHandler();
        this.handler.setTarget(this.todo);
        this.factory = SAXParserFactory.newInstance();
        this.saxParser = this.factory.newSAXParser();
    }

    private void myinit() {
        String item;
        int i;
        if (this.excludes != null && this.excludes.length() != 0) {
            StringTokenizer st1 = new StringTokenizer(this.excludes, ", \t\n\r\f");
            int tokens1 = st1.countTokens();
            this.excludesArray = new String[tokens1];
            for (i = 0; i < tokens1; ++i) {
                item = st1.nextToken();
                if (item.endsWith("build.xml")) {
                    this.excludesArray[i] = item;
                    continue;
                }
                if (!item.endsWith("/") && !item.endsWith("\\")) {
                    item = item + "/";
                }
                this.excludesArray[i] = item;
            }
        }
        if (this.includes == null || this.includes.length() == 0) {
            this.includesArray = new String[1];
            this.includesArray[0] = "**/build.xml";
        } else {
            StringTokenizer st2 = new StringTokenizer(this.includes, ", \t\n\r\f");
            int tokens2 = st2.countTokens();
            this.includesArray = new String[tokens2];
            for (i = 0; i < tokens2; ++i) {
                item = st2.nextToken();
                if (item.endsWith("build.xml")) {
                    this.includesArray[i] = item;
                    continue;
                }
                if (!item.endsWith("/") && !item.endsWith("\\")) {
                    item = item + "/";
                }
                this.includesArray[i] = item = item + "**/build.xml";
            }
        }
    }

    public void execute() throws BuildException {
        File currentDir = null;
        String[] buildfiles = null;
        try {
            this.myinit();
            this.setupParser();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setIncludes(this.includesArray);
            ds.setExcludes(this.excludesArray);
            ds.setBasedir(new File(this.srcdir));
            ds.scan();
            buildfiles = ds.getIncludedFiles();
        }
        catch (Throwable th) {
            th.printStackTrace();
            TSLogger.addFailedDir("While initializing doTarget and scanning.");
        }
        for (int i = 0; i < buildfiles.length; ++i) {
            try {
                File leafDir;
                File leafBuildFile = new File(this.srcdir, (String)buildfiles[i]);
                this.handler.initResult();
                this.saxParser.parse(leafBuildFile, (DefaultHandler)this.handler);
                if (!this.handler.getResult()) continue;
                currentDir = leafDir = new File(this.srcdir, buildfiles[i]).getParentFile();
                Ant antTask = new Ant();
                antTask.setProject(this.project);
                antTask.init();
                antTask.setInheritAll(false);
                antTask.setAntfile("build.xml");
                antTask.setDir(leafDir);
                antTask.setTarget(this.todo);
                String msg = "Entering " + leafDir.getPath();
                this.log(msg);
                antTask.execute();
                antTask = null;
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
                TSLogger.addFailedDir(currentDir == null ? "Unknown" : currentDir.getPath());
            }
        }
    }

    public void setSrcdir(String srcdir) {
        this.srcdir = srcdir;
    }

    public void setTodo(String todo) {
        this.todo = todo;
    }
}

