/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.sessiontests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Enumeration;
import java.util.Properties;

public class SessionTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.sessiontests.SessionTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;

    public static void main(String[] args) {
        SessionTests theTests = new SessionTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
    }

    public void SimpleSendAndReceiveQ() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "SimpleSendAndReceiveQ");
            this.logTrace("Sending message to a Queue");
            this.tool.getDefaultProducer().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived.getText().equals(messageSent.getText())) {
                this.logMsg("Message text: \"" + messageReceived.getText() + "\"");
                this.logMsg("Received correct message");
            } else {
                this.logErr("didn't get the right message using Queue");
                pass = false;
            }
            if (!pass) {
                throw new Exception("SimpleSendAndReceiveQ Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("SimpleSendAndReceiveQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void SimpleSendAndReceiveT() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "SimpleSendAndReceiveT");
            this.logTrace("Sending message to a Topic");
            this.tool.getDefaultProducer().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived.getText().equals(messageSent.getText())) {
                this.logMsg("Message text: \"" + messageReceived.getText() + "\"");
                this.logMsg("Received correct message");
            } else {
                this.logErr("didn't get the right message");
                pass = false;
            }
            if (!pass) {
                throw new Exception("SimpleSendAndReceiveT Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("SimpleSendAndReceiveT");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void selectorAndBrowserTests() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage tempMsg = null;
            boolean pass = true;
            int numMessages = 2;
            QueueBrowser browseAll = null;
            QueueBrowser selectiveBrowser = null;
            String message = "Just a Test Message from JMS TCK";
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConsumer().close();
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "selectorAndBrowserTests");
            messageSent.setText(message);
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultProducer().send((Message)messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultProducer().send((Message)messageSent);
            browseAll = this.tool.getDefaultSession().createBrowser((Queue)this.tool.getDefaultDestination());
            int msgCount = 0;
            Enumeration msgs = null;
            int i = 0;
            do {
                msgCount = 0;
                msgs = browseAll.getEnumeration();
                TestUtil.logTrace((String)("getting Enumeration " + ++i));
                while (msgs.hasMoreElements()) {
                    tempMsg = (TextMessage)msgs.nextElement();
                    if (!tempMsg.getText().equals(messageSent.getText())) continue;
                    ++msgCount;
                }
                TestUtil.logTrace((String)("found " + msgCount + " messages total in browser"));
            } while (msgCount < 2 && i < 10);
            if (!browseAll.getQueue().toString().equals(this.tool.getDefaultDestination().toString())) {
                pass = false;
                this.logErr("Error: QueueBrowser.getQueue test failed");
                this.logErr("QueueBrowser.getQueue=" + browseAll.getQueue().toString() + ".");
                this.logErr("tool.getDefaultDestination()=" + this.tool.getDefaultDestination().toString() + ".");
            }
            browseAll.close();
            selectiveBrowser = this.tool.getDefaultSession().createBrowser((Queue)this.tool.getDefaultDestination(), "TEST = 'test'");
            i = 0;
            do {
                msgCount = 0;
                msgs = selectiveBrowser.getEnumeration();
                TestUtil.logTrace((String)("getting Enumeration " + ++i));
                while (msgs.hasMoreElements()) {
                    tempMsg = (TextMessage)msgs.nextElement();
                    if (!tempMsg.getText().equals(messageSent.getText())) continue;
                    ++msgCount;
                }
                TestUtil.logTrace((String)("found " + msgCount + " messages total in browser"));
            } while (msgCount < 1 && i < 10);
            String tmp = selectiveBrowser.getMessageSelector();
            if (tmp.indexOf("TEST") < 0 || tmp.indexOf("test") < 0) {
                pass = false;
                this.logErr("Error: QueueBrowser.getMessageSelector test failed");
                this.logErr("selectiveBrowser.getMessageSelector()=" + selectiveBrowser.getMessageSelector());
            }
            selectiveBrowser.close();
            MessageConsumer SelectorConsumer = this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination(), "TEST = 'test'");
            this.logTrace("Receiving message with selective consumer");
            messageReceived = (TextMessage)SelectorConsumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                this.logErr("Did not receive expected message");
            } else if (!messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                this.logErr("Received incorrect message");
            }
            SelectorConsumer.close();
            MessageConsumer qRec = this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination());
            this.logTrace("Receiving the remaining message");
            messageReceived = (TextMessage)qRec.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                this.logErr("message did not remain on queue");
            } else if (messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                this.logErr("received incorrect message");
            }
            qRec.close();
            if (!pass) {
                throw new Exception("selectorAndBrowserTests Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("selectorAndBrowserTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void SubscriberTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        TextMessage messageSent = null;
        TextMessage messageReceived = null;
        Object tempMsg = null;
        int numMessages = 2;
        boolean pass = true;
        TopicSubscriber defaultSub = null;
        TopicSubscriber tSubSelect = null;
        TopicSubscriber tSubNoLocal = null;
        String subscriptionName1 = "DurableSubscriberNoLocal";
        String subscriptionName2 = "DurableSubscriberSelect";
        String subscriptionName3 = "DurableSubscriberDefault";
        Connection newConn = null;
        Session newSess = null;
        MessageProducer newPub = null;
        String clientID = "CTS";
        try {
            this.logTrace("Setup tool for COMMON_T setup");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.logTrace("Create second connection and second session");
            newConn = this.tool.getNewConnection(14, this.user, this.password, lookup);
            newSess = newConn.createSession(false, 1);
            this.logTrace("Create 3 durabale subscriptions (default, selector, nolocal) using second session");
            tSubNoLocal = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), subscriptionName1, "", true);
            tSubSelect = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), subscriptionName2, "TEST = 'test'", false);
            defaultSub = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), subscriptionName3);
            this.logTrace("Create producer using second session");
            newPub = newSess.createProducer(this.tool.getDefaultDestination());
            this.tool.getDefaultConnection().start();
            newConn.start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("Just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "SubscriberTests");
            this.logTrace("Sending message to a Topic");
            messageSent.setBooleanProperty("lastMessage", false);
            newPub.send((Message)messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.send((Message)messageSent);
            this.logTrace("tSubNoLocal Receiving message");
            messageReceived = (TextMessage)tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                pass = false;
                this.logErr("Error:  No_local subscriber did receive local message");
            }
            this.logTrace("defaultSub Receiving message");
            for (int i = 0; i < numMessages; ++i) {
                messageReceived = (TextMessage)defaultSub.receive(this.timeout);
                if (messageReceived == null) {
                    pass = false;
                    this.logErr("Error:  Did not receive message " + i);
                    continue;
                }
                if (messageReceived.getText().equals(messageSent.getText())) {
                    this.logMsg("Message text: \"" + messageReceived.getText() + "\"");
                    this.logMsg("Received correct message " + i);
                    continue;
                }
                this.logErr("Error: didn't get the right message " + i);
                pass = false;
            }
            this.logTrace("tSubSelect Receiving message");
            messageReceived = (TextMessage)tSubSelect.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                this.logErr("Error:  Did not receive correct message");
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                this.logMsg("Message text: \"" + messageReceived.getText() + "\"");
                this.logMsg("Received correct message");
            } else {
                this.logErr("Error: didn't get the right message");
                pass = false;
            }
            this.logTrace("sending message from default connection");
            messageSent.setBooleanProperty("newConnection", true);
            this.tool.getDefaultProducer().send((Message)messageSent);
            this.logTrace("tSubNoLocal Receiving message");
            messageReceived = (TextMessage)tSubNoLocal.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                this.logErr("Error:  Did not receive correct message");
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                this.logMsg("Message text: \"" + messageReceived.getText() + "\"");
                this.logMsg("Received correct message");
            } else {
                this.logErr("Error: didn't get the right message");
                pass = false;
            }
            if (!pass) {
                throw new Exception("SubscriberTests Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("SubscriberTests");
        }
        finally {
            try {
                this.logTrace("Close 3 durable subscriptions");
                tSubNoLocal.close();
                defaultSub.close();
                tSubSelect.close();
                this.logTrace("Unsubscribe from 3 durable subscriptions");
                newSess.unsubscribe(subscriptionName1);
                newSess.unsubscribe(subscriptionName2);
                newSess.unsubscribe(subscriptionName3);
            }
            catch (Exception ex) {
                this.logErr("Error closing subscribers and unsubscribing from subscriptions", ex);
            }
            try {
                this.logTrace("Closing new connection");
                newConn.close();
            }
            catch (Exception ex) {
                this.logErr("Error closing the second Connection", ex);
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Default Connection", ex);
            }
        }
    }

    public void IllegalStateTestQ() throws Exception {
        try {
            TextMessage messageSent = null;
            Object messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "IllegalStateTestQ");
            this.logTrace("Sending message to a Queue");
            this.tool.getDefaultProducer().send((Message)messageSent);
            try {
                this.logTrace("Rolling back a non-transacted session must throw IllegalStateException");
                this.tool.getDefaultSession().rollback();
                pass = false;
                this.logErr("Error: QueueSession.rollback() didn't throw expected IllegalStateException");
            }
            catch (IllegalStateException en) {
                this.logMsg("Got expected IllegalStateException from QueueSession.rollback()");
            }
            if (!pass) {
                throw new Exception("IllegalStateTestQ");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("IllegalStateTestQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void ackTests() throws Exception {
        try {
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            if (this.tool.getDefaultSession().getAcknowledgeMode() != 1) {
                pass = false;
                this.logErr("Error: getAcknowledgeMode failed");
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            if (this.tool.getDefaultSession().getAcknowledgeMode() != 1) {
                pass = false;
                this.logErr("Error: getAcknowledgeMode failed");
            }
            if (!pass) {
                throw new Exception("ackTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("ackTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void InvalidDestinationTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TopicSubscriber tsub;
            boolean pass = true;
            Destination dummy = null;
            Topic dummyT = null;
            Queue dummyQ = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                this.logErr("Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                this.logErr("Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                this.logErr("Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String, true) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ);
                this.logErr("Error: createBrowser(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createBrowser(null)");
            }
            catch (Exception e) {
                this.logErr("Error: createBrowser(null) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ, "TEST = 'test'");
                this.logErr("Error: createBrowser(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createBrowser(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createBrowser(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing the default Connection", ex);
            }
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                this.logErr("Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                this.logErr("Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                this.logErr("Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(null, String, true) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing default Connection", ex);
            }
            Connection newConn = this.tool.getNewConnection(14, this.user, this.password, lookup);
            Session newSession = newConn.createSession(false, 1);
            try {
                newSession.unsubscribe("foo");
                this.logErr("Error: unsubscribe(foo) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from unsubscribe(foo)");
            }
            catch (Exception e) {
                this.logErr("Error: unsubscribe(foo) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                tsub = newSession.createDurableSubscriber(dummyT, "cts");
                this.logErr("Error: createDurableSubscriber(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
                tsub.close();
                newSession.unsubscribe("cts");
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createDurableSubscriber(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createDurableSubscriber(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                tsub = newSession.createDurableSubscriber(dummyT, "cts", "TEST = 'test'", true);
                this.logErr("Error: createDurableSubscriber(null, String, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
                tsub.close();
                newSession.unsubscribe("cts");
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createDurableSubscriber(null, String, String, boolean)");
            }
            catch (Exception e) {
                this.logErr("Error: createDurableSubscriber(null, String, String, boolean) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                newConn.close();
            }
            catch (Exception ex) {
                this.logErr("Error closing new Connection", ex);
            }
            if (!pass) {
                throw new Exception("InvalidDestinationTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidDestinationTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }

    public void InvalidSelectorTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination(), "=TEST 'test'");
                this.logErr("Error: createConsumer(Destination, String) didn't throw expected InvalidSelectorException");
                pass = false;
            }
            catch (InvalidSelectorException ex) {
                this.logMsg("Got expected InvalidSelectorException from createConsumer(Destination, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(Destination, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser((Queue)this.tool.getDefaultDestination(), "=TEST 'test'");
                this.logErr("Error: createBrowser(Queue, String) didn't throw expected InvalidSelectorException");
                pass = false;
            }
            catch (InvalidSelectorException ex) {
                this.logMsg("Got expected InvalidSelectorException from createBrowser(Queue, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createBrowser(Queue, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            Connection newConn = this.tool.getNewConnection(14, this.user, this.password, lookup);
            Session newSess = newConn.createSession(false, 1);
            try {
                TopicSubscriber tsub = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), "mysubscription", "=TEST 'test'", true);
                this.logErr("Error: createDurableSubscriber(Topic, String, String, boolean) didn't throw expected InvalidSelectorException");
                pass = false;
                tsub.close();
                newSess.unsubscribe("mysubscription");
            }
            catch (InvalidSelectorException ex) {
                this.logMsg("Got expected InvalidSelectorException from createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                this.logErr("Error: createDurableSubscriber(Topic, String, String, boolean) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                newConn.close();
            }
            catch (Exception ex) {
                this.logErr("Error closing new Connection", ex);
            }
            try {
                this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination(), "=TEST 'test'", true);
                this.logErr("Error: createConsumer(Destination, String, boolean) didn't throw expected InvalidSelectorException");
                pass = false;
            }
            catch (InvalidSelectorException ex) {
                this.logMsg("Got expected InvalidSelectorException from createConsumer(Destination, String, boolean)");
            }
            catch (Exception e) {
                this.logErr("Error: createConsumer(Destination, String, boolean) throw incorrect Exception: ", e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("InvalidSelectorTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidSelectorTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                this.logErr("Error closing Connection", ex);
            }
        }
    }
}

