/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.generator;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.types.generator.Client;
import ee.jakarta.tck.persistence.core.types.generator.DataTypes2;
import java.util.Properties;

public class Client2
extends Client {
    private DataTypes2 d10;

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        block4: {
            this.logTrace("setupDataTypes2");
            try {
                super.setup(args, p);
                String s = p.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    this.logMsg("db.supports.sequence:" + this.supports_sequence);
                    if (this.supports_sequence) {
                        this.removeTestData();
                        this.createDataTypes2Data();
                    }
                    break block4;
                }
                this.logErr("The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new Exception("setupDataTypes2 failed");
            }
            catch (Exception e) {
                this.logErr("Exception: ", e);
                throw new Exception("setupDataTypes2 failed:", e);
            }
        }
    }

    public void generatorTypeSequenceTest() throws Exception {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Float newFloat = Float.valueOf(3.0f);
                try {
                    this.getEntityTransaction().begin();
                    int id = this.d10.getId();
                    this.logTrace("Doing a find of id: " + id);
                    DataTypes2 d = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)id);
                    if (null != d) {
                        Float f = d.getFloatData();
                        if (f.equals(this.d10.getFloatData())) {
                            this.logTrace("find returned correct float value:" + f);
                            d.setFloatData(newFloat);
                        } else {
                            this.logErr("find did not return correct float value, expected: 1.0, actual:" + f);
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        f = d.getFloatData();
                        if (f.equals(newFloat)) {
                            this.logTrace("Successfully set float value to:" + newFloat);
                        } else {
                            this.logErr("Could not update float value, expected: " + newFloat + ", actual:" + f);
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    this.logErr("find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                    pass = false;
                }
            } else {
                this.logMsg("WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new Exception("generatorTypeSequenceTest failed");
        }
    }

    public void createDataTypes2Data() {
        try {
            this.getEntityTransaction().begin();
            this.logTrace("in createDataTypes2Data");
            this.logTrace("new DataType2");
            this.d10 = new DataTypes2(Character.valueOf('a'), (short)100, 500, 300L, 50.0, Float.valueOf(1.0f));
            this.logTrace("Persist DataType2");
            this.getEntityManager().persist((Object)this.d10);
            this.logTrace("DataType2 id:" + this.d10.getId());
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
    }
}

