/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.relationship.unionexmany;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.relationship.unionexmany.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.relationship.unionexmany.Uni1XMProject;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uni1XMTest1() throws Exception {
        this.logTrace("Begin uni1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Uni1XMProject project1 = new Uni1XMProject(1L, "JavaEE", Float.valueOf(500.0f));
            Uni1XMProject project2 = new Uni1XMProject(2L, "Identity", Float.valueOf(500.0f));
            Uni1XMPerson person = new Uni1XMPerson(1L, "Duke");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person);
            this.logTrace("persisted Person and Projects");
            Vector<Uni1XMProject> projects = new Vector<Uni1XMProject>();
            projects.add(project1);
            projects.add(project2);
            person.setProjects(projects);
            this.getEntityManager().merge((Object)person);
            this.logTrace("merged Contents of Person Entity");
            Uni1XMPerson newPerson = (Uni1XMPerson)this.getEntityManager().find(Uni1XMPerson.class, (Object)1L);
            boolean pass1 = false;
            boolean pass2 = false;
            if (newPerson != null) {
                Collection<Uni1XMProject> newProjects = newPerson.getProjects();
                for (Uni1XMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    pass2 = true;
                }
            }
            if (pass1 && pass2) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("uni1XMTest1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1XMPERSON_UNI1XMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1XMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM UNI1XMPERSON").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

