/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.language;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Util;
import ee.jakarta.tck.persistence.core.versioning.Member;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class Client3
extends Util {
    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest3() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers with Alias: imc");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FrOm Customer c, In(c.aliases) a WHERE a.alias = :aName").setParameter("aName", (Object)"imc").getResultList();
            String[] expectedPKs = new String[]{"8"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest3 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest20() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who do not have aliases");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.aliases IS EMPTY").getResultList();
            String[] expectedPKs = new String[]{"6", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest20 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest21() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who have aliases");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c WHERE c.aliases IS NOT EMPTY").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest21 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest24() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all aliases who have match: stevie");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) From Alias a WHERE a.alias = CONCAT('ste', 'vie')").getResultList();
            String[] expectedPKs = new String[]{"14"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + a.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest24 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest25() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all aliases containing the substring: iris");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) From Alias a WHERE a.alias = SUBSTRING(:string1, :int2, :int3)").setParameter("string1", (Object)"iris").setParameter("int2", (Object)1).setParameter("int3", (Object)4).getResultList();
            String[] expectedPKs = new String[]{"20"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + a.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest25 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest26() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find aliases whose alias name is greater than 4 characters");
            List a = this.getEntityManager().createQuery("Select Distinct OBjeCt(a) From Alias a WHERE LENGTH(a.alias) > 4").getResultList();
            String[] expectedPKs = new String[]{"8", "10", "13", "14", "18", "28", "29"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + a.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest26 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest28() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all aliases who contain the string: ev in their alias name");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) from Alias a where LOCATE('ev', a.alias) = 3").getResultList();
            String[] expectedPKs = new String[]{"13", "14", "18"};
            if (!this.checkEntityPK(a, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + a.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest28 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest29() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find aliases who are members of customersNoop");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) FROM Alias a WHERE a.customerNoop MEMBER OF a.customersNoop").getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(a, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + a.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest29 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest30() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find aliases who are NOT members of collection");
            List a = this.getEntityManager().createQuery("Select Distinct Object(a) FROM Alias a WHERE a.customerNoop NOT MEMBER OF a.customersNoop").getResultList();
            String[] expectedPKs = new String[this.aliasRef.length];
            for (int i = 0; i < this.aliasRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(a, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + this.aliasRef.length + "references, got: " + a.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest30 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest31() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers with an alias LIKE: sh_ll");
            List c = this.getEntityManager().createQuery("select distinct Object(c) FROM Customer c, in(c.aliases) a WHERE a.alias LIKE 'sh\\_ll' escape '\\'").getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest31 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest49() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers who have a null relationship");
            List c = this.getEntityManager().createQuery("Select Distinct Object(c) FROM Customer c, in(c.aliases) a WHERE a.customerNoop IS NULL").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 13 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest49 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest50() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers with an alias that contains an underscore");
            List c = this.getEntityManager().createQuery("select distinct Object(c) FROM Customer c, in(c.aliases) a WHERE a.alias LIKE '%\\_%' escape '\\'").getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest50 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest52() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("determine if customer has a NULL relationship");
            List c = this.getEntityManager().createQuery("select Distinct Object(c) from Customer c, in(c.aliases) a where c.name = :cName AND a.customerNoop IS NULL").setParameter("cName", (Object)"Shelly D. McGowan").getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest52 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest53() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("determine if customer has a NULL relationship");
            List c = this.getEntityManager().createQuery("select distinct object(c) fRoM Customer c, IN(c.aliases) a where c.name = :cName OR a.customerNoop IS NULL").setParameter("cName", (Object)"Arthur D. Frechette").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(c, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 13 references, got: " + c.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest53 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_leftouterjoin_MxM() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"7", "sjc"}, {"5", "ssd"}, {"7", "stevec"}, {"5", "steved"}, {"5", "stevie"}, {"7", "stevie"}};
        try {
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("SELECT c.id, a.alias from Customer c LEFT OUTER JOIN c.aliases a where c.name LIKE 'Ste%' ORDER BY a.alias, c.id").getResultList();
            if (q.size() != 6) {
                this.logTrace("test_leftouterjoin_MxM:  Did not get expected results. Expected 6,  got: " + q.size());
            } else {
                this.logTrace("Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    pass1 = true;
                    Object obj = q.get(i);
                    Object[] customerAndAliasExpected = expectedResultSet[i];
                    if (obj instanceof Object[]) {
                        this.logTrace("The element in the result list is of type Object[], continue . . .");
                        Object[] customerAndAlias = (Object[])obj;
                        if (Arrays.equals(customerAndAliasExpected, customerAndAlias)) continue;
                        this.logErr("Expecting element value: " + String.valueOf(Arrays.asList(customerAndAliasExpected)) + ", actual element value: " + String.valueOf(Arrays.asList(customerAndAlias)));
                        pass2 = false;
                        break;
                    }
                    pass2 = false;
                    this.logErr("The element in the result list is not of type Object[]:" + String.valueOf(obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("test_leftouterjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_upperStringExpression() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(c) FROM Customer c JOIN c.aliases a where UPPER(a.alias)='SJC' ").getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception caught exception in test_upperStringExpression: ", e);
        }
        if (!pass) {
            throw new Exception("test_upperStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_lowerStringExpression() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("select Object(c) FROM Customer c JOIN c.aliases a where LOWER(a.alias)='sjc' ").getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception caught exception in test_lowerStringExpression: ", e);
        }
        if (!pass) {
            throw new Exception("test_lowerStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_innerjoin_MxM() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT Object(c) from Customer c INNER JOIN c.aliases a where a.alias = :aName ").setParameter("aName", (Object)"fish").getResultList();
            String[] expectedPKs = new String[]{"1", "2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_fetchjoin_MxM() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FETCHJOIN-MXM Executing Query");
            List result = this.getEntityManager().createQuery("SELECT DISTINCT a from Alias a LEFT JOIN FETCH a.customers where a.alias LIKE 'a%' ").getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_substringHavingClause() throws Exception {
        boolean pass = false;
        Long expectedCount = 2L;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Executing Query");
            Query q = this.getEntityManager().createQuery("select count(c) FROM Customer c JOIN c.aliases a GROUP BY a.alias HAVING a.alias = SUBSTRING(:string1, :int1, :int2)").setParameter("string1", (Object)"fish").setParameter("int1", (Object)1).setParameter("int2", (Object)4);
            Long result = (Long)q.getSingleResult();
            this.logTrace("Check results received .  .  .");
            if (expectedCount.equals(result)) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results. Expected Count of 2, got: " + String.valueOf(result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception(" test_substringHavingClause failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_leftStringExpression() throws Exception {
        boolean pass = false;
        String expectedName = this.customerRef[7].getName().substring(0, 8);
        try {
            this.getEntityTransaction().begin();
            String result = (String)this.getEntityManager().createQuery("select LEFT(c.name, 8) FROM Customer c WHERE LEFT(c.name, 5)='Irene' ", String.class).getSingleResult();
            if (!result.equals(expectedName)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result);
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception caught exception in test_leftStringExpression: ", e);
        }
        if (!pass) {
            throw new Exception("test_leftStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_rightStringExpression() throws Exception {
        boolean pass = false;
        String expectedName = this.customerRef[7].getName().substring(6, 15);
        try {
            this.getEntityTransaction().begin();
            String result = (String)this.getEntityManager().createQuery("select RIGHT(c.name, 9) FROM Customer c WHERE RIGHT(c.name, 9)='M. Caruso' ", String.class).getSingleResult();
            if (!result.equals(expectedName)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result);
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception caught exception in test_rightStringExpression: ", e);
        }
        if (!pass) {
            throw new Exception("test_rightStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_concatStringOperator() throws Exception {
        boolean pass = false;
        String expectedResult = this.customerRef[7].getId() + this.customerRef[7].getName() + this.customerRef[7].getCountry().getCountry();
        try {
            this.getEntityTransaction().begin();
            String result = (String)this.getEntityManager().createQuery("select c.id || c.name || c.country.country FROM Customer c WHERE c.id || c.name = '8Irene M. Caruso' ", String.class).getSingleResult();
            if (!result.equals(expectedResult)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result);
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception caught exception in test_concatStringOperator: ", e);
        }
        if (!pass) {
            throw new Exception("test_concatStringOperator failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_castExpression() throws Exception {
        boolean pass = false;
        int expectedId = Integer.valueOf(this.customerRef[7].getId());
        try {
            this.getEntityTransaction().begin();
            int result = (Integer)this.getEntityManager().createQuery("select CAST(c.id AS INTEGER) FROM Customer c WHERE CAST(c.id AS INTEGER)=8 ", Integer.class).getSingleResult();
            if (result != expectedId) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result);
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception caught exception in test_castExpression: ", e);
        }
        if (!pass) {
            throw new Exception("test_castExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_unionOperator() throws Exception {
        boolean pass = false;
        String[] expectedPKs = new String[]{"1", "2", "3", "6", "7", "8"};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("UNION Executing Query");
            List result = this.getEntityManager().createQuery("SELECT c from Customer c WHERE c.id IN ('1', '2', '3') UNION SELECT c from Customer c WHERE c.id IN ('6', '7', '8')").getResultList();
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 6 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_unionOperator failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_intersectOperator() throws Exception {
        boolean pass = false;
        String[] expectedPKs = new String[]{"2", "3"};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("UNION Executing Query");
            List result = this.getEntityManager().createQuery("SELECT c from Customer c WHERE c.id IN ('1', '2', '3') INTERSECT SELECT c from Customer c WHERE c.id IN ('2', '3', '4')").getResultList();
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_intersectOperator failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_exceptOperator() throws Exception {
        boolean pass = false;
        String[] expectedPKs = new String[]{"1", "2"};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("UNION Executing Query");
            List result = this.getEntityManager().createQuery("SELECT c from Customer c WHERE c.id IN ('1', '2', '3', '4') EXCEPT SELECT c from Customer c WHERE c.id IN ('3', '4')").getResultList();
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_exceptOperator failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_orderByNullsFirst() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("UNION Executing Query");
            List result = this.getEntityManager().createQuery("SELECT c from Customer c ORDER BY c.home ASC NULLS FIRST").getResultList();
            if (((Customer)result.get(0)).getHome() != null & ((Customer)result.get(1)).getHome() != null) {
                this.logErr("Did not get expected results.  Expected first two references, got not null home address");
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_orderByNullsFirst failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_orderByNullsLast() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("UNION Executing Query");
            List result = this.getEntityManager().createQuery("SELECT c from Customer c ORDER BY c.home ASC NULLS LAST").getResultList();
            if (((Customer)result.get(result.size() - 1)).getHome() != null & ((Customer)result.get(result.size() - 2)).getHome() != null) {
                this.logErr("Did not get expected results.  Expected last two references, got not null home address");
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_orderByNullsLast failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_selectID() throws Exception {
        boolean pass = false;
        try {
            this.logTrace("SELECT ID() Executing Query");
            Query query = this.getEntityManager().createQuery("SELECT ID(c) from Customer c WHERE c.id = :idParam");
            query.setParameter("idParam", (Object)this.customerRef[0].getId());
            String result = (String)query.getSingleResult();
            if (this.customerRef[0].getId().equals(result)) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected Customer id |" + this.customerRef[0].getId() + "| but, got |" + result + "|");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_selectID failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_selectWhereID() throws Exception {
        boolean pass = false;
        try {
            this.logTrace("SELECT ID() Executing Query");
            Query query = this.getEntityManager().createQuery("SELECT ID(c) from Customer c WHERE ID(c) = :idParam");
            query.setParameter("idParam", (Object)this.customerRef[0].getId());
            String result = (String)query.getSingleResult();
            if (this.customerRef[0].getId().equals(result)) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.  Expected Customer id |" + this.customerRef[0].getId() + "| but, got |" + result + "|");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_selectWhereID failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_selectVERSION() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean ID = true;
        Member member = new Member(1, "Member 1", true, BigInteger.valueOf(1000L));
        try {
            this.getEntityTransaction().begin();
            Member member1 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (member1 != null) {
                this.getEntityManager().remove((Object)member1);
                this.getEntityTransaction().commit();
            }
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entity:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)member);
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            this.getEntityTransaction().commit();
            this.logTrace("SELECT VERSION() Executing Query");
            Query query1 = this.getEntityManager().createQuery("SELECT VERSION(m) from Member m WHERE m.memberId = :memberIdParam");
            query1.setParameter("memberIdParam", (Object)member.getMemberId());
            Integer version1 = (Integer)query1.getSingleResult();
            if (version1 != null && version1.equals(member.getVersion())) {
                pass1 = true;
            } else {
                this.logErr("Did not get expected results.  Expected Member version |" + member.getVersion() + "| but, got |" + version1 + "|");
            }
            this.logTrace("SELECT VERSION() WHERE version = VERSION() Executing Query");
            Query query2 = this.getEntityManager().createQuery("SELECT VERSION(m) from Member m WHERE m.memberId = :memberIdParam AND m.version = :memberVersionParam");
            query2.setParameter("memberIdParam", (Object)member.getMemberId());
            query2.setParameter("memberVersionParam", (Object)member.getVersion());
            Integer version2 = (Integer)query2.getSingleResult();
            if (version2 != null && version2.equals(member.getVersion())) {
                pass2 = true;
            } else {
                this.logErr("Did not get expected results.  Expected Member version |" + member.getVersion() + "| but, got |" + version2 + "|");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass1 = false;
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("getVersionTest failed");
        }
    }
}

