/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.enums;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.enums.Order;
import jakarta.persistence.AccessType;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.EnumType;
import jakarta.persistence.FetchType;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.GenerationType;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Query;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void accessTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            AccessType at = AccessType.valueOf((String)AccessType.FIELD.name());
            if (!at.equals((Object)AccessType.FIELD)) {
                this.logErr("expected:" + AccessType.FIELD.name() + ", actual:" + at.name());
                pass = false;
            }
            if (!(at = AccessType.valueOf((String)AccessType.PROPERTY.name())).equals((Object)AccessType.PROPERTY)) {
                this.logErr("expected:" + AccessType.PROPERTY.name() + ", actual:" + at.name());
                pass = false;
            }
            try {
                AccessType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                AccessType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("accessTypeValueOfTest failed");
        }
    }

    public void accessTypeValuesTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin accessTypeValuesTest");
        try {
            List<AccessType> at = Arrays.asList(AccessType.values());
            if (at.size() != 2) {
                this.logErr("Number of AccessType expected:2, actual:" + at.size());
                pass = false;
            }
            if (at.contains(AccessType.FIELD)) {
                this.logTrace("received:" + AccessType.FIELD.name());
            } else {
                this.logErr("Expected value:" + AccessType.FIELD.name());
                pass = false;
            }
            if (at.contains(AccessType.PROPERTY)) {
                this.logTrace("received:" + AccessType.PROPERTY.name());
            } else {
                this.logErr("Expected value:" + AccessType.PROPERTY.name());
                pass = false;
            }
            for (AccessType a : at) {
                try {
                    AccessType.valueOf((String)a.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("accessTypeValuesTest failed");
        }
    }

    public void cacheRetrieveModeValueOfTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin cacheRetrieveModeValueOfTest");
        try {
            CacheRetrieveMode crm = CacheRetrieveMode.valueOf((String)CacheRetrieveMode.USE.name());
            if (!crm.equals((Object)CacheRetrieveMode.USE)) {
                this.logErr("expected:" + CacheRetrieveMode.USE.name() + ", actual:" + crm.name());
                pass = false;
            }
            if (!(crm = CacheRetrieveMode.valueOf((String)CacheRetrieveMode.BYPASS.name())).equals((Object)CacheRetrieveMode.BYPASS)) {
                this.logErr("expected:" + CacheRetrieveMode.BYPASS.name() + ", actual:" + crm.name());
                pass = false;
            }
            try {
                CacheRetrieveMode.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                CacheRetrieveMode.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheRetrieveModeValueOfTest failed");
        }
    }

    public void cacheRetrieveModeValuesTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin cacheRetrieveModeValuesTest");
        try {
            List<CacheRetrieveMode> crm = Arrays.asList(CacheRetrieveMode.values());
            if (crm.size() != 2) {
                this.logErr("Number of CacheRetrieveMode expected:2, actual:" + crm.size());
                pass = false;
            }
            if (crm.contains(CacheRetrieveMode.USE)) {
                this.logTrace("received:" + String.valueOf(CacheRetrieveMode.USE));
            } else {
                this.logErr("Expected value:" + String.valueOf(CacheRetrieveMode.USE));
                pass = false;
            }
            if (crm.contains(CacheRetrieveMode.BYPASS)) {
                this.logTrace("received:" + String.valueOf(CacheRetrieveMode.BYPASS));
            } else {
                this.logErr("Expected value:" + String.valueOf(CacheRetrieveMode.BYPASS));
                pass = false;
            }
            for (CacheRetrieveMode c : crm) {
                try {
                    CacheRetrieveMode.valueOf((String)c.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheRetrieveModeValuesTest failed");
        }
    }

    public void cacheStoreModeValueOfTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin cacheStoreModeValueOfTest");
        try {
            CacheStoreMode csm = CacheStoreMode.valueOf((String)CacheStoreMode.USE.name());
            if (!csm.equals((Object)CacheStoreMode.USE)) {
                this.logErr("expected:" + CacheStoreMode.USE.name() + ", actual:" + csm.name());
                pass = false;
            }
            if (!(csm = CacheStoreMode.valueOf((String)CacheStoreMode.BYPASS.name())).equals((Object)CacheStoreMode.BYPASS)) {
                this.logErr("expected:" + CacheStoreMode.BYPASS.name() + ", actual:" + csm.name());
                pass = false;
            }
            if (!(csm = CacheStoreMode.valueOf((String)CacheStoreMode.REFRESH.name())).equals((Object)CacheStoreMode.REFRESH)) {
                this.logErr("expected:" + CacheStoreMode.REFRESH.name() + ", actual:" + csm.name());
                pass = false;
            }
            try {
                CacheStoreMode.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                CacheStoreMode.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheStoreModeValueOfTest failed");
        }
    }

    public void cacheStoreModeValuesTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin cacheStoreModeValuesTest");
        try {
            List<CacheStoreMode> csm = Arrays.asList(CacheStoreMode.values());
            if (csm.size() != 3) {
                this.logErr("Number of CacheStoreMode expected:3, actual:" + csm.size());
                pass = false;
            }
            if (csm.contains(CacheStoreMode.USE)) {
                this.logTrace("received:" + String.valueOf(CacheStoreMode.USE));
            } else {
                this.logErr("Expected value:" + String.valueOf(CacheStoreMode.USE));
                pass = false;
            }
            if (csm.contains(CacheStoreMode.BYPASS)) {
                this.logTrace("received:" + String.valueOf(CacheStoreMode.BYPASS));
            } else {
                this.logErr("Expected value:" + String.valueOf(CacheStoreMode.BYPASS));
                pass = false;
            }
            if (csm.contains(CacheStoreMode.REFRESH)) {
                this.logTrace("received:" + String.valueOf(CacheStoreMode.REFRESH));
            } else {
                this.logErr("Expected value:" + String.valueOf(CacheStoreMode.REFRESH));
                pass = false;
            }
            for (CacheStoreMode c : csm) {
                try {
                    CacheStoreMode.valueOf((String)c.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cacheStoreModeValuesTest failed");
        }
    }

    public void cascadeTypeValueOfTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin cascadeTypeValueOfTest");
        try {
            CascadeType ct = CascadeType.valueOf((String)CascadeType.ALL.name());
            if (!ct.equals((Object)CascadeType.ALL)) {
                this.logErr("expected:" + CascadeType.ALL.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.DETACH.name())).equals((Object)CascadeType.DETACH)) {
                this.logErr("expected:" + CascadeType.DETACH.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.MERGE.name())).equals((Object)CascadeType.MERGE)) {
                this.logErr("expected:" + CascadeType.MERGE.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.PERSIST.name())).equals((Object)CascadeType.PERSIST)) {
                this.logErr("expected:" + CascadeType.PERSIST.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.REFRESH.name())).equals((Object)CascadeType.REFRESH)) {
                this.logErr("expected:" + CascadeType.REFRESH.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = CascadeType.valueOf((String)CascadeType.REMOVE.name())).equals((Object)CascadeType.REMOVE)) {
                this.logErr("expected:" + CascadeType.REMOVE.name() + ", actual:" + ct.name());
                pass = false;
            }
            try {
                CascadeType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                CascadeType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cascadeTypeValueOfTest failed");
        }
    }

    public void cascadeTypeValuesTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin cascadeTypeValuesTest");
        try {
            List<CascadeType> ct = Arrays.asList(CascadeType.values());
            if (ct.size() != 6) {
                this.logErr("Number of CascadeType expected:6, actual:" + ct.size());
                pass = false;
            }
            if (ct.contains(CascadeType.ALL)) {
                this.logTrace("received:" + String.valueOf(CascadeType.ALL));
            } else {
                this.logErr("Expected value:" + String.valueOf(CascadeType.ALL));
                pass = false;
            }
            if (ct.contains(CascadeType.DETACH)) {
                this.logTrace("received:" + String.valueOf(CascadeType.DETACH));
            } else {
                this.logErr("Expected value:" + String.valueOf(CascadeType.DETACH));
                pass = false;
            }
            if (ct.contains(CascadeType.MERGE)) {
                this.logTrace("received:" + String.valueOf(CascadeType.MERGE));
            } else {
                this.logErr("Expected value:" + String.valueOf(CascadeType.MERGE));
                pass = false;
            }
            if (ct.contains(CascadeType.PERSIST)) {
                this.logTrace("received:" + String.valueOf(CascadeType.PERSIST));
            } else {
                this.logErr("Expected value:" + String.valueOf(CascadeType.PERSIST));
                pass = false;
            }
            if (ct.contains(CascadeType.REFRESH)) {
                this.logTrace("received:" + String.valueOf(CascadeType.REFRESH));
            } else {
                this.logErr("Expected value:" + String.valueOf(CascadeType.REFRESH));
                pass = false;
            }
            if (ct.contains(CascadeType.REMOVE)) {
                this.logTrace("received:" + String.valueOf(CascadeType.REMOVE));
            } else {
                this.logErr("Expected value:" + String.valueOf(CascadeType.REMOVE));
                pass = false;
            }
            for (CascadeType c : ct) {
                try {
                    CascadeType.valueOf((String)c.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("cascadeTypeValuesTest failed");
        }
    }

    public void discriminatorTypeValueOfTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin discriminatorTypeValueOfTest");
        try {
            DiscriminatorType dt = DiscriminatorType.valueOf((String)DiscriminatorType.CHAR.name());
            if (!dt.equals((Object)DiscriminatorType.CHAR)) {
                this.logErr("expected:" + DiscriminatorType.CHAR.name() + ", actual:" + dt.name());
                pass = false;
            }
            if (!(dt = DiscriminatorType.valueOf((String)DiscriminatorType.INTEGER.name())).equals((Object)DiscriminatorType.INTEGER)) {
                this.logErr("expected:" + DiscriminatorType.INTEGER.name() + ", actual:" + dt.name());
                pass = false;
            }
            if (!(dt = DiscriminatorType.valueOf((String)DiscriminatorType.STRING.name())).equals((Object)DiscriminatorType.STRING)) {
                this.logErr("expected:" + DiscriminatorType.STRING.name() + ", actual:" + dt.name());
                pass = false;
            }
            try {
                DiscriminatorType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                DiscriminatorType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("discriminatorTypeValueOfTest failed");
        }
    }

    public void discriminatorTypeValuesTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin discriminatorTypeValuesTest");
        try {
            List<DiscriminatorType> dt = Arrays.asList(DiscriminatorType.values());
            if (dt.size() != 3) {
                this.logErr("Number of DiscriminatorType expected:3, actual:" + dt.size());
                pass = false;
            }
            if (dt.contains(DiscriminatorType.CHAR)) {
                this.logTrace("received:" + String.valueOf(DiscriminatorType.CHAR));
            } else {
                this.logErr("Expected value:" + String.valueOf(DiscriminatorType.CHAR));
                pass = false;
            }
            if (dt.contains(DiscriminatorType.INTEGER)) {
                this.logTrace("received:" + String.valueOf(DiscriminatorType.INTEGER));
            } else {
                this.logErr("Expected value:" + String.valueOf(DiscriminatorType.INTEGER));
                pass = false;
            }
            if (dt.contains(DiscriminatorType.STRING)) {
                this.logTrace("received:" + String.valueOf(DiscriminatorType.STRING));
            } else {
                this.logErr("Expected value:" + String.valueOf(DiscriminatorType.STRING));
                pass = false;
            }
            for (DiscriminatorType d : dt) {
                try {
                    DiscriminatorType.valueOf((String)d.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("discriminatorTypeValuesTest failed");
        }
    }

    public void enumTypeValueOfTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin enumTypeValueOfTest");
        try {
            EnumType et = EnumType.valueOf((String)EnumType.ORDINAL.name());
            if (!et.equals((Object)EnumType.ORDINAL)) {
                this.logErr("expected:" + EnumType.ORDINAL.name() + ", actual:" + et.name());
                pass = false;
            }
            if (!(et = EnumType.valueOf((String)EnumType.STRING.name())).equals((Object)EnumType.STRING)) {
                this.logErr("expected:" + EnumType.STRING.name() + ", actual:" + et.name());
                pass = false;
            }
            try {
                EnumType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                EnumType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("enumTypeValueOfTest failed");
        }
    }

    public void enumTypeValuesTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin enumTypeValuesTest");
        try {
            List<EnumType> et = Arrays.asList(EnumType.values());
            if (et.size() != 2) {
                this.logErr("Number of EnumType expected:2, actual:" + et.size());
                pass = false;
            }
            if (et.contains(EnumType.ORDINAL)) {
                this.logTrace("received:" + String.valueOf(EnumType.ORDINAL));
            } else {
                this.logErr("Expected value:" + String.valueOf(EnumType.ORDINAL));
                pass = false;
            }
            if (et.contains(EnumType.STRING)) {
                this.logTrace("received:" + String.valueOf(EnumType.STRING));
            } else {
                this.logErr("Expected value:" + String.valueOf(EnumType.STRING));
                pass = false;
            }
            for (EnumType e : et) {
                try {
                    EnumType.valueOf((String)e.name());
                }
                catch (Exception ex) {
                    this.logErr("Received exception for valueOf", ex);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("enumTypeValuesTest failed");
        }
    }

    public void fetchTypeValueOfTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin fetchTypeValueOfTest");
        try {
            FetchType ft = FetchType.valueOf((String)FetchType.EAGER.name());
            if (!ft.equals((Object)FetchType.EAGER)) {
                this.logErr("expected:" + FetchType.EAGER.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = FetchType.valueOf((String)FetchType.LAZY.name())).equals((Object)FetchType.LAZY)) {
                this.logErr("expected:" + FetchType.LAZY.name() + ", actual:" + ft.name());
                pass = false;
            }
            try {
                FetchType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                FetchType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("fetchTypeValueOfTest failed");
        }
    }

    public void fetchTypeValuesTest() throws Exception {
        boolean pass = true;
        this.logTrace("Begin fetchTypeValuesTest");
        try {
            List<FetchType> ft = Arrays.asList(FetchType.values());
            if (ft.size() != 2) {
                this.logErr("Number of FetchType expected:2, actual:" + ft.size());
                pass = false;
            }
            if (ft.contains(FetchType.EAGER)) {
                this.logTrace("received:" + String.valueOf(FetchType.EAGER));
            } else {
                this.logErr("Expected value:" + String.valueOf(FetchType.EAGER));
                pass = false;
            }
            if (ft.contains(FetchType.LAZY)) {
                this.logTrace("received:" + String.valueOf(FetchType.LAZY));
            } else {
                this.logErr("Expected value:" + String.valueOf(FetchType.LAZY));
                pass = false;
            }
            for (FetchType f : ft) {
                try {
                    FetchType.valueOf((String)f.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("fetchTypeValuesTest failed");
        }
    }

    public void flushModeTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            FlushModeType fmt = FlushModeType.valueOf((String)FlushModeType.AUTO.name());
            if (!fmt.equals((Object)FlushModeType.AUTO)) {
                this.logErr("expected:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                pass = false;
            }
            if (!(fmt = FlushModeType.valueOf((String)FlushModeType.COMMIT.name())).equals((Object)FlushModeType.COMMIT)) {
                this.logErr("expected:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                pass = false;
            }
            try {
                FlushModeType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                FlushModeType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("flushModeTypeValueOfTest failed");
        }
    }

    public void flushModeTypeValuesTest() throws Exception {
        boolean pass = true;
        boolean count = false;
        try {
            List<FlushModeType> fmt = Arrays.asList(FlushModeType.values());
            if (fmt.size() != 2) {
                this.logErr("Number of FlushModeType expected:2, actual:" + fmt.size());
                pass = false;
            }
            if (fmt.contains(FlushModeType.COMMIT)) {
                this.logTrace("received:" + String.valueOf(FlushModeType.COMMIT));
            } else {
                this.logErr("Expected value:" + String.valueOf(FlushModeType.COMMIT));
                pass = false;
            }
            if (fmt.contains(FlushModeType.AUTO)) {
                this.logTrace("received:" + String.valueOf(FlushModeType.AUTO));
            } else {
                this.logErr("Expected value:" + String.valueOf(FlushModeType.AUTO));
                pass = false;
            }
            for (FlushModeType f : fmt) {
                try {
                    FlushModeType.valueOf((String)f.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("flushModeTypeValuesTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setgetFlushModeEntityManagerTest() throws Exception {
        boolean pass = true;
        try {
            EntityTransaction t = this.getEntityTransaction();
            t.begin();
            EntityManager em = this.getEntityManager();
            this.logTrace("Checking Default mode");
            FlushModeType fmt = em.getFlushMode();
            if (fmt.equals((Object)FlushModeType.AUTO)) {
                this.logTrace("Checking COMMIT");
                em.setFlushMode(FlushModeType.COMMIT);
                fmt = em.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    this.logTrace("Checking AUTO");
                    em.setFlushMode(FlushModeType.AUTO);
                    fmt = em.getFlushMode();
                    if (!fmt.equals((Object)FlushModeType.AUTO)) {
                        this.logErr("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        pass = false;
                    }
                } else {
                    this.logErr("Expected a value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    pass = false;
                }
            } else {
                this.logErr("Expected a default value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("setgetFlushModeEntityManagerTest failed");
        }
    }

    public void setgetFlushModeTest() throws Exception {
        boolean pass = true;
        try {
            EntityManager em = this.getEntityManager();
            Query q = em.createQuery("SELECT o FROM Order o WHERE o.id = 1");
            this.logTrace("Getting mode from query");
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)em.getFlushMode())) {
                this.logTrace("Setting mode to return default mode");
                q.setFlushMode(fmt);
                this.logTrace("Setting mode to FlushModeType.COMMIT");
                q.setFlushMode(FlushModeType.COMMIT);
                fmt = q.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    this.logTrace("Setting mode to FlushModeType.AUTO");
                    q.setFlushMode(FlushModeType.AUTO);
                    fmt = q.getFlushMode();
                    if (fmt.equals((Object)FlushModeType.AUTO)) {
                        this.logTrace("Received expected FlushModeType:" + fmt.name());
                    } else {
                        this.logErr("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        pass = false;
                    }
                } else {
                    this.logErr("Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    pass = false;
                }
            } else {
                this.logErr("Expected EntityManager value of:" + String.valueOf(em.getFlushMode()) + ", actual:" + fmt.name());
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("setgetFlushModeTest failed");
        }
    }

    public void setgetFlushModeTQTest() throws Exception {
        boolean pass = true;
        try {
            EntityManager em = this.getEntityManager();
            TypedQuery q = em.createQuery("SELECT o FROM Order o WHERE o.id = 1", Order.class);
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)em.getFlushMode())) {
                this.logTrace("Setting mode to returned default mode");
                q.setFlushMode(fmt);
                this.logTrace("Setting mode to FlushModeType.COMMIT");
                q.setFlushMode(FlushModeType.COMMIT);
                fmt = q.getFlushMode();
                if (fmt.equals((Object)FlushModeType.COMMIT)) {
                    this.logTrace("Setting mode to FlushModeType.AUTO");
                    q.setFlushMode(FlushModeType.AUTO);
                    fmt = q.getFlushMode();
                    if (!fmt.equals((Object)FlushModeType.AUTO)) {
                        this.logErr("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        pass = false;
                    }
                } else {
                    this.logErr("Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    pass = false;
                }
            } else {
                this.logErr("Expected EntityManager value of:" + em.getFlushMode().name() + ", actual:" + fmt.name());
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("setgetFlushModeTQTest failed");
        }
    }

    public void generationTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            GenerationType ft = GenerationType.valueOf((String)GenerationType.AUTO.name());
            if (!ft.equals((Object)GenerationType.AUTO)) {
                this.logErr("expected:" + GenerationType.AUTO.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.IDENTITY.name())).equals((Object)GenerationType.IDENTITY)) {
                this.logErr("expected:" + GenerationType.IDENTITY.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.SEQUENCE.name())).equals((Object)GenerationType.SEQUENCE)) {
                this.logErr("expected:" + GenerationType.SEQUENCE.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.TABLE.name())).equals((Object)GenerationType.TABLE)) {
                this.logErr("expected:" + GenerationType.TABLE.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = GenerationType.valueOf((String)GenerationType.UUID.name())).equals((Object)GenerationType.UUID)) {
                this.logErr("expected:" + GenerationType.UUID.name() + ", actual:" + ft.name());
                pass = false;
            }
            try {
                GenerationType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                GenerationType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("generationTypeValueOfTest failed");
        }
    }

    public void generationTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<GenerationType> gt = Arrays.asList(GenerationType.values());
            if (gt.size() != 5) {
                this.logErr("Number of GenerationType expected:5, actual:" + gt.size());
                pass = false;
            }
            if (gt.contains(GenerationType.AUTO)) {
                this.logTrace("received:" + String.valueOf(GenerationType.AUTO));
            } else {
                this.logErr("Expected value:" + String.valueOf(GenerationType.AUTO));
                pass = false;
            }
            if (gt.contains(GenerationType.IDENTITY)) {
                this.logTrace("received:" + String.valueOf(GenerationType.IDENTITY));
            } else {
                this.logErr("Expected value:" + String.valueOf(GenerationType.IDENTITY));
                pass = false;
            }
            if (gt.contains(GenerationType.SEQUENCE)) {
                this.logTrace("received:" + String.valueOf(GenerationType.SEQUENCE));
            } else {
                this.logErr("Expected value:" + String.valueOf(GenerationType.SEQUENCE));
                pass = false;
            }
            if (gt.contains(GenerationType.TABLE)) {
                this.logTrace("received:" + String.valueOf(GenerationType.TABLE));
            } else {
                this.logErr("Expected value:" + String.valueOf(GenerationType.TABLE));
                pass = false;
            }
            if (gt.contains(GenerationType.UUID)) {
                this.logTrace("received:" + String.valueOf(GenerationType.UUID));
            } else {
                this.logErr("Expected value:" + String.valueOf(GenerationType.UUID));
                pass = false;
            }
            for (GenerationType g : gt) {
                try {
                    GenerationType.valueOf((String)g.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("generationTypeValuesTest failed");
        }
    }

    public void inheritanceTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            InheritanceType ft = InheritanceType.valueOf((String)InheritanceType.JOINED.name());
            if (!ft.equals((Object)InheritanceType.JOINED)) {
                this.logErr("expected:" + InheritanceType.JOINED.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = InheritanceType.valueOf((String)InheritanceType.SINGLE_TABLE.name())).equals((Object)InheritanceType.SINGLE_TABLE)) {
                this.logErr("expected:" + InheritanceType.SINGLE_TABLE.name() + ", actual:" + ft.name());
                pass = false;
            }
            if (!(ft = InheritanceType.valueOf((String)InheritanceType.TABLE_PER_CLASS.name())).equals((Object)InheritanceType.TABLE_PER_CLASS)) {
                this.logErr("expected:" + InheritanceType.TABLE_PER_CLASS.name() + ", actual:" + ft.name());
                pass = false;
            }
            try {
                InheritanceType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                InheritanceType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("inheritanceTypeValueOfTest failed");
        }
    }

    public void inheritanceTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<InheritanceType> it = Arrays.asList(InheritanceType.values());
            if (it.size() != 3) {
                this.logErr("Number of InheritanceType expected:3, actual:" + it.size());
                pass = false;
            }
            if (it.contains(InheritanceType.JOINED)) {
                this.logTrace("received:" + String.valueOf(InheritanceType.JOINED));
            } else {
                this.logErr("Expected value:" + String.valueOf(InheritanceType.JOINED));
                pass = false;
            }
            if (it.contains(InheritanceType.SINGLE_TABLE)) {
                this.logTrace("received:" + String.valueOf(InheritanceType.SINGLE_TABLE));
            } else {
                this.logErr("Expected value:" + String.valueOf(InheritanceType.SINGLE_TABLE));
                pass = false;
            }
            if (it.contains(InheritanceType.TABLE_PER_CLASS)) {
                this.logTrace("received:" + String.valueOf(InheritanceType.TABLE_PER_CLASS));
            } else {
                this.logErr("Expected value:" + String.valueOf(InheritanceType.TABLE_PER_CLASS));
                pass = false;
            }
            for (InheritanceType i : it) {
                try {
                    InheritanceType.valueOf((String)i.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("inheritanceTypeValuesTest failed");
        }
    }

    public void lockModeTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            LockModeType lm = LockModeType.valueOf((String)LockModeType.NONE.name());
            if (!lm.equals((Object)LockModeType.NONE)) {
                this.logErr("expected:" + String.valueOf(LockModeType.NONE) + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.OPTIMISTIC.name())).equals((Object)LockModeType.OPTIMISTIC)) {
                this.logErr("expected:" + LockModeType.OPTIMISTIC.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.OPTIMISTIC_FORCE_INCREMENT.name())).equals((Object)LockModeType.OPTIMISTIC_FORCE_INCREMENT)) {
                this.logErr("expected:" + LockModeType.OPTIMISTIC_FORCE_INCREMENT.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.PESSIMISTIC_READ.name())).equals((Object)LockModeType.PESSIMISTIC_READ)) {
                this.logErr("expected:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.PESSIMISTIC_WRITE.name())).equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                this.logErr("expected:" + LockModeType.PESSIMISTIC_WRITE.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.READ.name())).equals((Object)LockModeType.READ)) {
                this.logErr("expected:" + LockModeType.READ.name() + ", actual:" + lm.name());
                pass = false;
            }
            if (!(lm = LockModeType.valueOf((String)LockModeType.WRITE.name())).equals((Object)LockModeType.WRITE)) {
                this.logErr("expected:" + LockModeType.WRITE.name() + ", actual:" + lm.name());
                pass = false;
            }
            try {
                LockModeType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                LockModeType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("lockModeTypeValueOfTest failed");
        }
    }

    public void lockModeTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<LockModeType> lm = Arrays.asList(LockModeType.values());
            if (lm.size() != 8) {
                this.logErr("Number of LockModeTypes expected:8, actual:" + lm.size());
                pass = false;
            }
            if (lm.contains(LockModeType.NONE)) {
                this.logTrace("received:" + String.valueOf(LockModeType.NONE));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.NONE));
                pass = false;
            }
            if (lm.contains(LockModeType.OPTIMISTIC)) {
                this.logTrace("received:" + String.valueOf(LockModeType.OPTIMISTIC));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.OPTIMISTIC));
                pass = false;
            }
            if (lm.contains(LockModeType.OPTIMISTIC_FORCE_INCREMENT)) {
                this.logTrace("received:" + String.valueOf(LockModeType.OPTIMISTIC_FORCE_INCREMENT));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.OPTIMISTIC_FORCE_INCREMENT));
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_FORCE_INCREMENT)) {
                this.logTrace("received:" + String.valueOf(LockModeType.PESSIMISTIC_FORCE_INCREMENT));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.PESSIMISTIC_FORCE_INCREMENT));
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_READ)) {
                this.logTrace("received:" + String.valueOf(LockModeType.PESSIMISTIC_READ));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.PESSIMISTIC_READ));
                pass = false;
            }
            if (lm.contains(LockModeType.PESSIMISTIC_WRITE)) {
                this.logTrace("received:" + String.valueOf(LockModeType.PESSIMISTIC_WRITE));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.PESSIMISTIC_WRITE));
                pass = false;
            }
            if (lm.contains(LockModeType.READ)) {
                this.logTrace("received:" + String.valueOf(LockModeType.READ));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.READ));
                pass = false;
            }
            if (lm.contains(LockModeType.WRITE)) {
                this.logTrace("received:" + String.valueOf(LockModeType.WRITE));
            } else {
                this.logErr("Expected value:" + String.valueOf(LockModeType.WRITE));
                pass = false;
            }
            for (LockModeType l : lm) {
                try {
                    LockModeType.valueOf((String)l.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("lockModeTypeValuesTest failed");
        }
    }

    public void persistenceContextTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PersistenceContextType pct = PersistenceContextType.valueOf((String)PersistenceContextType.EXTENDED.name());
            if (!pct.equals((Object)PersistenceContextType.EXTENDED)) {
                this.logErr("expected:" + PersistenceContextType.EXTENDED.name() + ", actual:" + pct.name());
                pass = false;
            }
            if (!(pct = PersistenceContextType.valueOf((String)PersistenceContextType.TRANSACTION.name())).equals((Object)PersistenceContextType.TRANSACTION)) {
                this.logErr("expected:" + PersistenceContextType.TRANSACTION.name() + ", actual:" + pct.name());
                pass = false;
            }
            try {
                PersistenceContextType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                PersistenceContextType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("persistenceContextTypeValueOfTest failed");
        }
    }

    public void persistenceContextTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<PersistenceContextType> pct = Arrays.asList(PersistenceContextType.values());
            if (pct.size() != 2) {
                this.logErr("Number of PersistenceContextType expected:2, actual:" + pct.size());
                pass = false;
            }
            if (pct.contains(PersistenceContextType.EXTENDED)) {
                this.logTrace("received:" + String.valueOf(PersistenceContextType.EXTENDED));
            } else {
                this.logErr("Expected value:" + String.valueOf(PersistenceContextType.EXTENDED));
                pass = false;
            }
            if (pct.contains(PersistenceContextType.TRANSACTION)) {
                this.logTrace("received:" + String.valueOf(PersistenceContextType.TRANSACTION));
            } else {
                this.logErr("Expected value:" + String.valueOf(PersistenceContextType.TRANSACTION));
                pass = false;
            }
            for (PersistenceContextType p : pct) {
                try {
                    PersistenceContextType.valueOf((String)p.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("persistenceContextTypeValuesTest failed");
        }
    }

    public void pessimisticLockScopeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PessimisticLockScope pls = PessimisticLockScope.valueOf((String)PessimisticLockScope.EXTENDED.name());
            if (!pls.equals((Object)PessimisticLockScope.EXTENDED)) {
                this.logErr("expected:" + PessimisticLockScope.EXTENDED.name() + ", actual:" + pls.name());
                pass = false;
            }
            if (!(pls = PessimisticLockScope.valueOf((String)PessimisticLockScope.NORMAL.name())).equals((Object)PessimisticLockScope.NORMAL)) {
                this.logErr("expected:" + PessimisticLockScope.NORMAL.name() + ", actual:" + pls.name());
                pass = false;
            }
            try {
                PessimisticLockScope.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                PessimisticLockScope.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("pessimisticLockScopeValueOfTest failed");
        }
    }

    public void pessimisticLockScopeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<PessimisticLockScope> pls = Arrays.asList(PessimisticLockScope.values());
            if (pls.size() != 2) {
                this.logErr("Number of PessimisticLockScope expected:2, actual:" + pls.size());
                pass = false;
            }
            if (pls.contains(PessimisticLockScope.EXTENDED)) {
                this.logTrace("received:" + String.valueOf(PessimisticLockScope.EXTENDED));
            } else {
                this.logErr("Expected value:" + String.valueOf(PessimisticLockScope.EXTENDED));
                pass = false;
            }
            if (pls.contains(PessimisticLockScope.NORMAL)) {
                this.logTrace("received:" + String.valueOf(PessimisticLockScope.NORMAL));
            } else {
                this.logErr("Expected value:" + String.valueOf(PessimisticLockScope.NORMAL));
                pass = false;
            }
            for (PessimisticLockScope p : pls) {
                try {
                    PessimisticLockScope.valueOf((String)p.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("pessimisticLockScopeValuesTest failed");
        }
    }

    public void sharedCacheModeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            SharedCacheMode scm = SharedCacheMode.valueOf((String)SharedCacheMode.ALL.name());
            if (!scm.equals((Object)SharedCacheMode.ALL)) {
                this.logErr("expected:" + SharedCacheMode.ALL.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.DISABLE_SELECTIVE.name())).equals((Object)SharedCacheMode.DISABLE_SELECTIVE)) {
                this.logErr("expected:" + SharedCacheMode.DISABLE_SELECTIVE.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.ENABLE_SELECTIVE.name())).equals((Object)SharedCacheMode.ENABLE_SELECTIVE)) {
                this.logErr("expected:" + SharedCacheMode.ENABLE_SELECTIVE.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.NONE.name())).equals((Object)SharedCacheMode.NONE)) {
                this.logErr("expected:" + SharedCacheMode.NONE.name() + ", actual:" + scm.name());
                pass = false;
            }
            if (!(scm = SharedCacheMode.valueOf((String)SharedCacheMode.UNSPECIFIED.name())).equals((Object)SharedCacheMode.UNSPECIFIED)) {
                this.logErr("expected:" + SharedCacheMode.UNSPECIFIED.name() + ", actual:" + scm.name());
                pass = false;
            }
            try {
                SharedCacheMode.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                SharedCacheMode.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("sharedCacheModeValueOfTest failed");
        }
    }

    public void sharedCacheModeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<SharedCacheMode> scm = Arrays.asList(SharedCacheMode.values());
            if (scm.size() != 5) {
                this.logErr("Number of SharedCacheMode expected:5, actual:" + scm.size());
                pass = false;
            }
            if (scm.contains(SharedCacheMode.ALL)) {
                this.logTrace("received:" + String.valueOf(SharedCacheMode.ALL));
            } else {
                this.logErr("Expected value:" + String.valueOf(SharedCacheMode.ALL));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.DISABLE_SELECTIVE)) {
                this.logTrace("received:" + String.valueOf(SharedCacheMode.DISABLE_SELECTIVE));
            } else {
                this.logErr("Expected value:" + String.valueOf(SharedCacheMode.DISABLE_SELECTIVE));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.ENABLE_SELECTIVE)) {
                this.logTrace("received:" + String.valueOf(SharedCacheMode.ENABLE_SELECTIVE));
            } else {
                this.logErr("Expected value:" + String.valueOf(SharedCacheMode.ENABLE_SELECTIVE));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.NONE)) {
                this.logTrace("received:" + String.valueOf(SharedCacheMode.NONE));
            } else {
                this.logErr("Expected value:" + String.valueOf(SharedCacheMode.NONE));
                pass = false;
            }
            if (scm.contains(SharedCacheMode.UNSPECIFIED)) {
                this.logTrace("received:" + String.valueOf(SharedCacheMode.UNSPECIFIED));
            } else {
                this.logErr("Expected value:" + String.valueOf(SharedCacheMode.UNSPECIFIED));
                pass = false;
            }
            for (SharedCacheMode s : scm) {
                try {
                    SharedCacheMode.valueOf((String)s.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("sharedCacheModeValuesTest failed");
        }
    }

    public void validationModeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            ValidationMode vm = ValidationMode.valueOf((String)ValidationMode.CALLBACK.name());
            if (!vm.equals((Object)ValidationMode.CALLBACK)) {
                this.logErr("expected:" + ValidationMode.CALLBACK.name() + ", actual:" + vm.name());
                pass = false;
            }
            if (!(vm = ValidationMode.valueOf((String)ValidationMode.AUTO.name())).equals((Object)ValidationMode.AUTO)) {
                this.logErr("expected:" + ValidationMode.AUTO.name() + ", actual:" + vm.name());
                pass = false;
            }
            if (!(vm = ValidationMode.valueOf((String)ValidationMode.NONE.name())).equals((Object)ValidationMode.NONE)) {
                this.logErr("expected:" + ValidationMode.NONE.name() + ", actual:" + vm.name());
                pass = false;
            }
            try {
                ValidationMode.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                ValidationMode.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("validationModeValueOfTest failed");
        }
    }

    public void validationModeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<ValidationMode> vm = Arrays.asList(ValidationMode.values());
            if (vm.size() != 3) {
                this.logErr("Number of ValidationMode expected:3, actual:" + vm.size());
                pass = false;
            }
            if (vm.contains(ValidationMode.CALLBACK)) {
                this.logTrace("received:" + String.valueOf(ValidationMode.CALLBACK));
            } else {
                this.logErr("Expected value:" + String.valueOf(ValidationMode.CALLBACK));
                pass = false;
            }
            if (vm.contains(ValidationMode.AUTO)) {
                this.logTrace("received:" + String.valueOf(ValidationMode.AUTO));
            } else {
                this.logErr("Expected value:" + String.valueOf(ValidationMode.AUTO));
                pass = false;
            }
            if (vm.contains(ValidationMode.NONE)) {
                this.logTrace("received:" + String.valueOf(ValidationMode.NONE));
            } else {
                this.logErr("Expected value:" + String.valueOf(ValidationMode.NONE));
                pass = false;
            }
            for (ValidationMode v : vm) {
                try {
                    ValidationMode.valueOf((String)v.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("validationModeValuesTest failed");
        }
    }

    public void temporalTypeValuesTest() throws Exception {
        boolean pass = true;
        List<TemporalType> tt = Arrays.asList(TemporalType.values());
        if (tt.size() != 3) {
            this.logErr("Number of TemporalType expected:3, actual:" + tt.size());
            pass = false;
        }
        if (tt.contains(TemporalType.DATE)) {
            this.logTrace("received:" + String.valueOf(TemporalType.DATE));
        } else {
            this.logErr("Expected value:" + String.valueOf(TemporalType.DATE));
            pass = false;
        }
        if (tt.contains(TemporalType.TIME)) {
            this.logTrace("received:" + String.valueOf(TemporalType.TIME));
        } else {
            this.logErr("Expected value:" + String.valueOf(TemporalType.TIME));
            pass = false;
        }
        if (tt.contains(TemporalType.TIMESTAMP)) {
            this.logTrace("received:" + String.valueOf(TemporalType.TIMESTAMP));
        } else {
            this.logErr("Expected value:" + String.valueOf(TemporalType.TIMESTAMP));
            pass = false;
        }
        for (TemporalType t : tt) {
            try {
                TemporalType.valueOf((String)t.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("temporalTypeValuesTest failed");
        }
    }

    public void temporalTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            TemporalType tt = TemporalType.valueOf((String)TemporalType.DATE.name());
            if (!tt.equals((Object)TemporalType.DATE)) {
                this.logErr("expected:" + TemporalType.DATE.name() + ", actual:" + tt.name());
                pass = false;
            }
            if (!(tt = TemporalType.valueOf((String)TemporalType.TIME.name())).equals((Object)TemporalType.TIME)) {
                this.logErr("expected:" + TemporalType.TIME.name() + ", actual:" + tt.name());
                pass = false;
            }
            if (!(tt = TemporalType.valueOf((String)TemporalType.TIMESTAMP.name())).equals((Object)TemporalType.TIMESTAMP)) {
                this.logErr("expected:" + TemporalType.TIMESTAMP.name() + ", actual:" + tt.name());
                pass = false;
            }
            try {
                TemporalType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                TemporalType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("temporalTypeValueOfTest failed");
        }
    }

    public void joinTypeValuesTest() throws Exception {
        boolean pass = true;
        List<JoinType> jt = Arrays.asList(JoinType.values());
        if (jt.size() != 3) {
            this.logErr("Number of TemporalType expected:3, actual:" + jt.size());
            pass = false;
        }
        if (jt.contains(JoinType.LEFT)) {
            this.logTrace("received:" + String.valueOf(JoinType.LEFT));
        } else {
            this.logErr("Expected value:" + String.valueOf(JoinType.LEFT));
            pass = false;
        }
        if (jt.contains(JoinType.INNER)) {
            this.logTrace("received:" + String.valueOf(JoinType.INNER));
        } else {
            this.logErr("Expected value:" + String.valueOf(JoinType.INNER));
            pass = false;
        }
        if (jt.contains(JoinType.RIGHT)) {
            this.logTrace("received:" + String.valueOf(JoinType.RIGHT));
        } else {
            this.logErr("Expected value:" + String.valueOf(JoinType.RIGHT));
            pass = false;
        }
        for (JoinType j : jt) {
            try {
                JoinType.valueOf((String)j.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("joinTypeValuesTest failed");
        }
    }

    public void joinTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            JoinType jt = JoinType.valueOf((String)JoinType.LEFT.name());
            if (!jt.equals((Object)JoinType.LEFT)) {
                this.logErr("expected:" + JoinType.LEFT.name() + ", actual:" + jt.name());
                pass = false;
            }
            if (!(jt = JoinType.valueOf((String)JoinType.INNER.name())).equals((Object)JoinType.INNER)) {
                this.logErr("expected:" + JoinType.INNER.name() + ", actual:" + jt.name());
                pass = false;
            }
            if (!(jt = JoinType.valueOf((String)JoinType.RIGHT.name())).equals((Object)JoinType.RIGHT)) {
                this.logErr("expected:" + JoinType.RIGHT.name() + ", actual:" + jt.name());
                pass = false;
            }
            try {
                JoinType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                JoinType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("joinTypeValueOfTest failed");
        }
    }

    public void persistentAttributeTypeValuesTest() throws Exception {
        boolean pass = true;
        List<Attribute.PersistentAttributeType> pat = Arrays.asList(Attribute.PersistentAttributeType.values());
        if (pat.size() != 7) {
            this.logErr("Number of TemporalType expected:7, actual:" + pat.size());
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.BASIC)) {
            this.logTrace("received:" + String.valueOf(Attribute.PersistentAttributeType.BASIC));
        } else {
            this.logErr("Expected value:" + String.valueOf(Attribute.PersistentAttributeType.BASIC));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ELEMENT_COLLECTION)) {
            this.logTrace("received:" + String.valueOf(Attribute.PersistentAttributeType.ELEMENT_COLLECTION));
        } else {
            this.logErr("Expected value:" + String.valueOf(Attribute.PersistentAttributeType.ELEMENT_COLLECTION));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.EMBEDDED)) {
            this.logTrace("received:" + String.valueOf(Attribute.PersistentAttributeType.EMBEDDED));
        } else {
            this.logErr("Expected value:" + String.valueOf(Attribute.PersistentAttributeType.EMBEDDED));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.MANY_TO_MANY)) {
            this.logTrace("received:" + String.valueOf(Attribute.PersistentAttributeType.MANY_TO_MANY));
        } else {
            this.logErr("Expected value:" + String.valueOf(Attribute.PersistentAttributeType.MANY_TO_MANY));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.MANY_TO_ONE)) {
            this.logTrace("received:" + String.valueOf(Attribute.PersistentAttributeType.MANY_TO_ONE));
        } else {
            this.logErr("Expected value:" + String.valueOf(Attribute.PersistentAttributeType.MANY_TO_ONE));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ONE_TO_MANY)) {
            this.logTrace("received:" + String.valueOf(Attribute.PersistentAttributeType.ONE_TO_MANY));
        } else {
            this.logErr("Expected value:" + String.valueOf(Attribute.PersistentAttributeType.ONE_TO_MANY));
            pass = false;
        }
        if (pat.contains(Attribute.PersistentAttributeType.ONE_TO_ONE)) {
            this.logTrace("received:" + String.valueOf(Attribute.PersistentAttributeType.ONE_TO_ONE));
        } else {
            this.logErr("Expected value:" + String.valueOf(Attribute.PersistentAttributeType.ONE_TO_ONE));
            pass = false;
        }
        for (Attribute.PersistentAttributeType p : pat) {
            try {
                Attribute.PersistentAttributeType.valueOf((String)p.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("persistentAttributeTypeValuesTest failed");
        }
    }

    public void persistentAttributeTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            Attribute.PersistentAttributeType pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.BASIC.name());
            if (!pat.equals((Object)Attribute.PersistentAttributeType.BASIC)) {
                this.logErr("expected:" + Attribute.PersistentAttributeType.BASIC.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ELEMENT_COLLECTION.name())).equals((Object)Attribute.PersistentAttributeType.ELEMENT_COLLECTION)) {
                this.logErr("expected:" + Attribute.PersistentAttributeType.ELEMENT_COLLECTION.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.EMBEDDED.name())).equals((Object)Attribute.PersistentAttributeType.EMBEDDED)) {
                this.logErr("expected:" + Attribute.PersistentAttributeType.EMBEDDED.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.MANY_TO_MANY.name())).equals((Object)Attribute.PersistentAttributeType.MANY_TO_MANY)) {
                this.logErr("expected:" + Attribute.PersistentAttributeType.MANY_TO_MANY.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.MANY_TO_ONE.name())).equals((Object)Attribute.PersistentAttributeType.MANY_TO_ONE)) {
                this.logErr("expected:" + Attribute.PersistentAttributeType.MANY_TO_ONE.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ONE_TO_MANY.name())).equals((Object)Attribute.PersistentAttributeType.ONE_TO_MANY)) {
                this.logErr("expected:" + Attribute.PersistentAttributeType.ONE_TO_MANY.name() + ", actual:" + pat.name());
                pass = false;
            }
            if (!(pat = Attribute.PersistentAttributeType.valueOf((String)Attribute.PersistentAttributeType.ONE_TO_ONE.name())).equals((Object)Attribute.PersistentAttributeType.ONE_TO_ONE)) {
                this.logErr("expected:" + Attribute.PersistentAttributeType.ONE_TO_ONE.name() + ", actual:" + pat.name());
                pass = false;
            }
            try {
                Attribute.PersistentAttributeType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                Attribute.PersistentAttributeType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("persistentAttributeTypeValueOfTest failed");
        }
    }

    public void bindableTypeValuesTest() throws Exception {
        boolean pass = true;
        List<Bindable.BindableType> bt = Arrays.asList(Bindable.BindableType.values());
        if (bt.size() != 3) {
            this.logErr("Number of TemporalType expected:3, actual:" + bt.size());
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.ENTITY_TYPE)) {
            this.logTrace("received:" + Bindable.BindableType.ENTITY_TYPE.name());
        } else {
            this.logErr("Expected value:" + Bindable.BindableType.ENTITY_TYPE.name());
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.PLURAL_ATTRIBUTE)) {
            this.logTrace("received:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name());
        } else {
            this.logErr("Expected value:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name());
            pass = false;
        }
        if (bt.contains(Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
            this.logTrace("received:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name());
        } else {
            this.logErr("Expected value:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name());
            pass = false;
        }
        for (Bindable.BindableType b : bt) {
            try {
                Bindable.BindableType.valueOf((String)b.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("bindableTypeValuesTest failed");
        }
    }

    public void bindableTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            Bindable.BindableType bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.ENTITY_TYPE.name());
            if (!bt.equals((Object)Bindable.BindableType.ENTITY_TYPE)) {
                this.logErr("expected:" + Bindable.BindableType.ENTITY_TYPE.name() + ", actual:" + bt.name());
                pass = false;
            }
            if (!(bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.PLURAL_ATTRIBUTE.name())).equals((Object)Bindable.BindableType.PLURAL_ATTRIBUTE)) {
                this.logErr("expected:" + Bindable.BindableType.PLURAL_ATTRIBUTE.name() + ", actual:" + bt.name());
                pass = false;
            }
            if (!(bt = Bindable.BindableType.valueOf((String)Bindable.BindableType.SINGULAR_ATTRIBUTE.name())).equals((Object)Bindable.BindableType.SINGULAR_ATTRIBUTE)) {
                this.logErr("expected:" + Bindable.BindableType.SINGULAR_ATTRIBUTE.name() + ", actual:" + bt.name());
                pass = false;
            }
            try {
                Bindable.BindableType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                Bindable.BindableType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("bindableTypeValueOfTest failed");
        }
    }

    public void collectionTypeValuesTest() throws Exception {
        boolean pass = true;
        List<PluralAttribute.CollectionType> ct = Arrays.asList(PluralAttribute.CollectionType.values());
        if (ct.size() != 4) {
            this.logErr("Number of TemporalType expected:4, actual:" + ct.size());
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.COLLECTION)) {
            this.logTrace("received:" + String.valueOf(PluralAttribute.CollectionType.COLLECTION));
        } else {
            this.logErr("Expected value:" + String.valueOf(PluralAttribute.CollectionType.COLLECTION));
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.LIST)) {
            this.logTrace("received:" + String.valueOf(PluralAttribute.CollectionType.LIST));
        } else {
            this.logErr("Expected value:" + String.valueOf(PluralAttribute.CollectionType.LIST));
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.MAP)) {
            this.logTrace("received:" + String.valueOf(PluralAttribute.CollectionType.MAP));
        } else {
            this.logErr("Expected value:" + String.valueOf(PluralAttribute.CollectionType.MAP));
            pass = false;
        }
        if (ct.contains(PluralAttribute.CollectionType.SET)) {
            this.logTrace("received:" + String.valueOf(PluralAttribute.CollectionType.SET));
        } else {
            this.logErr("Expected value:" + String.valueOf(PluralAttribute.CollectionType.SET));
            pass = false;
        }
        for (PluralAttribute.CollectionType c : ct) {
            try {
                PluralAttribute.CollectionType.valueOf((String)c.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("collectionTypeValuesTest failed");
        }
    }

    public void collectionTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PluralAttribute.CollectionType ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.COLLECTION.name());
            if (!ct.equals((Object)PluralAttribute.CollectionType.COLLECTION)) {
                this.logErr("expected:" + PluralAttribute.CollectionType.COLLECTION.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.LIST.name())).equals((Object)PluralAttribute.CollectionType.LIST)) {
                this.logErr("expected:" + PluralAttribute.CollectionType.LIST.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.MAP.name())).equals((Object)PluralAttribute.CollectionType.MAP)) {
                this.logErr("expected:" + PluralAttribute.CollectionType.MAP.name() + ", actual:" + ct.name());
                pass = false;
            }
            if (!(ct = PluralAttribute.CollectionType.valueOf((String)PluralAttribute.CollectionType.SET.name())).equals((Object)PluralAttribute.CollectionType.SET)) {
                this.logErr("expected:" + PluralAttribute.CollectionType.SET.name() + ", actual:" + ct.name());
                pass = false;
            }
            try {
                PluralAttribute.CollectionType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                PluralAttribute.CollectionType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("collectionTypeValueOfTest failed");
        }
    }

    public void persistenceTypeValuesTest() throws Exception {
        boolean pass = true;
        List<Type.PersistenceType> pt = Arrays.asList(Type.PersistenceType.values());
        if (pt.size() != 4) {
            this.logErr("Number of TemporalType expected:4, actual:" + pt.size());
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.BASIC)) {
            this.logTrace("received:" + String.valueOf(Type.PersistenceType.BASIC));
        } else {
            this.logErr("Expected value:" + String.valueOf(Type.PersistenceType.BASIC));
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.EMBEDDABLE)) {
            this.logTrace("received:" + String.valueOf(Type.PersistenceType.EMBEDDABLE));
        } else {
            this.logErr("Expected value:" + String.valueOf(Type.PersistenceType.EMBEDDABLE));
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.ENTITY)) {
            this.logTrace("received:" + String.valueOf(Type.PersistenceType.ENTITY));
        } else {
            this.logErr("Expected value:" + String.valueOf(Type.PersistenceType.ENTITY));
            pass = false;
        }
        if (pt.contains(Type.PersistenceType.MAPPED_SUPERCLASS)) {
            this.logTrace("received:" + String.valueOf(Type.PersistenceType.MAPPED_SUPERCLASS));
        } else {
            this.logErr("Expected value:" + String.valueOf(Type.PersistenceType.MAPPED_SUPERCLASS));
            pass = false;
        }
        for (Type.PersistenceType p : pt) {
            try {
                Type.PersistenceType.valueOf((String)p.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("persistenceTypeValuesTest failed");
        }
    }

    public void persistenceTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            Type.PersistenceType pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.BASIC.name());
            if (!pt.equals((Object)Type.PersistenceType.BASIC)) {
                this.logErr("expected:" + Type.PersistenceType.BASIC.name() + ", actual:" + pt.name());
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.EMBEDDABLE.name())).equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                this.logErr("expected:" + Type.PersistenceType.EMBEDDABLE.name() + ", actual:" + pt.name());
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.ENTITY.name())).equals((Object)Type.PersistenceType.ENTITY)) {
                this.logErr("expected:" + Type.PersistenceType.ENTITY.name() + ", actual:" + pt.name());
                pass = false;
            }
            if (!(pt = Type.PersistenceType.valueOf((String)Type.PersistenceType.MAPPED_SUPERCLASS.name())).equals((Object)Type.PersistenceType.MAPPED_SUPERCLASS)) {
                this.logErr("expected:" + Type.PersistenceType.MAPPED_SUPERCLASS.name() + ", actual:" + pt.name());
                pass = false;
            }
            try {
                Type.PersistenceType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                Type.PersistenceType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("persistenceTypeValueOfTest failed");
        }
    }

    public void loadStateValuesTest() throws Exception {
        boolean pass = true;
        List<LoadState> ls = Arrays.asList(LoadState.values());
        if (ls.size() != 3) {
            this.logErr("Number of TemporalType expected:3, actual:" + ls.size());
            pass = false;
        }
        if (ls.contains(LoadState.LOADED)) {
            this.logTrace("received:" + String.valueOf(LoadState.LOADED));
        } else {
            this.logErr("Expected value:" + String.valueOf(LoadState.LOADED));
            pass = false;
        }
        if (ls.contains(LoadState.NOT_LOADED)) {
            this.logTrace("received:" + String.valueOf(LoadState.NOT_LOADED));
        } else {
            this.logErr("Expected value:" + String.valueOf(LoadState.NOT_LOADED));
            pass = false;
        }
        if (ls.contains(LoadState.UNKNOWN)) {
            this.logTrace("received:" + String.valueOf(LoadState.UNKNOWN));
        } else {
            this.logErr("Expected value:" + String.valueOf(LoadState.UNKNOWN));
            pass = false;
        }
        for (LoadState l : ls) {
            try {
                LoadState.valueOf((String)l.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("loadStateValuesTest failed");
        }
    }

    public void loadStateValueOfTest() throws Exception {
        boolean pass = true;
        try {
            LoadState ls = LoadState.valueOf((String)LoadState.LOADED.name());
            if (!ls.equals((Object)LoadState.LOADED)) {
                this.logErr("expected:" + LoadState.LOADED.name() + ", actual:" + ls.name());
                pass = false;
            }
            if (!(ls = LoadState.valueOf((String)LoadState.NOT_LOADED.name())).equals((Object)LoadState.NOT_LOADED)) {
                this.logErr("expected:" + LoadState.NOT_LOADED.name() + ", actual:" + ls.name());
                pass = false;
            }
            if (!(ls = LoadState.valueOf((String)LoadState.UNKNOWN.name())).equals((Object)LoadState.UNKNOWN)) {
                this.logErr("expected:" + LoadState.UNKNOWN.name() + ", actual:" + ls.name());
                pass = false;
            }
            try {
                LoadState.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                LoadState.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception occurred", e);
        }
        if (!pass) {
            throw new Exception("loadStateValueOfTest failed");
        }
    }

    public void persistenceUnitTransactionTypeValuesTest() throws Exception {
        boolean pass = true;
        List<PersistenceUnitTransactionType> putt = Arrays.asList(PersistenceUnitTransactionType.values());
        if (putt.size() != 2) {
            this.logErr("Number of TemporalType expected:2, actual:" + putt.size());
            pass = false;
        }
        if (putt.contains(PersistenceUnitTransactionType.JTA)) {
            this.logTrace("received:" + String.valueOf(PersistenceUnitTransactionType.JTA));
        } else {
            this.logErr("Expected value:" + String.valueOf(PersistenceUnitTransactionType.JTA));
            pass = false;
        }
        if (putt.contains(PersistenceUnitTransactionType.RESOURCE_LOCAL)) {
            this.logTrace("received:" + String.valueOf(PersistenceUnitTransactionType.RESOURCE_LOCAL));
        } else {
            this.logErr("Expected value:" + String.valueOf(PersistenceUnitTransactionType.RESOURCE_LOCAL));
            pass = false;
        }
        for (PersistenceUnitTransactionType p : putt) {
            try {
                PersistenceUnitTransactionType.valueOf((String)p.name());
            }
            catch (Exception e) {
                this.logErr("Received exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("persistenceUnitTransactionTypeValuesTest failed");
        }
    }

    public void persistenceUnitTransactionTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            PersistenceUnitTransactionType putt = PersistenceUnitTransactionType.valueOf((String)PersistenceUnitTransactionType.JTA.name());
            if (!putt.equals((Object)PersistenceUnitTransactionType.JTA)) {
                this.logErr("expected:" + PersistenceUnitTransactionType.JTA.name() + ", actual:" + putt.name());
                pass = false;
            }
            if (!(putt = PersistenceUnitTransactionType.valueOf((String)PersistenceUnitTransactionType.RESOURCE_LOCAL.name())).equals((Object)PersistenceUnitTransactionType.RESOURCE_LOCAL)) {
                this.logErr("expected:" + PersistenceUnitTransactionType.RESOURCE_LOCAL.name() + ", actual:" + putt.name());
                pass = false;
            }
            try {
                PersistenceUnitTransactionType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                PersistenceUnitTransactionType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception occurred", e);
        }
        if (!pass) {
            throw new Exception("persistenceUnitTransactionTypeValueOfTest failed");
        }
    }

    public void parameterModeValuesTest() throws Exception {
        boolean pass = true;
        List<ParameterMode> cpm = Arrays.asList(ParameterMode.values());
        if (cpm.size() != 4) {
            this.logErr("Number of TemporalType expected:4, actual:" + cpm.size());
            pass = false;
        }
        if (cpm.contains(ParameterMode.IN)) {
            this.logTrace("received:" + String.valueOf(ParameterMode.IN));
        } else {
            this.logErr("Expected value:" + String.valueOf(ParameterMode.IN));
            pass = false;
        }
        if (cpm.contains(ParameterMode.INOUT)) {
            this.logTrace("received:" + String.valueOf(ParameterMode.INOUT));
        } else {
            this.logErr("Expected value:" + String.valueOf(ParameterMode.INOUT));
            pass = false;
        }
        if (cpm.contains(ParameterMode.OUT)) {
            this.logTrace("received:" + String.valueOf(ParameterMode.OUT));
        } else {
            this.logErr("Expected value:" + String.valueOf(ParameterMode.OUT));
            pass = false;
        }
        if (cpm.contains(ParameterMode.REF_CURSOR)) {
            this.logTrace("received:" + String.valueOf(ParameterMode.REF_CURSOR));
        } else {
            this.logErr("Expected value:" + String.valueOf(ParameterMode.REF_CURSOR));
            pass = false;
        }
        for (ParameterMode pm : cpm) {
            try {
                ParameterMode.valueOf((String)pm.name());
            }
            catch (Exception e) {
                this.logErr("Received Exception for valueOf", e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("parameterModeValuesTest failed");
        }
    }

    public void parameterModeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            ParameterMode pm = ParameterMode.valueOf((String)ParameterMode.IN.name());
            if (!pm.equals((Object)ParameterMode.IN)) {
                this.logErr("expected:" + ParameterMode.IN.name() + ", actual:" + pm.name());
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.INOUT.name())).equals((Object)ParameterMode.INOUT)) {
                this.logErr("expected:" + ParameterMode.INOUT.name() + ", actual:" + pm.name());
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.OUT.name())).equals((Object)ParameterMode.OUT)) {
                this.logErr("expected:" + ParameterMode.OUT.name() + ", actual:" + pm.name());
                pass = false;
            }
            if (!(pm = ParameterMode.valueOf((String)ParameterMode.REF_CURSOR.name())).equals((Object)ParameterMode.REF_CURSOR)) {
                this.logErr("expected:" + ParameterMode.REF_CURSOR.name() + ", actual:" + pm.name());
                pass = false;
            }
            try {
                ParameterMode.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                ParameterMode.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException npe) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected Exception occurred", e);
        }
        if (!pass) {
            throw new Exception("parameterModeValueOfTest failed");
        }
    }

    public void synchronizationTypeValueOfTest() throws Exception {
        boolean pass = true;
        try {
            SynchronizationType st = SynchronizationType.valueOf((String)SynchronizationType.SYNCHRONIZED.name());
            if (!st.equals((Object)SynchronizationType.SYNCHRONIZED)) {
                this.logErr("expected:" + SynchronizationType.SYNCHRONIZED.name() + ", actual:" + st.name());
                pass = false;
            }
            if (!(st = SynchronizationType.valueOf((String)SynchronizationType.UNSYNCHRONIZED.name())).equals((Object)SynchronizationType.UNSYNCHRONIZED)) {
                this.logErr("expected:" + SynchronizationType.UNSYNCHRONIZED.name() + ", actual:" + st.name());
                pass = false;
            }
            try {
                SynchronizationType.valueOf((String)"DOESNOTEXIST");
                this.logErr("IllegalArgumentException was not thrown");
                pass = false;
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
            }
            try {
                SynchronizationType.valueOf(null);
                this.logErr("NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException iae) {
                this.logTrace("Received expected NullPointerException");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("synchronizationTypeValueOfTest failed");
        }
    }

    public void synchronizationTypeValuesTest() throws Exception {
        boolean pass = true;
        try {
            List<SynchronizationType> st = Arrays.asList(SynchronizationType.values());
            if (st.size() != 2) {
                this.logErr("Number of SynchronizationType expected:2, actual:" + st.size());
                pass = false;
            }
            if (st.contains(SynchronizationType.SYNCHRONIZED)) {
                this.logTrace("received:" + String.valueOf(SynchronizationType.SYNCHRONIZED));
            } else {
                this.logErr("Expected value:" + String.valueOf(SynchronizationType.SYNCHRONIZED));
                pass = false;
            }
            if (st.contains(SynchronizationType.UNSYNCHRONIZED)) {
                this.logTrace("received:" + String.valueOf(SynchronizationType.UNSYNCHRONIZED));
            } else {
                this.logErr("Expected value:" + String.valueOf(SynchronizationType.UNSYNCHRONIZED));
                pass = false;
            }
            for (SynchronizationType s : st) {
                try {
                    SynchronizationType.valueOf((String)s.name());
                }
                catch (Exception e) {
                    this.logErr("Received exception for valueOf", e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("synchronizationTypeValuesTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        if (this.getEntityManager().isOpen()) {
            this.removeTestData();
        }
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

