/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.temporal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Basic;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Entity
@Table(name="A_BASIC")
@Access(value=AccessType.FIELD)
public class A_Field
implements Serializable {
    @Id
    protected String id;
    @Basic
    @Temporal(value=TemporalType.DATE)
    protected Date basicDate;
    @Basic
    @Temporal(value=TemporalType.DATE)
    protected Calendar basicCalendar;
    @ElementCollection
    @CollectionTable(name="DATES_TABLE", joinColumns={@JoinColumn(name="ID")})
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATES")
    private List<Date> dates = new ArrayList<Date>();

    public A_Field() {
    }

    public A_Field(String id, Date basicDate, Calendar basicCalendar) {
        this.id = id;
        this.basicDate = basicDate;
        this.basicCalendar = basicCalendar;
    }

    public A_Field(String id, Date basicDate, Calendar basicCalendar, List<Date> dates) {
        this.id = id;
        this.basicDate = basicDate;
        this.basicCalendar = basicCalendar;
        this.dates = dates;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Calendar getBasicCalendar() {
        return this.basicCalendar;
    }

    public void setBasicCalendar(Calendar basicCalendar) {
        this.basicCalendar = basicCalendar;
    }

    public Date getBasicDate() {
        return this.basicDate;
    }

    public void setBasicDate(Date basicDate) {
        this.basicDate = basicDate;
    }

    public List<Date> getDates() {
        return this.dates;
    }

    public void setDates(List<Date> dates) {
        this.dates = dates;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (!(o instanceof A_Field)) {
            return result;
        }
        A_Field other = (A_Field)o;
        if (this.getId().equals(other.getId()) && this.getBasicCalendar().equals(other.getBasicCalendar()) && this.getBasicDate().equals(other.getBasicDate())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int myHash = this.getId().hashCode() + this.getBasicCalendar().hashCode() + this.getBasicDate().hashCode();
        return myHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        result.append(", date: " + String.valueOf(this.getBasicDate()));
        result.append(", calendar: " + String.valueOf(this.getBasicCalendar()));
        result.append("]");
        return result.toString();
    }
}

