/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.orderby;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address2;
import ee.jakarta.tck.persistence.core.annotations.orderby.Customer;
import ee.jakarta.tck.persistence.core.annotations.orderby.Customer2;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Client3
extends PMClientBase {
    List<Address> addrRef;
    Address addr1 = null;
    Address addr2 = null;
    Address addr3 = null;
    List<Address2> addrRef2;
    Address2 addr11 = null;
    Address2 addr12 = null;
    Address2 addr13 = null;

    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeCustTestData();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void propertyElementCollectionBasicType() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            this.logTrace("Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                this.logTrace("Found Customer: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    this.logTrace("Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        this.logTrace("phone:" + s);
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (String s : expectedphones) {
                        this.logErr("expected:" + s);
                    }
                    this.logErr("actual:");
                    for (String s : cust.getPhones()) {
                        this.logErr("actual:" + s);
                    }
                }
            } else {
                this.logErr("Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("propertyElementCollectionBasicType failed");
        }
    }

    public void fieldElementCollectionBasicType() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer2 expected = new Customer2("2");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            this.logTrace("Persisting Customer2:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            Customer2 cust = (Customer2)this.getEntityManager().find(Customer2.class, (Object)expected.getId());
            if (cust != null) {
                this.logTrace("Found Customer2: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    this.logTrace("Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        this.logTrace("phone:" + s);
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (String s : expectedphones) {
                        this.logErr("expected:" + s);
                    }
                    this.logErr("actual:");
                    for (String s : cust.getPhones()) {
                        this.logErr("actual:" + s);
                    }
                }
            } else {
                this.logErr("Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("fieldElementCollectionBasicType failed");
        }
    }

    public void cleanupCust() throws Exception {
        this.logTrace("cleanup");
        this.removeCustTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeCustTestData() {
        this.logTrace("removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

