/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapsid;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapsid.DID1bDependent;
import ee.jakarta.tck.persistence.core.annotations.mapsid.DID1bDependentId;
import ee.jakarta.tck.persistence.core.annotations.mapsid.DID1bEmployee;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void persistMX1Test1() throws Exception {
        this.logTrace("Begin persistMX1Test1");
        boolean pass = false;
        EntityManager em = null;
        EntityTransaction et = null;
        em = this.getEntityManager();
        et = this.getEntityTransaction();
        et.begin();
        try {
            DID1bEmployee employee1 = new DID1bEmployee(1L, "Duke");
            DID1bEmployee employee2 = new DID1bEmployee(2L, "foo");
            DID1bDependent dep1 = new DID1bDependent(new DID1bDependentId("Obama", 1L), employee1);
            DID1bDependent dep2 = new DID1bDependent(new DID1bDependentId("Michelle", 1L), employee1);
            DID1bDependent dep3 = new DID1bDependent(new DID1bDependentId("John", 2L), employee2);
            em.persist((Object)employee1);
            em.persist((Object)employee2);
            em.persist((Object)dep1);
            em.persist((Object)dep2);
            em.persist((Object)dep3);
            this.logTrace("persisted Employees and Dependents");
            em.flush();
            DID1bDependent newDependent = (DID1bDependent)em.find(DID1bDependent.class, (Object)new DID1bDependentId("Obama", 1L));
            if (newDependent != null) {
                em.refresh((Object)newDependent);
            }
            List depList = em.createQuery("Select d from DID1bDependent d where d.id.name='Obama' and d.emp.name='Duke'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID1bDependent)depList.get(0);
            }
            if (newDependent == dep1) {
                pass = true;
                this.logTrace("Received Expected Dependent");
            } else {
                this.logTrace("searched Dependent not found");
            }
            et.commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            et.rollback();
        }
        if (!pass) {
            throw new Exception("persistMX1Test1 failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from DID1BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DID1BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

