/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkey;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Client;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee2;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee3;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee4;
import java.util.Properties;

public class Client2
extends Client {
    private Employee2 empRef2;
    private Employee3 empRef3;
    private Employee4 empRef4;

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData2();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void joinColumnInsertable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.logTrace("find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            this.logTrace("Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            Department dept = emp2.getDepartment();
            if (dept == null) {
                this.logTrace("Received expected null department for employee2");
            } else {
                pass = false;
                this.logErr("Expected null department, actual:" + dept.getName());
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            this.logTrace("Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            dept = emp3.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[0].getName())) {
                this.logTrace("Received expected department for employee3:" + dept.getName());
            } else {
                pass = false;
                if (dept != null) {
                    this.logErr("Expected department:" + deptRef[0].getName() + ", actual:" + dept.getName());
                } else {
                    this.logErr("Expected department:" + deptRef[0].getName() + ", actual:null");
                }
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            this.logTrace("Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            dept = emp4.getDepartment();
            if (dept == null) {
                this.logTrace("Received expected null department for employee4");
            } else {
                pass = false;
                this.logErr("Expected department: null, actual:" + dept.getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinColumnInsertable Failed");
        }
    }

    public void joinColumnUpdatable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.logTrace("find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            this.logTrace("Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            this.logTrace("set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName());
            emp2.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp2);
            this.getEntityManager().flush();
            this.clearCache();
            this.logTrace("find employee2 again");
            emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            this.logTrace("Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            Department dept = emp2.getDepartment();
            if (dept == null) {
                this.logTrace("Received expected null department");
            } else {
                pass = false;
                this.logErr("Expected null department, actual:" + dept.getName());
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            this.logTrace("Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            this.logTrace("Department:" + emp3.getDepartment().getId() + ", " + emp3.getDepartment().getName());
            this.logTrace("set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName());
            emp3.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp3);
            this.getEntityManager().flush();
            this.clearCache();
            this.logTrace("find employee3 again");
            emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            this.logTrace("Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            dept = emp3.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[0].getName())) {
                this.logTrace("Received expected department:" + dept.getName());
            } else {
                pass = false;
                if (dept != null) {
                    this.logErr("Expected department:" + deptRef[0].getName() + ", actual:" + dept.getName());
                } else {
                    this.logErr("Expected department:" + deptRef[0].getName() + ", actual:null");
                }
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            this.logTrace("Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            if (emp4.getFirstName() != null) {
                this.logErr("Expected first name to be null, actual:" + emp4.getFirstName());
                pass = false;
            }
            if (emp4.getDepartment() != null) {
                this.logErr("Expected Department to be null, actual:" + emp4.getDepartment().toString());
                pass = false;
            }
            this.logTrace("set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName());
            emp4.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp4);
            this.getEntityManager().flush();
            this.clearCache();
            this.logTrace("find employee4 again");
            emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            this.logTrace("Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            dept = emp4.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[1].getName())) {
                this.logTrace("Received expected department:" + dept.getName());
            } else {
                pass = false;
                if (dept != null) {
                    this.logErr("Expected " + deptRef[1].getName() + " department, actual:" + dept.getName());
                } else {
                    this.logErr("Expected " + deptRef[1].getName() + " department, actual:null");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("joinColumnUpdatable Failed");
        }
    }

    public void columnInsertable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.logTrace("find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            String firstName = emp2.getFirstName();
            this.logTrace("Name:" + firstName + " " + emp2.getLastName());
            if (firstName == null) {
                this.logTrace("Received expected null firstName");
            } else {
                pass = false;
                this.logErr("Expected firstName: null, actual:" + firstName);
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            firstName = emp3.getFirstName();
            this.logTrace("Name:" + firstName + " " + emp3.getLastName());
            if (firstName != null && firstName.equals("Paul")) {
                this.logTrace("Received expected firstName:" + firstName);
            } else {
                pass = false;
                this.logErr("Expected firstName: Paul, actual: null");
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            firstName = emp4.getFirstName();
            this.logTrace("Name:" + firstName + " " + emp4.getLastName());
            if (firstName == null) {
                this.logTrace("Received expected null firstName");
            } else {
                pass = false;
                this.logErr("Expected firstName: null, actual:" + firstName);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("columnInsertable Failed");
        }
    }

    public void columnUpdatable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.logTrace("find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            this.logTrace("Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            this.logTrace("set firstName and save");
            emp2.setFirstName("foo");
            this.getEntityManager().merge((Object)emp2);
            this.getEntityManager().flush();
            this.clearCache();
            this.logTrace("find employee2 again");
            emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            this.logTrace("Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            String firstName = emp2.getFirstName();
            if (firstName == null) {
                this.logTrace("Received expected null firstName");
            } else {
                pass = false;
                this.logErr("Expected firstName: null, actual:" + firstName);
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            this.logTrace("Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            this.logTrace("set firstName and save");
            emp3.setFirstName("foo");
            this.getEntityManager().merge((Object)emp3);
            this.getEntityManager().flush();
            this.clearCache();
            this.logTrace("find employee3 again");
            emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            this.logTrace("Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            firstName = emp3.getFirstName();
            if (firstName != null && firstName.equals("Paul")) {
                this.logTrace("Received expected firstName:" + firstName);
            } else {
                pass = false;
                this.logErr("Expected firstName: Paul, actual: null");
            }
            this.clearCache();
            this.logTrace("--------------");
            this.logTrace("find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            this.logTrace("Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            this.logTrace("set firstName and save");
            emp4.setFirstName("foo");
            this.getEntityManager().merge((Object)emp4);
            this.getEntityManager().flush();
            this.clearCache();
            this.logTrace("find employee4 again");
            emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            this.logTrace("Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            firstName = emp4.getFirstName();
            if (firstName != null && firstName.equals("foo")) {
                this.logTrace("Received expected firstName:" + firstName);
            } else {
                pass = false;
                this.logErr("Expected firstName: foo, actual: null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Received unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("columnUpdatable Failed");
        }
    }

    public void createTestData2() throws Exception {
        try {
            this.logTrace("createTestData2");
            this.createTestDataCommon();
            this.getEntityTransaction().begin();
            this.logTrace("Create and persist employee2 ");
            this.empRef2 = new Employee2(6, "John", "Smith");
            this.empRef2.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef2);
            this.logTrace("Create and persist employee3 ");
            this.empRef3 = new Employee3(7, "Paul", "Jones");
            this.empRef3.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef3);
            this.logTrace("Create and persist employee4 ");
            this.empRef4 = new Employee4(8, "Thomas", "Brady");
            this.empRef4.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef4);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }
}

