/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.common;

import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public enum JsonValueType {
    String,
    Integer,
    Long,
    BigInteger,
    Double,
    BigDecimal,
    Boolean,
    JsonValue,
    Null;

    private static final int SIZE;
    private static final Map<String, JsonValueType> VALUES;

    public static JsonValueType getType(Class c) {
        JsonValueType type = VALUES.get(c.getSimpleName());
        if (type != null) {
            return type;
        }
        LinkedList stack = new LinkedList();
        for (Class<?> i : c.getInterfaces()) {
            stack.push(i);
        }
        while (!stack.isEmpty()) {
            Class i = (Class)stack.pop();
            type = VALUES.get(i.getSimpleName());
            if (type != null) {
                return type;
            }
            for (Class<?> j : i.getInterfaces()) {
                stack.push(j);
            }
        }
        throw new IllegalArgumentException("Unsupported JSON value type: " + c.getSimpleName());
    }

    public static JsonValueType getType(Object value) {
        return value != null ? JsonValueType.getType(value.getClass()) : Null;
    }

    public static String toStringValue(Object value) {
        switch (JsonValueType.getType(value).ordinal()) {
            case 0: {
                return "\"" + (String)value + "\"";
            }
            case 1: {
                return ((Integer)value).toString();
            }
            case 2: {
                return ((Long)value).toString();
            }
            case 3: {
                return ((BigInteger)value).toString();
            }
            case 4: {
                return ((Double)value).toString();
            }
            case 5: {
                return ((BigDecimal)value).toString();
            }
            case 6: {
                return ((Boolean)value).toString();
            }
            case 7: {
                return JsonAssert.valueToString((JsonValue)value);
            }
            case 8: {
                return "null";
            }
        }
        throw new IllegalArgumentException("Unsupported JSON value type: " + value.getClass().getSimpleName());
    }

    static {
        SIZE = JsonValueType.values().length;
        VALUES = new HashMap<String, JsonValueType>(SIZE);
        for (int i = 0; i < SIZE; ++i) {
            VALUES.put(JsonValueType.values()[i].name(), JsonValueType.values()[i]);
        }
    }
}

