/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt14;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class prepStmtClient14
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt14";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private Properties props = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient14 theTests = new prepStmtClient14();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                this.props = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception: " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject203() throws Exception {
        Double oMinFloatVal = null;
        Double rFloatVal = null;
        String sminFloatVal = null;
        Double minFloatVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Double to be Updated ");
            sminFloatVal = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            oMinFloatVal = new Double(sminFloatVal);
            minFloatVal = new Double(sminFloatVal);
            this.msg.setMsg("get the PreparedStatement object");
            PreparedStatement pstmt = this.conn.prepareStatement(sPrepStmt);
            pstmt.setObject(1, (Object)oMinFloatVal, 6);
            pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minFloatVal, "" + rFloatVal);
            if (rFloatVal.equals(minFloatVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject204() throws Exception {
        Double rDoubleVal = null;
        String smaxDoubleVal = null;
        Double maxDoubleVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Double to be Updated");
            smaxDoubleVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            maxDoubleVal = new Double(smaxDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxDoubleVal, 8);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Double_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(maxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject205() throws Exception {
        Double rDoubleVal = null;
        String sminDoubleVal = null;
        Double minDoubleVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Double to be Updated");
            sminDoubleVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            minDoubleVal = new Double(sminDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minDoubleVal, 8);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(minDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject206() throws Exception {
        Double oMaxDecimalVal = null;
        BigDecimal rDecimalVal = null;
        String smaxDecimalVal = null;
        BigDecimal maxDecimalVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Decimal to be Updated in Decimal Table");
            smaxDecimalVal = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            oMaxDecimalVal = new Double(smaxDecimalVal);
            maxDecimalVal = new BigDecimal(smaxDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxDecimalVal, 3, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg(String.valueOf(maxDecimalVal), String.valueOf(rDecimalVal));
            if (rDecimalVal.compareTo(maxDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject207() throws Exception {
        Double oMinDecimalVal = null;
        BigDecimal rDecimalVal = null;
        String sminDecimalVal = null;
        BigDecimal minDecimalVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Double to be Updated in Decimal Table");
            sminDecimalVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            oMinDecimalVal = new Double(sminDecimalVal);
            minDecimalVal = new BigDecimal(sminDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinDecimalVal, 3, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg(String.valueOf(minDecimalVal), String.valueOf(rDecimalVal));
            if (rDecimalVal.compareTo(minDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject208() throws Exception {
        Double oMaxNumericVal = null;
        BigDecimal rNumericVal = null;
        String smaxNumericVal = null;
        BigDecimal maxNumericVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Numeric to be Updated in Numeric Table");
            smaxNumericVal = this.rsSch.extractVal("Numeric_Tab", 1, this.sqlp, this.conn);
            oMaxNumericVal = new Double(smaxNumericVal);
            maxNumericVal = new BigDecimal(smaxNumericVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxNumericVal, 2, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg(String.valueOf(maxNumericVal), String.valueOf(rNumericVal));
            if (rNumericVal.compareTo(maxNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject209() throws Exception {
        Double oMinNumericVal = null;
        BigDecimal rNumericVal = null;
        String sminNumericVal = null;
        BigDecimal minNumericVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Double to be Updated in Numeric Table");
            sminNumericVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            oMinNumericVal = new Double(sminNumericVal);
            minNumericVal = new BigDecimal(sminNumericVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinNumericVal, 2, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg(String.valueOf(minNumericVal), String.valueOf(rNumericVal));
            if (rNumericVal.compareTo(minNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject212() throws Exception {
        Double oMaxDoubleVal = null;
        String smaxDoubleVal = null;
        String rStringVal = null;
        Double rDoubleVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Double to be Updated in Char Table");
            smaxDoubleVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            oMaxDoubleVal = new Double(smaxDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxDoubleVal, 1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rDoubleVal = new Double(rStringVal);
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg("" + oMaxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(oMaxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject213() throws Exception {
        Double oMinDoubleVal = null;
        String sminDoubleVal = null;
        String rStringVal = null;
        Double rDoubleVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Double to be Updated in Char Table");
            sminDoubleVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            oMinDoubleVal = new Double(sminDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinDoubleVal, 1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rDoubleVal = new Double(rStringVal);
            this.msg.addOutputMsg("" + oMinDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(oMinDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject214() throws Exception {
        Double oMaxDoubleVal = null;
        String smaxDoubleVal = null;
        String rStringVal = null;
        Double rDoubleVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Double to be Updated in Varchar Table");
            smaxDoubleVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            oMaxDoubleVal = new Double(smaxDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxDoubleVal, 12);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rDoubleVal = new Double(rStringVal);
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg("" + oMaxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(oMaxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject215() throws Exception {
        Double oMinDoubleVal = null;
        String sminDoubleVal = null;
        String rStringVal = null;
        Double rDoubleVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Double to be Updated in Varchar Table");
            sminDoubleVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            oMinDoubleVal = new Double(sminDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinDoubleVal, 12);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rDoubleVal = new Double(rStringVal);
            this.msg.addOutputMsg("" + oMinDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(oMinDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject216() throws Exception {
        Double oMaxDoubleVal = null;
        String smaxDoubleVal = null;
        String rStringVal = null;
        Double rDoubleVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Maximum Value of Double to be Updated in Longvarchar Table");
            smaxDoubleVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            oMaxDoubleVal = new Double(smaxDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMaxDoubleVal, -1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rDoubleVal = new Double(rStringVal);
            rStringVal = rStringVal.trim();
            this.msg.addOutputMsg("" + oMaxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(oMaxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject217() throws Exception {
        Double oMinDoubleVal = null;
        String sminDoubleVal = null;
        String rStringVal = null;
        Double rDoubleVal = null;
        try {
            this.rsSch.createTab("Longvarcharnull_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Minimum Value of Double to be Updated in Longvarchar Table");
            sminDoubleVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            oMinDoubleVal = new Double(sminDoubleVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)oMinDoubleVal, -1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Longvarchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rDoubleVal = new Double(rStringVal);
            this.msg.addOutputMsg("" + oMinDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(oMinDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarcharnull_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject218() throws Exception {
        byte[] retByteArr = null;
        String binarySize = null;
        try {
            this.rsSch.createTab("Binary_Tab", this.sqlp, this.conn);
            binarySize = this.props.getProperty("binarySize");
            String sPrepStmt = this.sqlp.getProperty("Binary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            int bytearrsize = Integer.parseInt(binarySize);
            this.msg.setMsg("Binary Size: " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)bytearr, -2);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Binary_Val_Query = this.sqlp.getProperty("Binary_Query_Val", "");
            this.msg.setMsg(Binary_Val_Query);
            this.rs = this.stmt.executeQuery(Binary_Val_Query);
            this.rs.next();
            retByteArr = (byte[])this.rs.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("setObject Method does not set the designated parameter with the object", "test setObject Failed");
            }
            this.msg.setMsg("setObject Method sets the designated parameter with the object");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Binary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject219() throws Exception {
        byte[] retByteArr = null;
        String varbinarySize = null;
        try {
            this.rsSch.createTab("Varbinary_Tab", this.sqlp, this.conn);
            varbinarySize = this.props.getProperty("varbinarySize");
            this.msg.setMsg("Varbinary Table Size: " + varbinarySize);
            String sPrepStmt = this.sqlp.getProperty("Varbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            int bytearrsize = Integer.parseInt(varbinarySize);
            this.msg.setMsg("Varbinary Size: " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)bytearr, -3);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Varbinary_Val_Query = this.sqlp.getProperty("Varbinary_Query_Val", "");
            this.msg.setMsg(Varbinary_Val_Query);
            this.rs = this.stmt.executeQuery(Varbinary_Val_Query);
            this.rs.next();
            retByteArr = (byte[])this.rs.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("setObject Method does not set the designated parameter with the object", "test setObject Failed");
            }
            this.msg.setMsg("setObject Method sets the designated parameter with the object");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject220() throws Exception {
        byte[] retByteArr = null;
        try {
            this.rsSch.createTab("Longvarbinary_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Longvarbinary_Tab_Val_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            String binsize = this.props.getProperty("longvarbinarySize");
            int bytearrsize = Integer.parseInt(binsize);
            this.msg.setMsg("Longvarbinary Size: " + bytearrsize);
            byte[] bytearr = new byte[bytearrsize];
            String sbyteval = null;
            for (int count = 0; count < bytearrsize; ++count) {
                sbyteval = Integer.toString(count % 255);
                bytearr[count] = Byte.parseByte(sbyteval);
            }
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)bytearr, -4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Longvarbinary_Val_Query = this.sqlp.getProperty("Longvarbinary_Query_Val", "");
            this.msg.setMsg(Longvarbinary_Val_Query);
            this.rs = this.stmt.executeQuery(Longvarbinary_Val_Query);
            this.rs.next();
            retByteArr = (byte[])this.rs.getObject(1);
            for (int i = 0; i < bytearrsize; ++i) {
                this.msg.addOutputMsg(Byte.toString(bytearr[i]), Byte.toString(retByteArr[i]));
                if (retByteArr[i] == bytearr[i]) continue;
                this.msg.printTestError("setObject Method does not set the designated parameter with the object", "test setObject Failed");
            }
            this.msg.setMsg("setObject Method sets the designated parameter with the object");
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Longvarbinary_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject221() throws Exception {
        String maxStringVal = null;
        String rStringVal = null;
        Date maxDateVal = null;
        Date rDateVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Value of Date from Date Table to be Updated in Null Column of Char Table");
            maxStringVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(maxStringVal.indexOf(39) + 1, maxStringVal.lastIndexOf(39));
            maxDateVal = Date.valueOf(maxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxDateVal, 1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = (String)this.rs.getObject(1);
            rStringVal = rStringVal.trim();
            rDateVal = Date.valueOf(rStringVal);
            this.msg.addOutputMsg(String.valueOf(maxDateVal), String.valueOf(rDateVal));
            if (rDateVal.equals(maxDateVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject222() throws Exception {
        Date maxDateVal = null;
        String maxStringVal = null;
        String rStringVal = null;
        Date rDateVal = null;
        try {
            this.rsSch.createTab("Varchar_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Varchar_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("extract the Value of Date from Date Table to be Updated in Null Column of Varchar Table");
            maxStringVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            maxStringVal = maxStringVal.substring(maxStringVal.indexOf(39) + 1, maxStringVal.lastIndexOf(39));
            maxDateVal = Date.valueOf(maxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxDateVal, 12);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Varchar_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            rDateVal = Date.valueOf(rStringVal);
            this.msg.addOutputMsg(String.valueOf(maxDateVal), String.valueOf(rDateVal));
            if (rDateVal.equals(maxDateVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Varchar_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

