/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces;

import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextFactory;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.servlet.ServletContext;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ServletContextFacesContextFactory
extends FacesContextFactory {
    static final String SERVLET_CONTEXT_FINDER_NAME = "com.sun.faces.ServletContextFacesContextFactory";
    static final String SERVLET_CONTEXT_FINDER_REMOVAL_NAME = "com.sun.faces.ServletContextFacesContextFactory_Removal";
    private static final Logger LOGGER = Logger.getLogger("jakarta.faces", "jakarta.faces.LogStrings");
    private ThreadLocal<FacesContext> facesContextCurrentInstance;
    private ConcurrentHashMap<Thread, FacesContext> facesContextThreadInitContextMap;
    private ConcurrentHashMap<FacesContext, ServletContext> initContextServletContextMap;

    ServletContextFacesContextFactory() {
        try {
            Field instanceField = FacesContext.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            this.facesContextCurrentInstance = (ThreadLocal)instanceField.get(null);
            Field threadInitContextMapField = FacesContext.class.getDeclaredField("threadInitContext");
            threadInitContextMapField.setAccessible(true);
            this.facesContextThreadInitContextMap = (ConcurrentHashMap)threadInitContextMapField.get(null);
            Field initContextServletContextMapField = FacesContext.class.getDeclaredField("initContextServletContext");
            initContextServletContextMapField.setAccessible(true);
            this.initContextServletContextMap = (ConcurrentHashMap)initContextServletContextMapField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Unable to access instance field of FacesContext", ex);
        }
    }

    FacesContext getFacesContextWithoutServletContextLookup() {
        FacesContext result = this.facesContextCurrentInstance.get();
        if (result == null && this.facesContextThreadInitContextMap != null) {
            result = this.facesContextThreadInitContextMap.get(Thread.currentThread());
        }
        return result;
    }

    @Override
    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        ServletContext servletContext;
        FacesContext result = null;
        if (this.initContextServletContextMap != null && !this.initContextServletContextMap.isEmpty() && (servletContext = (ServletContext)FactoryFinder.FACTORIES_CACHE.getServletContextForCurrentClassLoader()) != null) {
            for (Map.Entry<FacesContext, ServletContext> entry : this.initContextServletContextMap.entrySet()) {
                if (!servletContext.equals(entry.getValue())) continue;
                result = entry.getKey();
                break;
            }
        }
        return result;
    }
}

