/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.util.ArrayList;
import java.util.List;

public class InstanceState {
    private StateType currentState;
    private List<String> failedCommands;

    public InstanceState(StateType st) {
        this.currentState = st;
        this.failedCommands = new ArrayList<String>();
    }

    public StateType getState() {
        return this.currentState;
    }

    public void setState(StateType state) {
        this.currentState = state;
    }

    public List<String> getFailedCommands() {
        return this.failedCommands;
    }

    public void addFailedCommands(String cmd) {
        if (this.currentState == StateType.NEVER_STARTED) {
            return;
        }
        this.failedCommands.add(cmd);
    }

    public void removeFailedCommands() {
        this.failedCommands.clear();
    }

    public static enum StateType {
        NO_RESPONSE{

            @Override
            public String getDescription() {
                return "NO_RESPONSE";
            }

            @Override
            public String getDisplayString() {
                return " no response";
            }
        }
        ,
        NOT_RUNNING{

            @Override
            public String getDescription() {
                return "NOT_RUNNING";
            }

            @Override
            public String getDisplayString() {
                return " not running";
            }
        }
        ,
        STARTING{

            @Override
            public String getDescription() {
                return "STARTING";
            }

            @Override
            public String getDisplayString() {
                return " starting";
            }
        }
        ,
        RUNNING{

            @Override
            public String getDescription() {
                return "RUNNING";
            }

            @Override
            public String getDisplayString() {
                return " running";
            }
        }
        ,
        RESTART_REQUIRED{

            @Override
            public String getDescription() {
                return "REQUIRES_RESTART";
            }

            @Override
            public String getDisplayString() {
                return " requires restart";
            }
        }
        ,
        NEVER_STARTED{

            @Override
            public String getDescription() {
                return "NEVER_STARTED";
            }

            @Override
            public String getDisplayString() {
                return " never started";
            }
        };


        public String getDescription() {
            return null;
        }

        public String getDisplayString() {
            return "NONE";
        }

        public static StateType makeStateType(String s) {
            for (StateType st : StateType.values()) {
                if (!s.equals(st.getDescription())) continue;
                return st;
            }
            return null;
        }
    }
}

