/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ManagedJobConfig;
import com.sun.enterprise.v3.admin.CompletedJob;
import com.sun.enterprise.v3.admin.JobManagerService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="job-cleanup")
@RunLevel(value=10)
public class JobCleanUpService
implements ConfigListener {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    @Inject
    private JobManagerService jobManagerService;
    @Inject
    private Domain domain;
    private ManagedJobConfig managedJobConfig;
    private ScheduledExecutorService scheduler;

    @PostConstruct
    public void postConstruct() {
        logger.log(Level.FINE, "NCLS-CORE-00073");
        this.managedJobConfig = (ManagedJobConfig)this.domain.getExtensionByType(ManagedJobConfig.class);
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.managedJobConfig);
        logger.fine("NCLS-CORE-00074");
        bean.addListener((ConfigListener)this);
        this.scheduleCleanUp();
    }

    @PreDestroy
    public void preDestroy() {
        logger.log(Level.FINE, "Stopping job cleanup service.");
        ObservableBean bean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.managedJobConfig);
        bean.removeListener((ConfigListener)this);
        this.scheduler.shutdownNow();
    }

    private void scheduleCleanUp() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        logger.fine("NCLS-CORE-00075");
        long delayBetweenRuns = JobManagerService.parseJobRetentionPeriodToMillis(this.managedJobConfig.getPollInterval());
        long initialDelay = JobManagerService.parseJobRetentionPeriodToMillis(this.managedJobConfig.getInitialDelay());
        if (delayBetweenRuns <= 0L) {
            if (initialDelay == 0L) {
                new JobCleanUpTask().run();
            }
            logger.log(Level.INFO, "No job cleanup will be scheduled as poll-interval is set to {0} ms", delayBetweenRuns);
            return;
        }
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(this){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r, JobCleanUpTask.class.getSimpleName());
                result.setDaemon(true);
                return result;
            }
        });
        this.scheduler.scheduleAtFixedRate(new JobCleanUpTask(), initialDelay, delayBetweenRuns, TimeUnit.MILLISECONDS);
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new PropertyChangeHandler(), (Logger)logger);
    }

    private final class JobCleanUpTask
    implements Runnable {
        private JobCleanUpTask() {
        }

        @Override
        public void run() {
            try {
                JobCleanUpService.this.jobManagerService.getCompletedJobsInfo().values().stream().map(CompletedJob::getJobsFile).distinct().forEach(this::cleanUpExpiredJobs);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "NCLS-CORE-00076", e);
            }
        }

        private void cleanUpExpiredJobs(File file) {
            for (JobInfo job : JobCleanUpService.this.jobManagerService.getExpiredJobs(file)) {
                JobCleanUpService.this.jobManagerService.purgeJob(job.jobId);
                JobCleanUpService.this.jobManagerService.purgeCompletedJobForId(job);
                logger.log(Level.FINE, "NCLS-CORE-00072", job);
            }
        }
    }

    class PropertyChangeHandler
    implements Changed {
        PropertyChangeHandler() {
        }

        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
            if (type != Changed.TYPE.CHANGE) {
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "NCLS-CORE-00071", new Object[]{changedType.getName(), changedInstance});
            }
            return this.handleChangeEvent(changedInstance);
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            JobCleanUpService.this.scheduleCleanUp();
            return null;
        }
    }
}

