/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.impl.AbstractDataProvider;
import com.sun.data.provider.impl.AbstractTableDataProvider;
import com.sun.data.provider.impl.IndexRowKey;
import com.sun.data.provider.impl.ObjectFieldKeySupport;
import java.beans.Beans;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ObjectArrayDataProvider
extends AbstractTableDataProvider
implements Serializable {
    private Object[] array = null;
    private transient ResourceBundle bundle = null;
    private boolean includeFields = true;
    private Class objectType;
    private transient ObjectFieldKeySupport support = null;

    public ObjectArrayDataProvider() {
        this.setArray(null);
    }

    public ObjectArrayDataProvider(Object[] array) {
        this.setArray(array);
    }

    public ObjectArrayDataProvider(Object[] array, boolean includeFields) {
        this.setArray(array);
        this.setIncludeFields(includeFields);
    }

    public Object[] getArray() {
        return this.array;
    }

    public void setArray(Object[] array) {
        this.array = array;
        this.objectType = array != null ? array.getClass().getComponentType() : null;
        this.fireProviderChanged();
    }

    public Class getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Class objectType) {
        this.objectType = objectType;
        this.support = null;
        this.fireProviderChanged();
    }

    public boolean isIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(boolean includeFields) {
        this.includeFields = includeFields;
        this.support = null;
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        FieldKey fieldKey = null;
        if (this.getSupport() != null) {
            fieldKey = this.getSupport().getFieldKey(fieldId);
        }
        if (fieldKey != null) {
            return fieldKey;
        }
        throw new IllegalArgumentException(fieldId);
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.getSupport() != null) {
            return this.getSupport().getFieldKeys();
        }
        return FieldKey.EMPTY_ARRAY;
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        return this.getSupport().getType(fieldKey);
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        return this.getValue(fieldKey, this.getCursorRow());
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        this.setValue(fieldKey, this.getCursorRow(), value);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        return this.getSupport().isReadOnly(fieldKey);
    }

    public int getRowCount() throws DataProviderException {
        if (this.array == null) {
            return 0;
        }
        return this.array.length;
    }

    public Object getValue(FieldKey fieldKey, RowKey rowKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        if (!this.isRowAvailable(rowKey)) {
            throw new IndexOutOfBoundsException("" + rowKey);
        }
        if (Beans.isDesignTime() && (this.array == null || this.array.length == 0)) {
            this.array = (Object[])AbstractDataProvider.getFakeData(this.array.getClass(), this.objectType);
        }
        return this.getSupport().getValue(fieldKey, this.array[this.getRowIndex(rowKey)]);
    }

    public void setValue(FieldKey fieldKey, RowKey rowKey, Object value) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        if (this.getSupport().isReadOnly(fieldKey)) {
            throw new IllegalStateException(fieldKey.toString() + " " + this.getBundle().getString("IS_READ_ONLY"));
        }
        if (!this.isRowAvailable(rowKey)) {
            throw new IndexOutOfBoundsException(rowKey.toString());
        }
        Object previous = this.getSupport().getValue(fieldKey, this.array[this.getRowIndex(rowKey)]);
        this.getSupport().setValue(fieldKey, this.array[this.getRowIndex(rowKey)], value);
        if (previous == null && value != null || previous != null && value == null || previous != null && value != null && !previous.equals(value)) {
            this.fireValueChanged(fieldKey, rowKey, previous, value);
            this.fireValueChanged(fieldKey, previous, value);
        }
    }

    public boolean canAppendRow() throws DataProviderException {
        return false;
    }

    public RowKey appendRow() throws DataProviderException {
        throw new UnsupportedOperationException();
    }

    public boolean canInsertRow(RowKey beforeRow) throws DataProviderException {
        return false;
    }

    public RowKey insertRow(RowKey beforeRow) throws DataProviderException {
        throw new UnsupportedOperationException();
    }

    public boolean canRemoveRow(RowKey row) throws DataProviderException {
        return false;
    }

    public void removeRow(RowKey row) throws DataProviderException {
        throw new UnsupportedOperationException();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    private int getRowIndex(RowKey rowKey) throws DataProviderException {
        return ((IndexRowKey)rowKey).getIndex();
    }

    private RowKey getRowKey(int index) throws DataProviderException {
        return new IndexRowKey(index);
    }

    private ObjectFieldKeySupport getSupport() {
        if (this.support == null && this.objectType != null) {
            this.support = new ObjectFieldKeySupport(this.objectType, this.includeFields);
        }
        return this.support;
    }
}

