/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.internal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glassfish.concurro.AbstractManagedThread;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.ThreadExpiredException;

public class ManagedThreadPoolExecutor
extends ThreadPoolExecutor {
    private long threadLifeTime = 0L;

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public ManagedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public void setThreadLifeTime(long threadLifeTime) {
        long keepAliveTime;
        this.threadLifeTime = threadLifeTime;
        if (threadLifeTime > 0L && ((keepAliveTime = this.getKeepAliveTime(TimeUnit.SECONDS)) == 0L || threadLifeTime < keepAliveTime)) {
            this.setKeepAliveTime(threadLifeTime, TimeUnit.SECONDS);
            this.allowCoreThreadTimeOut(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ManagedFutureTask task = (ManagedFutureTask)r;
        try {
            task.done(t);
        }
        finally {
            Thread thread;
            task.resetContext();
            if (this.threadLifeTime > 0L && (thread = Thread.currentThread()) instanceof AbstractManagedThread) {
                long threadStartTime = ((AbstractManagedThread)thread).getThreadStartTime();
                if ((System.currentTimeMillis() - threadStartTime) / 1000L > this.threadLifeTime) {
                    throw new ThreadExpiredException();
                }
            }
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ManagedFutureTask task = (ManagedFutureTask)r;
        task.setupContext();
        task.starting(t);
    }
}

