/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="plain")
@PerLookup
public final class PlainTextActionReporter
extends ActionReporter {
    private transient PrintWriter writer;
    private static final String INDENT = "    ";
    private final StringBuffer message = new StringBuffer();

    public void writeReport(OutputStream os) throws IOException {
        this.writer = new PrintWriter(os);
        this.writer.print("PlainTextActionReporter");
        if (this.isFailure()) {
            this.writer.print("FAILURE");
            Throwable failureCause = this.getFailureCause();
            if (failureCause != null) {
                this.writer.print(failureCause);
            }
        } else {
            this.writer.print("SUCCESS");
        }
        StringBuilder finalOutput = new StringBuilder();
        this.getCombinedMessages(this, finalOutput);
        String outs = finalOutput.toString();
        if (!StringUtils.ok((String)outs)) {
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(PlainTextActionReporter.class);
            this.writer.print(localStrings.getLocalString("get.mon.no.data", "No monitoring data to report."));
            this.writer.print("\n");
        } else {
            this.writer.print(outs);
        }
        this.writer.flush();
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    public void appendMessage(String s) {
        this.message.append(s);
    }

    public void appendMessageln(String s) {
        this.message.append(s).append('\n');
    }

    public void setMessage(String message) {
        super.setMessage(message);
        this.message.delete(0, this.message.length());
        this.appendMessage(message);
    }

    public String getMessage() {
        return this.message.toString();
    }

    @Override
    public void getCombinedMessages(ActionReporter aReport, StringBuilder out) {
        if (aReport == null || !(aReport instanceof PlainTextActionReporter)) {
            throw new RuntimeException("Internal Error: Sub reports are different types than parent report.");
        }
        PlainTextActionReporter ptr = (PlainTextActionReporter)aReport;
        String s = ptr.getOutputData();
        if (StringUtils.ok((String)s)) {
            if (out.length() > 0) {
                out.append('\n');
            }
            out.append(s);
        }
        for (ActionReporter ar : aReport.getSubActionsReport()) {
            this.getCombinedMessages(ar, out);
        }
    }

    private String getOutputData() {
        if (this.superSimple(this.getTopMessagePart())) {
            return this.simpleGetOutputData();
        }
        return this.notSoSimpleGetOutputData();
    }

    private boolean superSimple(ActionReport.MessagePart part) {
        List list = part.getChildren();
        Properties props = part.getProps();
        boolean hasChildren = list != null && !list.isEmpty();
        boolean hasProps = props != null && props.size() > 0;
        return !hasProps && !hasChildren;
    }

    private String simpleGetOutputData() {
        StringBuilder out = new StringBuilder();
        String tm = this.getTopMessagePart().getMessage();
        String body = this.message.toString();
        if (StringUtils.ok((String)tm) && !StringUtils.ok((String)body)) {
            body = tm;
        }
        if (StringUtils.ok((String)body)) {
            out.append(body);
        }
        return out.toString();
    }

    private String notSoSimpleGetOutputData() {
        StringBuilder out = new StringBuilder();
        if (StringUtils.ok((String)this.getActionDescription())) {
            out.append("Description: ").append(this.getActionDescription());
        }
        this.write("", this.getTopMessagePart(), out);
        return out.toString();
    }

    private void write(String indent, ActionReport.MessagePart part, StringBuilder out) {
        out.append(indent).append(part.getMessage()).append('\n');
        this.write(indent + INDENT, part.getProps(), out);
        for (ActionReport.MessagePart child : part.getChildren()) {
            this.write(indent + INDENT, child, out);
        }
    }

    private void write(String indent, Properties props, StringBuilder out) {
        if (props == null || props.size() <= 0) {
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String val = String.valueOf(entry.getValue());
            out.append(indent).append('[').append(key).append('=').append(val).append("\n");
        }
    }
}

