/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public class SQLUpdateStatement
extends SQLModifyStatement {
    @Override
    protected SQLCall buildCallWithoutReturning(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnNothing();
        CharArrayWriter writer = new CharArrayWriter(100);
        try {
            DatabaseField field;
            writer.write("UPDATE ");
            if (this.getHintString() != null) {
                writer.write(this.getHintString());
                writer.write(" ");
            }
            writer.write(this.getTable().getQualifiedNameDelimited(session.getPlatform()));
            writer.write(" SET ");
            ExpressionSQLPrinter printer = null;
            ArrayList<DatabaseField> fieldsForTable = new ArrayList<DatabaseField>();
            Iterator iterator = this.getModifyRow().getValues().iterator();
            Vector values = new Vector();
            Enumeration fieldsEnum = this.getModifyRow().keys();
            while (fieldsEnum.hasMoreElements()) {
                field = (DatabaseField)fieldsEnum.nextElement();
                Object value = iterator.next();
                if (!field.getTable().equals(this.getTable()) && field.hasTableName()) continue;
                fieldsForTable.add(field);
                values.add(value);
            }
            if (fieldsForTable.isEmpty()) {
                return null;
            }
            for (int i = 0; i < fieldsForTable.size(); ++i) {
                field = (DatabaseField)fieldsForTable.get(i);
                writer.write(field.getNameDelimited(session.getPlatform()));
                writer.write(" = ");
                Object e = values.get(i);
                if (e instanceof Expression) {
                    Expression exp = (Expression)e;
                    if (printer == null) {
                        printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, false, this.getBuilder());
                        printer.setWriter(writer);
                    }
                    printer.printExpression(exp);
                } else {
                    call.appendModify(writer, field);
                }
                if (i + 1 >= fieldsForTable.size()) continue;
                writer.write(", ");
            }
            if (this.getWhereClause() != null) {
                writer.write(" WHERE ");
                if (printer == null) {
                    printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, false, this.getBuilder());
                    printer.setWriter(writer);
                }
                printer.printExpression(this.getWhereClause());
            }
            call.setSQLString(((Object)writer).toString());
            return call;
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }
}

