/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.BufferManagerReadGrow;
import com.sun.corba.ee.impl.encoding.BufferManagerReadStream;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.BufferManagerWriteGrow;
import com.sun.corba.ee.impl.encoding.BufferManagerWriteStream;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.INTERNAL;

public class BufferManagerFactory {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    public static final int GROW = 0;
    public static final int STREAM = 2;

    public static BufferManagerRead newBufferManagerRead(GIOPVersion version, byte encodingVersion, ORB orb) {
        if (encodingVersion != 0) {
            return new BufferManagerReadGrow();
        }
        switch (version.intValue()) {
            case 256: {
                return new BufferManagerReadGrow();
            }
            case 257: 
            case 258: {
                return new BufferManagerReadStream(orb);
            }
        }
        throw new INTERNAL("Unknown GIOP version: " + version);
    }

    static BufferManagerRead newReadEncapsulationBufferManager() {
        return new BufferManagerReadGrow();
    }

    static BufferManagerWrite newWriteEncapsulationBufferManager(ORB orb) {
        return new BufferManagerWriteGrow(orb);
    }

    static BufferManagerWrite newBufferManagerWrite(int strategy, byte encodingVersion, ORB orb) {
        if (encodingVersion != 0) {
            if (strategy != 0) {
                throw wrapper.invalidBuffMgrStrategy("newBufferManagerWrite");
            }
            return new BufferManagerWriteGrow(orb);
        }
        switch (strategy) {
            case 0: {
                return new BufferManagerWriteGrow(orb);
            }
            case 2: {
                return new BufferManagerWriteStream(orb);
            }
        }
        throw new INTERNAL("Unknown buffer manager write strategy: " + strategy);
    }

    public static BufferManagerWrite newBufferManagerWrite(GIOPVersion version, byte encodingVersion, ORB orb) {
        if (encodingVersion != 0) {
            return new BufferManagerWriteGrow(orb);
        }
        return BufferManagerFactory.newBufferManagerWrite(orb.getORBData().getGIOPBuffMgrStrategy(version), encodingVersion, orb);
    }
}

