/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.def;

import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyContextException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Map;

public class DefaultPolicyConfigurationStateMachine
implements PolicyConfiguration {
    private State state = State.OPEN;
    private PolicyConfiguration policyConfiguration;

    public DefaultPolicyConfigurationStateMachine(PolicyConfiguration policyConfiguration) {
        this.policyConfiguration = policyConfiguration;
    }

    public PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    public String getContextID() throws PolicyContextException {
        return this.policyConfiguration.getContextID();
    }

    public boolean inService() throws PolicyContextException {
        return this.state == State.INSERVICE;
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.addToExcludedPolicy(permission);
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.addToUncheckedPolicy(permission);
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.addToRole(roleName, permission);
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.addToExcludedPolicy(permissions);
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.addToUncheckedPolicy(permissions);
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.addToRole(roleName, permissions);
    }

    public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.linkConfiguration(link);
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.removeExcludedPolicy();
    }

    public void removeRole(String roleName) throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.removeRole(roleName);
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        this.checkStateIs(State.OPEN);
        this.policyConfiguration.removeUncheckedPolicy();
    }

    public void commit() throws PolicyContextException {
        this.checkStateIsNot(State.DELETED);
        if (this.state == State.OPEN) {
            this.policyConfiguration.commit();
            this.state = State.INSERVICE;
        }
    }

    public void delete() throws PolicyContextException {
        this.policyConfiguration.delete();
        this.state = State.DELETED;
    }

    public Map<String, PermissionCollection> getPerRolePermissions() {
        return this.policyConfiguration.getPerRolePermissions();
    }

    public PermissionCollection getUncheckedPermissions() {
        return this.policyConfiguration.getUncheckedPermissions();
    }

    public PermissionCollection getExcludedPermissions() {
        return this.policyConfiguration.getExcludedPermissions();
    }

    public void open() {
        this.state = State.OPEN;
    }

    private void checkStateIs(State requiredState) {
        if (this.state != requiredState) {
            throw new IllegalStateException("Required status is " + String.valueOf((Object)requiredState) + " but actual state is " + String.valueOf((Object)this.state));
        }
    }

    private void checkStateIsNot(State undesiredState) {
        if (this.state == undesiredState) {
            throw new IllegalStateException("State could not be " + String.valueOf((Object)undesiredState) + " but actual state is");
        }
    }

    public static enum State {
        OPEN,
        INSERVICE,
        DELETED;

    }
}

