/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.constraints;

import jakarta.servlet.annotation.ServletSecurity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.exousia.constraints.WebResourceCollection;

public class SecurityConstraint {
    private final List<WebResourceCollection> webResourceCollections;
    private final Set<String> rolesAllowed;
    private final ServletSecurity.TransportGuarantee transportGuarantee;

    public SecurityConstraint(String urlPattern, String ... rolesAllowed) {
        this(new WebResourceCollection(urlPattern), rolesAllowed);
    }

    public SecurityConstraint(WebResourceCollection webResourceCollection, String ... rolesAllowed) {
        this(Arrays.asList(webResourceCollection), Arrays.asList(rolesAllowed));
    }

    public SecurityConstraint(List<WebResourceCollection> webResourceCollections, String ... rolesAllowed) {
        this(webResourceCollections, Arrays.asList(rolesAllowed));
    }

    public SecurityConstraint(List<WebResourceCollection> webResourceCollections, List<String> rolesAllowed) {
        this(webResourceCollections, new HashSet<String>(rolesAllowed));
    }

    public SecurityConstraint(List<WebResourceCollection> webResourceCollections, Set<String> rolesAllowed) {
        this(webResourceCollections, rolesAllowed, ServletSecurity.TransportGuarantee.NONE);
    }

    public SecurityConstraint(List<WebResourceCollection> webResourceCollections, Set<String> rolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee) {
        this.webResourceCollections = Collections.unmodifiableList(webResourceCollections);
        this.rolesAllowed = rolesAllowed == null ? null : Collections.unmodifiableSet(rolesAllowed);
        this.transportGuarantee = transportGuarantee;
    }

    public List<WebResourceCollection> getWebResourceCollections() {
        return this.webResourceCollections;
    }

    public ServletSecurity.TransportGuarantee getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public Set<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[webResourceCollections: " + String.valueOf(this.getWebResourceCollections()) + ", rolesAllowed: " + String.valueOf(this.getRolesAllowed()) + ", transportGuarantee: " + String.valueOf(this.getTransportGuarantee()) + "]";
    }

    public static List<SecurityConstraint> join(List<SecurityConstraint> constraintsA, List<SecurityConstraint> constraintsB, List<SecurityConstraint> constraintsC, List<SecurityConstraint> constraintsD) {
        return SecurityConstraint.join(SecurityConstraint.join(constraintsA, constraintsB, constraintsC), constraintsD);
    }

    public static List<SecurityConstraint> join(List<SecurityConstraint> constraintsA, List<SecurityConstraint> constraintsB, List<SecurityConstraint> constraintsC) {
        return SecurityConstraint.join(SecurityConstraint.join(constraintsA, constraintsB), constraintsC);
    }

    public static List<SecurityConstraint> join(List<SecurityConstraint> constraintsA, List<SecurityConstraint> constraintsB) {
        if (constraintsA == null && constraintsB == null) {
            return null;
        }
        if (constraintsA != null && constraintsB != null) {
            return Stream.concat(constraintsA.stream(), constraintsB.stream()).collect(Collectors.toList());
        }
        if (constraintsA != null) {
            return constraintsA;
        }
        return constraintsB;
    }
}

