/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.mail.admin.cli;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.glassfish.resources.mail.config.MailResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="mail-resource")
@I18n(value="add.resources")
public class MailResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(MailResourceManager.class);
    private String mailHost;
    private String mailUser;
    private String fromAddress;
    private String jndiName;
    private String storeProtocol;
    private String storeProtocolClass;
    private String transportProtocol;
    private String transportProtocolClass;
    private String enabled;
    private String enabledValueForTarget;
    private String debug;
    private String description;
    @Inject
    private ResourceUtil resourceUtil;
    @Inject
    private BindableResourcesHelper resourcesHelper;

    public String getResourceType() {
        return "mail-resource";
    }

    public ResourceStatus create(Resources resources, ResourceAttributes attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        if (org.glassfish.resourcebase.resources.util.ResourceUtil.getBindableResourceByName((Resources)resources, (String)this.jndiName) != null) {
            String msg = I18N.getLocalString("create.mail.resource.duplicate.1", "A Mail Resource named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg, true);
        }
        try {
            SingleConfigCode configCode = param -> {
                MailResource newResource = this.createConfigBean((Resources)param, properties);
                param.getResources().add(newResource);
                return newResource;
            };
            ConfigSupport.apply((SingleConfigCode)configCode, (ConfigBeanProxy)resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
            String msg = I18N.getLocalString("create.mail.resource.success", "Mail Resource {0} created.", new Object[]{this.jndiName});
            return new ResourceStatus(0, msg, true);
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("create.mail.resource.fail", "Unable to create Mail Resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
    }

    private ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.mailHost == null) {
            String msg = I18N.getLocalString("create.mail.resource.noHostName", "No host name defined for Mail Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.mailUser == null) {
            String msg = I18N.getLocalString("create.mail.resource.noUserName", "No user name defined for Mail Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.fromAddress == null) {
            String msg = I18N.getLocalString("create.mail.resource.noFrom", "From not defined for Mail Resource.");
            return new ResourceStatus(1, msg, true);
        }
        ResourceStatus status = this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, MailResource.class);
        if (status.getStatus() == 1) {
            return status;
        }
        return status;
    }

    private MailResource createConfigBean(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        MailResource newResource = (MailResource)param.createChild(MailResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFrom(this.fromAddress);
        newResource.setUser(this.mailUser);
        newResource.setHost(this.mailHost);
        newResource.setEnabled(this.enabled);
        newResource.setStoreProtocol(this.storeProtocol);
        newResource.setStoreProtocolClass(this.storeProtocolClass);
        newResource.setTransportProtocol(this.transportProtocol);
        newResource.setTransportProtocolClass(this.transportProtocolClass);
        newResource.setDebug(this.debug);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (props != null) {
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setAttributes(ResourceAttributes attributes, String target) {
        this.jndiName = attributes.getString("jndi-name");
        this.mailHost = attributes.getString("host");
        this.mailUser = attributes.getString("user");
        this.fromAddress = attributes.getString("from");
        this.storeProtocol = attributes.getString("store-protocol");
        this.storeProtocolClass = attributes.getString("store-protocol-class");
        this.transportProtocol = attributes.getString("transport-protocol");
        this.transportProtocolClass = attributes.getString("transport-protocol-class");
        this.debug = attributes.getString("debug");
        this.enabled = target == null ? attributes.getString("enabled") : this.resourceUtil.computeEnabledValueForResourceBasedOnTarget(attributes.getString("enabled"), target);
        this.enabledValueForTarget = attributes.getString("enabled");
        this.description = attributes.getString("description");
    }

    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

