/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.File;
import java.io.IOException;
import org.glassfish.rmic.tools.java.AmbiguousClass;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.IdentifierToken;
import org.glassfish.rmic.tools.java.Imports;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.Package;
import org.glassfish.rmic.tools.java.Type;

public class Environment
implements Constants {
    Environment env;
    String encoding;
    Object source;
    private static boolean debugging = System.getProperty("javac.debug") != null;
    private static boolean dependtrace = System.getProperty("javac.trace.depend") != null;
    private static boolean dumpmodifiers = System.getProperty("javac.dump.modifiers") != null;

    public Environment(Environment env, Object source) {
        if (env != null && env.env != null && env.getClass() == this.getClass()) {
            env = env.env;
        }
        this.env = env;
        this.source = source;
    }

    public Environment() {
        this(null, null);
    }

    public boolean isExemptPackage(Identifier id) {
        return this.env.isExemptPackage(id);
    }

    public ClassDeclaration getClassDeclaration(Identifier nm) {
        return this.env.getClassDeclaration(nm);
    }

    public final ClassDefinition getClassDefinition(Identifier nm) throws ClassNotFound {
        if (nm.isInner()) {
            ClassDefinition c = this.getClassDefinition(nm.getTopName());
            Identifier tail = nm.getFlatName();
            block0: while (tail.isQualified()) {
                Identifier head = (tail = tail.getTail()).getHead();
                String hname = head.toString();
                if (hname.length() > 0 && Character.isDigit(hname.charAt(0))) {
                    ClassDefinition localClass = c.getLocalClass(hname);
                    if (localClass != null) {
                        c = localClass;
                        continue;
                    }
                } else {
                    for (MemberDefinition f = c.getFirstMatch(head); f != null; f = f.getNextMatch()) {
                        if (!f.isInnerClass()) continue;
                        c = f.getInnerClass();
                        continue block0;
                    }
                }
                throw new ClassNotFound(Identifier.lookupInner(c.getName(), head));
            }
            return c;
        }
        return this.getClassDeclaration(nm).getClassDefinition(this);
    }

    public ClassDeclaration getClassDeclaration(Type t) {
        return this.getClassDeclaration(t.getClassName());
    }

    public final ClassDefinition getClassDefinition(Type t) throws ClassNotFound {
        return this.getClassDefinition(t.getClassName());
    }

    public boolean classExists(Identifier nm) {
        return this.env.classExists(nm);
    }

    public final boolean classExists(Type t) {
        return !t.isType(10) || this.classExists(t.getClassName());
    }

    public Package getPackage(Identifier pkg) throws IOException {
        return this.env.getPackage(pkg);
    }

    public void loadDefinition(ClassDeclaration c) {
        this.env.loadDefinition(c);
    }

    public final Object getSource() {
        return this.source;
    }

    public boolean resolve(long where, ClassDefinition c, Type t) {
        switch (t.getTypeCode()) {
            case 10: {
                try {
                    ClassDefinition def;
                    Identifier nm = t.getClassName();
                    if (!(nm.isQualified() || nm.isInner() || this.classExists(nm))) {
                        this.resolve(nm);
                    }
                    if (!c.canAccess(this, (def = this.getQualifiedClassDefinition(where, nm, c, false)).getClassDeclaration())) {
                        this.error(where, "cant.access.class", def);
                        return true;
                    }
                    def.noteUsedBy(c, where, this.env);
                }
                catch (AmbiguousClass ee) {
                    this.error(where, "ambig.class", ee.name1, ee.name2);
                    return false;
                }
                catch (ClassNotFound e) {
                    try {
                        if (e.name.isInner() && this.getPackage(e.name.getTopName()).exists()) {
                            this.env.error(where, "class.and.package", e.name.getTopName());
                        }
                    }
                    catch (IOException ee) {
                        this.env.error(where, "io.exception", "package check");
                    }
                    this.error(where, "class.not.found.no.context", e.name);
                    return false;
                }
                return true;
            }
            case 9: {
                return this.resolve(where, c, t.getElementType());
            }
            case 12: {
                boolean ok = this.resolve(where, c, t.getReturnType());
                Type[] args = t.getArgumentTypes();
                int i = args.length;
                while (i-- > 0) {
                    ok &= this.resolve(where, c, args[i]);
                }
                return ok;
            }
        }
        return true;
    }

    public boolean resolveByName(long where, ClassDefinition c, Identifier nm) {
        return this.resolveByName(where, c, nm, false);
    }

    public boolean resolveExtendsByName(long where, ClassDefinition c, Identifier nm) {
        return this.resolveByName(where, c, nm, true);
    }

    private boolean resolveByName(long where, ClassDefinition c, Identifier nm, boolean isExtends) {
        try {
            if (!(nm.isQualified() || nm.isInner() || this.classExists(nm))) {
                this.resolve(nm);
            }
            ClassDefinition def = this.getQualifiedClassDefinition(where, nm, c, isExtends);
            ClassDeclaration decl = def.getClassDeclaration();
            if (!(!isExtends && c.canAccess(this, decl) || isExtends && c.extendsCanAccess(this, decl))) {
                this.error(where, "cant.access.class", def);
                return true;
            }
        }
        catch (AmbiguousClass ee) {
            this.error(where, "ambig.class", ee.name1, ee.name2);
            return false;
        }
        catch (ClassNotFound e) {
            try {
                if (e.name.isInner() && this.getPackage(e.name.getTopName()).exists()) {
                    this.env.error(where, "class.and.package", e.name.getTopName());
                }
            }
            catch (IOException ee) {
                this.env.error(where, "io.exception", "package check");
            }
            this.error(where, "class.not.found", e.name, "type name");
            return false;
        }
        return true;
    }

    public final ClassDefinition getQualifiedClassDefinition(long where, Identifier nm, ClassDefinition ctxClass, boolean isExtends) throws ClassNotFound {
        if (nm.isInner()) {
            ClassDefinition c = this.getClassDefinition(nm.getTopName());
            Identifier tail = nm.getFlatName();
            block0: while (tail.isQualified()) {
                Identifier head = (tail = tail.getTail()).getHead();
                String hname = head.toString();
                if (hname.length() > 0 && Character.isDigit(hname.charAt(0))) {
                    ClassDefinition localClass = c.getLocalClass(hname);
                    if (localClass != null) {
                        c = localClass;
                        continue;
                    }
                } else {
                    for (MemberDefinition f = c.getFirstMatch(head); f != null; f = f.getNextMatch()) {
                        if (!f.isInnerClass()) continue;
                        ClassDeclaration rdecl = c.getClassDeclaration();
                        c = f.getInnerClass();
                        ClassDeclaration fdecl = c.getClassDeclaration();
                        if ((isExtends || ctxClass.canAccess(this.env, fdecl)) && (!isExtends || ctxClass.extendsCanAccess(this.env, fdecl))) continue block0;
                        this.env.error(where, "no.type.access", head, rdecl, ctxClass);
                        continue block0;
                    }
                }
                throw new ClassNotFound(Identifier.lookupInner(c.getName(), head));
            }
            return c;
        }
        return this.getClassDeclaration(nm).getClassDefinition(this);
    }

    public Type resolveNames(ClassDefinition c, Type t, boolean synth) {
        this.dtEvent("Environment.resolveNames: " + c + ", " + t);
        switch (t.getTypeCode()) {
            case 10: {
                Identifier name = t.getClassName();
                Identifier rname = synth ? this.resolvePackageQualifiedName(name) : c.resolveName(this, name);
                if (name == rname) break;
                t = Type.tClass(rname);
                break;
            }
            case 9: {
                t = Type.tArray(this.resolveNames(c, t.getElementType(), synth));
                break;
            }
            case 12: {
                Type ret = t.getReturnType();
                Type rret = this.resolveNames(c, ret, synth);
                Type[] args = t.getArgumentTypes();
                Type[] rargs = new Type[args.length];
                boolean changed = ret != rret;
                int i = args.length;
                while (i-- > 0) {
                    Type rarg;
                    Type arg = args[i];
                    rargs[i] = rarg = this.resolveNames(c, arg, synth);
                    if (arg == rarg) continue;
                    changed = true;
                }
                if (!changed) break;
                t = Type.tMethod(rret, rargs);
                break;
            }
        }
        return t;
    }

    public Identifier resolveName(Identifier name) {
        if (name.isQualified()) {
            Identifier rhead = this.resolveName(name.getHead());
            if (rhead.hasAmbigPrefix()) {
                return rhead;
            }
            if (!this.classExists(rhead)) {
                return this.resolvePackageQualifiedName(name);
            }
            try {
                return this.getClassDefinition(rhead).resolveInnerClass(this, name.getTail());
            }
            catch (ClassNotFound ee) {
                return Identifier.lookupInner(rhead, name.getTail());
            }
        }
        try {
            return this.resolve(name);
        }
        catch (AmbiguousClass ee) {
            if (name.hasAmbigPrefix()) {
                return name;
            }
            return name.addAmbigPrefix();
        }
        catch (ClassNotFound ee) {
            Imports imports = this.getImports();
            if (imports != null) {
                return imports.forceResolve(this, name);
            }
            return name;
        }
    }

    public final Identifier resolvePackageQualifiedName(Identifier name) {
        Identifier tail = null;
        while (!this.classExists(name)) {
            if (!name.isQualified()) {
                name = tail == null ? name : Identifier.lookup(name, tail);
                tail = null;
                break;
            }
            Identifier nm = name.getName();
            tail = tail == null ? nm : Identifier.lookup(nm, tail);
            name = name.getQualifier();
        }
        if (tail != null) {
            name = Identifier.lookupInner(name, tail);
        }
        return name;
    }

    public Identifier resolve(Identifier nm) throws ClassNotFound {
        if (this.env == null) {
            return nm;
        }
        return this.env.resolve(nm);
    }

    public Imports getImports() {
        if (this.env == null) {
            return null;
        }
        return this.env.getImports();
    }

    public ClassDefinition makeClassDefinition(Environment origEnv, long where, IdentifierToken name, String doc, int modifiers, IdentifierToken superClass, IdentifierToken[] interfaces, ClassDefinition outerClass) {
        if (this.env == null) {
            return null;
        }
        return this.env.makeClassDefinition(origEnv, where, name, doc, modifiers, superClass, interfaces, outerClass);
    }

    public MemberDefinition makeMemberDefinition(Environment origEnv, long where, ClassDefinition clazz, String doc, int modifiers, Type type, Identifier name, IdentifierToken[] argNames, IdentifierToken[] expIds, Object value) {
        if (this.env == null) {
            return null;
        }
        return this.env.makeMemberDefinition(origEnv, where, clazz, doc, modifiers, type, name, argNames, expIds, value);
    }

    public boolean isApplicable(MemberDefinition m, Type[] args) throws ClassNotFound {
        Type mType = m.getType();
        if (!mType.isType(12)) {
            return false;
        }
        Type[] mArgs = mType.getArgumentTypes();
        if (args.length != mArgs.length) {
            return false;
        }
        int i = args.length;
        while (--i >= 0) {
            if (this.isMoreSpecific(args[i], mArgs[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isMoreSpecific(MemberDefinition best, MemberDefinition other) throws ClassNotFound {
        Type otherType;
        Type bestType = best.getClassDeclaration().getType();
        boolean result = this.isMoreSpecific(bestType, otherType = other.getClassDeclaration().getType()) && this.isApplicable(other, best.getType().getArgumentTypes());
        return result;
    }

    public boolean isMoreSpecific(Type from, Type to) throws ClassNotFound {
        return this.implicitCast(from, to);
    }

    public boolean implicitCast(Type from, Type to) throws ClassNotFound {
        if (from == to) {
            return true;
        }
        int toTypeCode = to.getTypeCode();
        switch (from.getTypeCode()) {
            case 1: {
                if (toTypeCode == 3) {
                    return true;
                }
            }
            case 2: 
            case 3: {
                if (toTypeCode == 4) {
                    return true;
                }
            }
            case 4: {
                if (toTypeCode == 5) {
                    return true;
                }
            }
            case 5: {
                if (toTypeCode == 6) {
                    return true;
                }
            }
            case 6: {
                if (toTypeCode == 7) {
                    return true;
                }
            }
            default: {
                return false;
            }
            case 8: {
                return to.inMask(1792);
            }
            case 9: {
                if (!to.isType(9)) {
                    return to == Type.tObject || to == Type.tCloneable || to == Type.tSerializable;
                }
                do {
                    from = from.getElementType();
                    to = to.getElementType();
                } while (from.isType(9) && to.isType(9));
                if (from.inMask(1536) && to.inMask(1536)) {
                    return this.isMoreSpecific(from, to);
                }
                return from.getTypeCode() == to.getTypeCode();
            }
            case 10: 
        }
        if (toTypeCode == 10) {
            ClassDefinition fromDef = this.getClassDefinition(from);
            ClassDefinition toDef = this.getClassDefinition(to);
            return toDef.implementedBy(this, fromDef.getClassDeclaration());
        }
        return false;
    }

    public boolean explicitCast(Type from, Type to) throws ClassNotFound {
        if (this.implicitCast(from, to)) {
            return true;
        }
        if (from.inMask(254)) {
            return to.inMask(254);
        }
        if (from.isType(10) && to.isType(10)) {
            ClassDefinition fromClass = this.getClassDefinition(from);
            ClassDefinition toClass = this.getClassDefinition(to);
            if (toClass.isFinal()) {
                return fromClass.implementedBy(this, toClass.getClassDeclaration());
            }
            if (fromClass.isFinal()) {
                return toClass.implementedBy(this, fromClass.getClassDeclaration());
            }
            if (toClass.isInterface() && fromClass.isInterface()) {
                return toClass.couldImplement(fromClass);
            }
            return toClass.isInterface() || fromClass.isInterface() || fromClass.superClassOf(this, toClass.getClassDeclaration());
        }
        if (to.isType(9)) {
            if (from.isType(9)) {
                Type t1 = from.getElementType();
                Type t2 = to.getElementType();
                while (t1.getTypeCode() == 9 && t2.getTypeCode() == 9) {
                    t1 = t1.getElementType();
                    t2 = t2.getElementType();
                }
                if (t1.inMask(1536) && t2.inMask(1536)) {
                    return this.explicitCast(t1, t2);
                }
            } else if (from == Type.tObject || from == Type.tCloneable || from == Type.tSerializable) {
                return true;
            }
        }
        return false;
    }

    public int getFlags() {
        return this.env.getFlags();
    }

    public final boolean debug_lines() {
        return (this.getFlags() & 0x1000) != 0;
    }

    public final boolean debug_vars() {
        return (this.getFlags() & 0x2000) != 0;
    }

    public final boolean debug_source() {
        return (this.getFlags() & 0x40000) != 0;
    }

    public final boolean opt() {
        return (this.getFlags() & 0x4000) != 0;
    }

    public final boolean opt_interclass() {
        return (this.getFlags() & 0x8000) != 0;
    }

    public final boolean verbose() {
        return (this.getFlags() & 1) != 0;
    }

    public final boolean dump() {
        return (this.getFlags() & 2) != 0;
    }

    public final boolean warnings() {
        return (this.getFlags() & 4) != 0;
    }

    public final boolean dependencies() {
        return (this.getFlags() & 0x20) != 0;
    }

    public final boolean print_dependencies() {
        return (this.getFlags() & 0x400) != 0;
    }

    public final boolean deprecation() {
        return (this.getFlags() & 0x200) != 0;
    }

    public final boolean version12() {
        return (this.getFlags() & 0x800) != 0;
    }

    public final boolean strictdefault() {
        return (this.getFlags() & 0x20000) != 0;
    }

    public void shutdown() {
        if (this.env != null) {
            this.env.shutdown();
        }
    }

    public void error(Object source, long where, String err, Object arg1, Object arg2, Object arg3) {
        this.env.error(source, where, err, arg1, arg2, arg3);
    }

    public final void error(long where, String err, Object arg1, Object arg2, Object arg3) {
        this.error(this.source, where, err, arg1, arg2, arg3);
    }

    public final void error(long where, String err, Object arg1, Object arg2) {
        this.error(this.source, where, err, arg1, arg2, null);
    }

    public final void error(long where, String err, Object arg1) {
        this.error(this.source, where, err, arg1, null, null);
    }

    public final void error(long where, String err) {
        this.error(this.source, where, err, null, null, null);
    }

    public void output(String msg) {
        this.env.output(msg);
    }

    public static void debugOutput(Object msg) {
        if (debugging) {
            System.out.println(msg.toString());
        }
    }

    public void setCharacterEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public short getMajorVersion() {
        if (this.env == null) {
            return 45;
        }
        return this.env.getMajorVersion();
    }

    public short getMinorVersion() {
        if (this.env == null) {
            return 3;
        }
        return this.env.getMinorVersion();
    }

    public final boolean coverage() {
        return (this.getFlags() & 0x40) != 0;
    }

    public final boolean covdata() {
        return (this.getFlags() & 0x80) != 0;
    }

    public File getcovFile() {
        return this.env.getcovFile();
    }

    public void dtEnter(String s) {
        if (dependtrace) {
            System.out.println(">>> " + s);
        }
    }

    public void dtExit(String s) {
        if (dependtrace) {
            System.out.println("<<< " + s);
        }
    }

    public void dtEvent(String s) {
        if (dependtrace) {
            System.out.println(s);
        }
    }

    public boolean dumpModifiers() {
        return dumpmodifiers;
    }
}

