/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.config;

import com.sun.enterprise.config.modularity.annotation.HasNoDefaultConfiguration;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;

@Configured
@HasNoDefaultConfiguration
public interface SecurityConfigurations
extends ConfigBeanProxy,
DomainExtension {
    @Element(value="*")
    public List<SecurityConfiguration> getSecurityServices();

    default public <T extends SecurityConfiguration> List<T> getSecurityServicesByType(Class<T> type) {
        ArrayList<SecurityConfiguration> typedServices = new ArrayList<SecurityConfiguration>();
        for (SecurityConfiguration securityServiceConfiguration : this.getSecurityServices()) {
            try {
                if (!type.isAssignableFrom(securityServiceConfiguration.getClass())) continue;
                typedServices.add((SecurityConfiguration)type.cast(securityServiceConfiguration));
            }
            catch (Exception exception) {}
        }
        return Collections.unmodifiableList(typedServices);
    }

    default public <T extends SecurityConfiguration> T getDefaultSecurityServiceByType(Class<T> type) {
        for (SecurityConfiguration securityServiceConfiguration : this.getSecurityServices()) {
            try {
                if (!securityServiceConfiguration.getDefault()) continue;
                return (T)((SecurityConfiguration)type.cast(securityServiceConfiguration));
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    default public <T extends SecurityConfiguration> T getSecurityServiceByName(String name, Class<T> type) {
        for (SecurityConfiguration securityServiceConfiguration : this.getSecurityServices()) {
            try {
                if (!securityServiceConfiguration.getName().equals(name)) continue;
                return (T)((SecurityConfiguration)type.cast(securityServiceConfiguration));
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    default public SecurityConfiguration getSecurityServiceByName(String name) {
        for (SecurityConfiguration securityServiceConfiguration : this.getSecurityServices()) {
            if (!securityServiceConfiguration.getName().equals(name)) continue;
            return securityServiceConfiguration;
        }
        return null;
    }
}

