/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.mdb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import jakarta.ejb.ActivationConfigProperty;
import jakarta.ejb.MessageDriven;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractEjbHandler;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=MessageDriven.class)
public class MessageDrivenHandler
extends AbstractEjbHandler {
    protected String getAnnotatedName(Annotation annotation) {
        MessageDriven mdAn = (MessageDriven)annotation;
        return mdAn.name();
    }

    protected boolean isValidEjbDescriptor(EjbDescriptor ejbDesc, Annotation annotation) {
        return "Message-driven".equals(ejbDesc.getType());
    }

    protected EjbDescriptor createEjbDescriptor(String elementName, AnnotationInfo ainfo) throws AnnotationProcessorException {
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        EjbMessageBeanDescriptor newDescriptor = new EjbMessageBeanDescriptor();
        Class ejbClass = (Class)ae;
        newDescriptor.setName(elementName);
        newDescriptor.setEjbClassName(ejbClass.getName());
        return newDescriptor;
    }

    protected HandlerProcessingResult setEjbDescriptorInfo(EjbDescriptor ejbDesc, AnnotationInfo ainfo) throws AnnotationProcessorException {
        MessageDriven mdAn = (MessageDriven)ainfo.getAnnotation();
        Class ejbClass = (Class)ainfo.getAnnotatedElement();
        EjbMessageBeanDescriptor ejbMsgBeanDesc = (EjbMessageBeanDescriptor)ejbDesc;
        HandlerProcessingResult procResult = this.setMessageListenerInterface(mdAn, ejbMsgBeanDesc, ejbClass, ainfo);
        this.doDescriptionProcessing(mdAn.description(), (EjbDescriptor)ejbMsgBeanDesc);
        this.doMappedNameProcessing(mdAn.mappedName(), (EjbDescriptor)ejbMsgBeanDesc);
        for (ActivationConfigProperty acProp : mdAn.activationConfig()) {
            EnvironmentProperty envProp = new EnvironmentProperty(acProp.propertyName(), acProp.propertyValue(), "");
            if (ejbMsgBeanDesc.getActivationConfigValue(envProp.getName()) != null) continue;
            ejbMsgBeanDesc.putActivationConfigProperty(envProp);
        }
        return procResult;
    }

    private HandlerProcessingResult setMessageListenerInterface(MessageDriven mdAn, EjbMessageBeanDescriptor msgEjbDesc, Class ejbClass, AnnotationInfo ainfo) throws AnnotationProcessorException {
        String intfName = null;
        if (mdAn.messageListenerInterface() != Object.class) {
            intfName = mdAn.messageListenerInterface().getName();
        } else {
            for (Class<?> next : ejbClass.getInterfaces()) {
                if (this.excludedFromImplementsClause(next)) continue;
                if (intfName == null) {
                    intfName = next.getName();
                    continue;
                }
                EjbBundleDescriptorImpl currentBundle = (EjbBundleDescriptorImpl)((EjbBundleContext)ainfo.getProcessingContext().getHandler()).getDescriptor();
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.ambiguousimplementsclausemdb", "Implements clause for 3.x message driven bean class {0} in {1} declares more than one potential message-listener interface.  In this case, the @MessageDriven.messageListenerInterface() attribute must be used to specify the message listener interface.", new Object[]{ejbClass, currentBundle.getModuleDescriptor().getArchiveUri()}));
                return this.getDefaultFailedResult();
            }
        }
        if (intfName == null) {
            intfName = msgEjbDesc.getMessageListenerType();
        }
        msgEjbDesc.setMessageListenerType(intfName);
        return this.getDefaultProcessedResult();
    }
}

