/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.AbstractConnectorResourceDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ResourceValidatorVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public class ResourceValidator
implements EventListener,
ResourceValidatorVisitor {
    private static final Logger LOG = DOLUtils.deplLogger;
    @LogMessageInfo(message="JNDI lookup failed for the resource: Name: {0}, Lookup: {1}, Type: {2}.", level="SEVERE", cause="JNDI lookup for the specified resource failed.", action="Configure the required resources before deploying the application.", comment="For the method validateJNDIRefs of com.sun.enterprise.deployment.util.ResourceValidator.")
    private static final String RESOURCE_REF_JNDI_LOOKUP_FAILED = "AS-DEPLOYMENT-00026";
    @LogMessageInfo(message="Resource Adapter not present: RA Name: {0}, Type: {1}.", level="SEVERE", cause="Resource apapter specified is invalid.", action="Configure the required resource adapter.")
    private static final String RESOURCE_REF_INVALID_RA = "AS-DEPLOYMENT-00027";
    @LogMessageInfo(message="Skipping resource validation")
    private static final String SKIP_RESOURCE_VALIDATION = "AS-DEPLOYMENT-00028";
    private static final Set<SimpleJndiName> DEFAULT_JNDI_NAMES = Set.of("java:comp/DefaultDataSource", "java:comp/DefaultJMSConnectionFactory", "java:comp/ORB", "java:comp/DefaultManagedExecutorService", "java:comp/DefaultManagedScheduledExecutorService", "java:comp/DefaultManagedThreadFactory", "java:comp/DefaultContextService", "java:comp/UserTransaction", "java:comp/TransactionSynchronizationRegistry", "java:comp/BeanManager", "java:comp/ValidatorFactory", "java:comp/Validator", "java:comp/InAppClientContainer", "java:module/ModuleName", "java:app/AppName").stream().map(SimpleJndiName::new).collect(Collectors.toUnmodifiableSet());
    @Inject
    private Events events;
    @Inject
    private Domain domain;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceValidator.class);
    @Inject
    @Named(value="default-instance-name")
    private Server server;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(Deployment.AFTER_APPLICATION_CLASSLOADER_CREATION)) {
            ResourceValidatorHandler handler = new ResourceValidatorHandler((DeploymentContext)event.hook());
            handler.validate();
        }
    }

    private class ResourceValidatorHandler {
        private final String target;
        private final DeploymentContext dc;
        private final Application application;

        public ResourceValidatorHandler(DeploymentContext dc) {
            this.dc = dc;
            this.application = (Application)dc.getModuleMetaData(Application.class);
            DeployCommandParameters commandParams = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            this.target = commandParams.target;
        }

        public void validate() {
            if (System.getProperty("deployment.resource.validation", "true").equals("false")) {
                LOG.log(Level.INFO, ResourceValidator.SKIP_RESOURCE_VALIDATION);
                return;
            }
            if (this.application == null) {
                return;
            }
            AppResources appResources = new AppResources();
            this.parseResources(appResources);
            this.validateResources(appResources);
        }

        private void parseResources(AppResources appResources) {
            this.parseResources(this.application, appResources);
            for (BundleDescriptor bd : this.application.getBundleDescriptors()) {
                if (bd instanceof WebBundleDescriptor || bd instanceof ApplicationClientDescriptor) {
                    this.parseResources(bd, appResources);
                }
                if (!(bd instanceof EjbBundleDescriptor)) continue;
                for (ManagedBeanDescriptor mbd : bd.getManagedBeans()) {
                    this.parseResources(mbd, (JndiNameEnvironment)((Object)bd), appResources);
                }
                EjbBundleDescriptor ebd = (EjbBundleDescriptor)bd;
                for (EjbDescriptor ejbDescriptor : ebd.getEjbs()) {
                    this.parseEJB(ejbDescriptor, appResources);
                }
            }
            this.parseManagedBeans(appResources);
            String appName = DOLUtils.getApplicationName(this.application);
            Map resourcesList = (Map)this.dc.getTransientAppMetadata().get("app-scoped-resources-jndi-names");
            appResources.storeAppScopedResources(resourcesList, appName);
        }

        private void parseEJB(EjbDescriptor ejb, AppResources appResources) {
            SimpleJndiName fullyQualifiedJavaGlobalName;
            Object intf;
            SimpleJndiName glassfishSpecificJndiName;
            SimpleJndiName javaGlobalName = this.getJavaGlobalJndiNamePrefix(ejb);
            boolean disableNonPortableJndiName = false;
            Boolean disableInDD = ejb.getEjbBundleDescriptor().getDisableNonportableJndiNames();
            if (disableInDD != null) {
                disableNonPortableJndiName = disableInDD;
            }
            if ((glassfishSpecificJndiName = disableNonPortableJndiName ? null : ejb.getJndiName()) != null && (glassfishSpecificJndiName.isEmpty() || glassfishSpecificJndiName.equals((Object)javaGlobalName))) {
                glassfishSpecificJndiName = null;
            }
            int countPortableJndiNames = 0;
            if (ejb.isRemoteInterfacesSupported()) {
                intf = ejb.getHomeClassName();
                fullyQualifiedJavaGlobalName = new SimpleJndiName(String.valueOf(javaGlobalName) + "!" + (String)intf);
                appResources.storeInNamespace(fullyQualifiedJavaGlobalName, ejb);
                ++countPortableJndiNames;
                if (glassfishSpecificJndiName != null) {
                    appResources.storeInNamespace(glassfishSpecificJndiName, ejb);
                }
            }
            if (ejb.isRemoteBusinessInterfacesSupported()) {
                int count = 0;
                for (String intf2 : ejb.getRemoteBusinessClassNames()) {
                    ++count;
                    SimpleJndiName fullyQualifiedJavaGlobalName2 = new SimpleJndiName(String.valueOf(javaGlobalName) + "!" + intf2);
                    appResources.storeInNamespace(fullyQualifiedJavaGlobalName2, ejb);
                    ++countPortableJndiNames;
                    if (glassfishSpecificJndiName == null) continue;
                    SimpleJndiName remoteJndiName = this.getRemoteEjbJndiName(true, intf2, glassfishSpecificJndiName);
                    appResources.storeInNamespace(remoteJndiName, ejb);
                }
                if (glassfishSpecificJndiName != null && !ejb.isRemoteInterfacesSupported() && count == 1) {
                    appResources.storeInNamespace(glassfishSpecificJndiName, ejb);
                }
            }
            if (ejb.isLocalInterfacesSupported()) {
                intf = ejb.getLocalHomeClassName();
                fullyQualifiedJavaGlobalName = new SimpleJndiName(String.valueOf(javaGlobalName) + "!" + (String)intf);
                appResources.storeInNamespace(fullyQualifiedJavaGlobalName, ejb);
                ++countPortableJndiNames;
            }
            if (ejb.isLocalBusinessInterfacesSupported()) {
                for (String intf3 : ejb.getLocalBusinessClassNames()) {
                    SimpleJndiName fullyQualifiedJavaGlobalName3 = new SimpleJndiName(String.valueOf(javaGlobalName) + "!" + intf3);
                    appResources.storeInNamespace(fullyQualifiedJavaGlobalName3, ejb);
                    ++countPortableJndiNames;
                }
            }
            if (ejb.isLocalBean()) {
                intf = ejb.getEjbClassName();
                fullyQualifiedJavaGlobalName = new SimpleJndiName(String.valueOf(javaGlobalName) + "!" + (String)intf);
                appResources.storeInNamespace(fullyQualifiedJavaGlobalName, ejb);
                ++countPortableJndiNames;
            }
            if (countPortableJndiNames == 1) {
                appResources.storeInNamespace(javaGlobalName, ejb);
            }
            this.parseResources(ejb, appResources);
        }

        private SimpleJndiName getJavaGlobalJndiNamePrefix(EjbDescriptor ejbDescriptor) {
            Application app = ejbDescriptor.getApplication();
            String appName = app.isVirtual() ? null : app.getAppName();
            StringBuilder javaGlobalPrefix = new StringBuilder("java:global/");
            if (appName != null) {
                javaGlobalPrefix.append(appName);
                javaGlobalPrefix.append('/');
            }
            javaGlobalPrefix.append(ejbDescriptor.getEjbBundleDescriptor().getModuleDescriptor().getModuleName());
            javaGlobalPrefix.append('/');
            javaGlobalPrefix.append(ejbDescriptor.getName());
            return new SimpleJndiName(javaGlobalPrefix.toString());
        }

        private SimpleJndiName getRemoteEjbJndiName(EjbReferenceDescriptor refDesc) {
            String intf = refDesc.isEJB30ClientView() ? refDesc.getEjbInterface() : refDesc.getHomeClassName();
            return this.getRemoteEjbJndiName(refDesc.isEJB30ClientView(), intf, refDesc.getJndiName());
        }

        private SimpleJndiName getRemoteEjbJndiName(boolean businessView, String interfaceName, SimpleJndiName jndiName) {
            String portableFullyQualifiedPortion = "!" + interfaceName;
            String glassfishFullyQualifiedPortion = "#" + interfaceName;
            if (businessView) {
                if (!jndiName.hasCorbaPrefix()) {
                    if (jndiName.isJavaGlobal()) {
                        return ResourceValidatorHandler.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
                    }
                    return ResourceValidatorHandler.checkFullyQualifiedJndiName(jndiName, glassfishFullyQualifiedPortion);
                }
            } else if (jndiName.isJavaGlobal()) {
                return ResourceValidatorHandler.checkFullyQualifiedJndiName(jndiName, portableFullyQualifiedPortion);
            }
            return jndiName;
        }

        private static SimpleJndiName checkFullyQualifiedJndiName(SimpleJndiName origJndiName, String fullyQualifiedPortion) {
            if (origJndiName.hasSuffix(fullyQualifiedPortion)) {
                return origJndiName;
            }
            return new SimpleJndiName(String.valueOf(origJndiName) + fullyQualifiedPortion);
        }

        private void parseManagedBeans(AppResources appResources) {
            for (BundleDescriptor bd : this.application.getBundleDescriptors()) {
                for (ManagedBeanDescriptor managedBean : bd.getManagedBeans()) {
                    appResources.storeInNamespace(managedBean.getGlobalJndiName(), (JndiNameEnvironment)((Object)bd));
                }
            }
        }

        private void parseResources(BundleDescriptor bd, AppResources appResources) {
            if (!(bd instanceof JndiNameEnvironment)) {
                return;
            }
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)bd);
            for (ResourceReferenceDescriptor resourceReferenceDescriptor : env.getResourceReferenceDescriptors()) {
                this.parseResources(resourceReferenceDescriptor, env, appResources);
            }
            for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : env.getResourceEnvReferenceDescriptors()) {
                this.parseResources(resourceEnvReferenceDescriptor, env, appResources);
            }
            for (MessageDestinationReferenceDescriptor messageDestinationReferenceDescriptor : env.getMessageDestinationReferenceDescriptors()) {
                this.parseResources(messageDestinationReferenceDescriptor, env, appResources);
            }
            for (EnvironmentProperty environmentProperty : env.getEnvironmentProperties()) {
                this.parseResources(environmentProperty, env, appResources);
            }
            for (ResourceDescriptor resourceDescriptor : env.getAllResourcesDescriptors()) {
                this.parseResources(resourceDescriptor, env, appResources);
            }
            for (EntityManagerReferenceDescriptor entityManagerReferenceDescriptor : env.getEntityManagerReferenceDescriptors()) {
                this.storeInNamespace(SimpleJndiName.of((String)entityManagerReferenceDescriptor.getName()), env, appResources);
            }
            for (EntityManagerFactoryReferenceDescriptor entityManagerFactoryReferenceDescriptor : env.getEntityManagerFactoryReferenceDescriptors()) {
                this.storeInNamespace(SimpleJndiName.of((String)entityManagerFactoryReferenceDescriptor.getName()), env, appResources);
            }
            for (EjbReferenceDescriptor ejbReferenceDescriptor : env.getEjbReferenceDescriptors()) {
                this.parseResources(ejbReferenceDescriptor, env, appResources);
            }
            for (ServiceReferenceDescriptor serviceReferenceDescriptor : env.getServiceReferenceDescriptors()) {
                this.parseResources(serviceReferenceDescriptor, env, appResources);
            }
            for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : bd.getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
                for (PersistenceUnitDescriptor pu : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                    this.parseResources(pu, env, appResources);
                }
            }
            for (ManagedBeanDescriptor managedBeanDescriptor : bd.getManagedBeans()) {
                this.parseResources(managedBeanDescriptor, env, appResources);
            }
        }

        private void parseResources(ResourceReferenceDescriptor resRef, JndiNameEnvironment env, AppResources appResources) {
            resRef.checkType();
            SimpleJndiName name = this.getLogicalJNDIName(SimpleJndiName.of((String)resRef.getName()), env);
            String type = resRef.getType();
            SimpleJndiName jndiName = resRef.getJndiName();
            AppResource resRefResource = new AppResource(name, jndiName, type, env, true);
            if (resRef.isURLResource() && jndiName != null && !jndiName.hasJavaPrefix()) {
                try {
                    new URL(jndiName.toString());
                    resRefResource.noValidation();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (resRef.isWebServiceContext()) {
                resRefResource.noValidation();
            }
            appResources.store(resRefResource);
        }

        private void parseResources(ResourceEnvReferenceDescriptor resEnvRef, JndiNameEnvironment env, AppResources appResources) {
            resEnvRef.checkType();
            SimpleJndiName name = this.getLogicalJNDIName(SimpleJndiName.of((String)resEnvRef.getName()), env);
            String type = resEnvRef.getType();
            SimpleJndiName jndiName = resEnvRef.getJndiName();
            AppResource resEnvRefResource = new AppResource(name, jndiName, type, env, true);
            if (resEnvRef.isEJBContext() || resEnvRef.isValidator() || resEnvRef.isValidatorFactory() || resEnvRef.isCDIBeanManager()) {
                resEnvRefResource.noValidation();
            }
            appResources.store(resEnvRefResource);
        }

        private void parseResources(MessageDestinationReferenceDescriptor msgDestRef, JndiNameEnvironment env, AppResources appResources) {
            SimpleJndiName name = this.getLogicalJNDIName(SimpleJndiName.of((String)msgDestRef.getName()), env);
            SimpleJndiName jndiName = msgDestRef.isLinkedToMessageDestination() ? msgDestRef.getMessageDestination().getJndiName() : msgDestRef.getJndiName();
            appResources.store(new AppResource(name, jndiName, msgDestRef.getType(), env, true));
        }

        private void parseResources(EnvironmentProperty envProp, JndiNameEnvironment env, AppResources appResources) {
            SimpleJndiName name = this.getLogicalJNDIName(SimpleJndiName.of((String)envProp.getName()), env);
            SimpleJndiName jndiName = envProp.hasLookupName() ? envProp.getLookupName() : (!envProp.getMappedName().isEmpty() ? envProp.getMappedName() : new SimpleJndiName(""));
            AppResource envPropResource = new AppResource(name, jndiName, envProp.getType(), env, true);
            if (jndiName.isEmpty()) {
                envPropResource.noValidation();
            }
            appResources.store(envPropResource);
            appResources.storeInNamespace(name, env);
        }

        private void parseResources(EjbReferenceDescriptor ejbRef, JndiNameEnvironment env, AppResources appResources) {
            SimpleJndiName name = this.getLogicalJNDIName(SimpleJndiName.of((String)ejbRef.getName()), env);
            if (ejbRef.getEjbDescriptor() != null) {
                appResources.storeInNamespace(name, env);
                return;
            }
            SimpleJndiName jndiName = new SimpleJndiName("");
            boolean validationRequired = false;
            if (ejbRef.isLocal()) {
                if (ejbRef.hasLookupName()) {
                    jndiName = ejbRef.getLookupName();
                    validationRequired = true;
                }
            } else {
                SimpleJndiName ejbRefJndiName = this.getJndiName(ejbRef);
                if (ejbRefJndiName == null && ejbRef.hasLookupName()) {
                    jndiName = ejbRef.getLookupName();
                    validationRequired = true;
                } else if (ejbRefJndiName != null && ejbRefJndiName.isJavaApp() && !ejbRefJndiName.hasPrefix("java:app/env/")) {
                    String appName = DOLUtils.getApplicationName(this.application);
                    jndiName = ejbRefJndiName.changePrefix("java:global/" + appName + "/");
                    validationRequired = true;
                } else {
                    SimpleJndiName remoteJndiName = this.getRemoteEjbJndiName(ejbRef);
                    if (!remoteJndiName.hasCorbaPrefix()) {
                        validationRequired = true;
                        jndiName = remoteJndiName;
                    }
                }
            }
            appResources.store(new AppResource(name, jndiName, ejbRef.getType(), env, validationRequired));
        }

        private SimpleJndiName getJndiName(EjbReferenceDescriptor descriptor) {
            if (!descriptor.hasJndiName()) {
                return null;
            }
            return descriptor.getJndiName();
        }

        private void parseResources(ServiceReferenceDescriptor serviceRef, JndiNameEnvironment env, AppResources appResources) {
            SimpleJndiName name = this.getLogicalJNDIName(SimpleJndiName.of((String)serviceRef.getName()), env);
            if (serviceRef.hasLookupName()) {
                SimpleJndiName lookupName = serviceRef.getLookupName();
                appResources.store(new AppResource(name, lookupName, serviceRef.getType(), env, true));
            } else {
                appResources.storeInNamespace(name, env);
            }
        }

        private void parseResources(ResourceDescriptor resourceDescriptor, JndiNameEnvironment env, AppResources appResources) {
            JavaEEResourceType type = resourceDescriptor.getResourceType();
            if (type == JavaEEResourceType.CFD || type == JavaEEResourceType.AODD) {
                if (env instanceof ApplicationClientDescriptor) {
                    return;
                }
                AbstractConnectorResourceDescriptor acrd = (AbstractConnectorResourceDescriptor)resourceDescriptor;
                SimpleJndiName raJndiName = SimpleJndiName.of((String)acrd.getResourceAdapter());
                appResources.store(new AppResource(resourceDescriptor.getJndiName(), raJndiName, type.toString(), env, true));
            } else {
                this.storeInNamespace(resourceDescriptor.getJndiName(), env, appResources);
            }
        }

        private void parseResources(PersistenceUnitDescriptor pu, JndiNameEnvironment env, AppResources appResources) {
            SimpleJndiName jtaDataSourceName = pu.getJtaDataSource();
            SimpleJndiName nonJtaDataSourceName = pu.getNonJtaDataSource();
            if (jtaDataSourceName != null && !jtaDataSourceName.isEmpty()) {
                appResources.store(new AppResource(pu.getJndiName(), jtaDataSourceName, "javax.sql.DataSource", env, true));
            }
            if (nonJtaDataSourceName != null && !nonJtaDataSourceName.isEmpty()) {
                appResources.store(new AppResource(pu.getJndiName(), nonJtaDataSourceName, "javax.sql.DataSource", env, true));
            }
        }

        private void parseResources(ManagedBeanDescriptor managedBean, JndiNameEnvironment env, AppResources appResources) {
            for (ResourceReferenceDescriptor resourceReferenceDescriptor : managedBean.getResourceReferenceDescriptors()) {
                this.parseResources(resourceReferenceDescriptor, env, appResources);
            }
            for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : managedBean.getResourceEnvReferenceDescriptors()) {
                this.parseResources(resourceEnvReferenceDescriptor, env, appResources);
            }
            for (MessageDestinationReferenceDescriptor messageDestinationReferenceDescriptor : managedBean.getMessageDestinationReferenceDescriptors()) {
                this.parseResources(messageDestinationReferenceDescriptor, env, appResources);
            }
            for (EjbReferenceDescriptor ejbReferenceDescriptor : managedBean.getEjbReferenceDescriptors()) {
                this.parseResources(ejbReferenceDescriptor, env, appResources);
            }
            for (EnvironmentProperty environmentProperty : managedBean.getEnvironmentProperties()) {
                this.parseResources(environmentProperty, env, appResources);
            }
            for (ResourceDescriptor resourceDescriptor : env.getAllResourcesDescriptors()) {
                this.parseResources(resourceDescriptor, env, appResources);
            }
        }

        private void parseResources(EjbDescriptor ejb, AppResources appResources) {
            for (ResourceReferenceDescriptor resourceReferenceDescriptor : ejb.getResourceReferenceDescriptors()) {
                this.parseResources(resourceReferenceDescriptor, (JndiNameEnvironment)ejb, appResources);
            }
            for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : ejb.getResourceEnvReferenceDescriptors()) {
                this.parseResources(resourceEnvReferenceDescriptor, (JndiNameEnvironment)ejb, appResources);
            }
            for (MessageDestinationReferenceDescriptor messageDestinationReferenceDescriptor : ejb.getMessageDestinationReferenceDescriptors()) {
                this.parseResources(messageDestinationReferenceDescriptor, (JndiNameEnvironment)ejb, appResources);
            }
            for (EnvironmentProperty environmentProperty : ejb.getEnvironmentProperties()) {
                this.parseResources(environmentProperty, (JndiNameEnvironment)ejb, appResources);
            }
            for (EjbReferenceDescriptor ejbReferenceDescriptor : ejb.getEjbReferenceDescriptors()) {
                this.parseResources(ejbReferenceDescriptor, (JndiNameEnvironment)ejb, appResources);
            }
            for (ResourceDescriptor resourceDescriptor : ejb.getAllResourcesDescriptors()) {
                this.parseResources(resourceDescriptor, (JndiNameEnvironment)ejb, appResources);
            }
        }

        private void storeInNamespace(SimpleJndiName name, JndiNameEnvironment env, AppResources appResources) {
            SimpleJndiName logicalJNDIName = this.getLogicalJNDIName(name, env);
            appResources.storeInNamespace(logicalJNDIName, env);
        }

        private SimpleJndiName getLogicalJNDIName(SimpleJndiName rawName, JndiNameEnvironment env) {
            SimpleJndiName jndiName = rawName.hasJavaPrefix() ? rawName : rawName.changePrefix("java:comp/env/");
            boolean treatComponentAsModule = DOLUtils.getTreatComponentAsModule(env);
            if (treatComponentAsModule && jndiName.isJavaComponent()) {
                return jndiName.changePrefix("java:module/");
            }
            return jndiName;
        }

        private SimpleJndiName convertModuleOrAppJNDIName(SimpleJndiName jndiName, JndiNameEnvironment env) {
            if (jndiName == null) {
                return null;
            }
            BundleDescriptor bd = env instanceof EjbDescriptor ? ((EjbDescriptor)env).getEjbBundleDescriptor() : (env instanceof BundleDescriptor ? (BundleDescriptor)((Object)env) : null);
            if (bd == null) {
                return new SimpleJndiName("");
            }
            String appName = this.application.isVirtual() ? null : this.application.getAppName();
            String moduleName = bd.getModuleDescriptor().getModuleName();
            StringBuilder javaGlobalName = new StringBuilder("java:global/");
            if (jndiName.isJavaApp()) {
                if (appName != null) {
                    javaGlobalName.append(appName);
                    javaGlobalName.append('/');
                }
                javaGlobalName.append(jndiName.removePrefix("java:app/"));
            } else if (jndiName.isJavaModule()) {
                if (appName != null) {
                    javaGlobalName.append(appName);
                    javaGlobalName.append('/');
                }
                javaGlobalName.append(moduleName);
                javaGlobalName.append('/');
                javaGlobalName.append(jndiName.removePrefix("java:module/"));
            } else {
                return new SimpleJndiName("");
            }
            return new SimpleJndiName(javaGlobalName.toString());
        }

        private void validateResources(AppResources appResources) {
            for (AppResource resource : appResources.myResources) {
                if (!resource.validate) continue;
                if (JavaEEResourceType.CFD.name().equals(resource.getType()) || JavaEEResourceType.AODD.name().equals(resource.getType())) {
                    this.validateRAName(resource);
                    continue;
                }
                this.validateJNDIRefs(resource, appResources.myNamespace);
            }
            List raNames = (List)this.dc.getTransientAppMetadata().get("app-scoped-resources-ra-names");
            if (raNames == null) {
                return;
            }
            for (Map.Entry entry : raNames) {
                this.validateRAName((String)entry.getKey(), (String)entry.getValue());
            }
        }

        private void validateRAName(AppResource resource) {
            String raName = resource.getJndiName() == null ? null : resource.getJndiName().toString();
            this.validateRAName(raName, resource.getType());
        }

        private void validateRAName(String raName, String type) {
            if (raName == null || raName.isEmpty()) {
                LOG.log(Level.SEVERE, ResourceValidator.RESOURCE_REF_INVALID_RA, new Object[]{null, type});
                throw new DeploymentException(localStrings.getLocalString("enterprise.deployment.util.ra.validation", "Resource Adapter not present: RA Name: {0}, Type: {1}.", new Object[]{null, type}));
            }
            int poundIndex = raName.indexOf("#");
            if (poundIndex < 0) {
                if (ResourceValidator.this.domain.getApplications().getApplication(raName) != null) {
                    return;
                }
                if (raName.equals("jmsra") || raName.equals("__ds_jdbc_ra") || raName.equals("jaxr-ra") || raName.equals("__cp_jdbc_ra") || raName.equals("__xa_jdbc_ra") || raName.equals("__dm_jdbc_ra")) {
                    return;
                }
                if (this.isEmbedded(raName)) {
                    return;
                }
            } else if (raName.substring(0, poundIndex).equals(this.application.getAppName()) && this.isEmbedded(raName = raName.substring(poundIndex + 1))) {
                return;
            }
            LOG.log(Level.SEVERE, ResourceValidator.RESOURCE_REF_INVALID_RA, new Object[]{raName, type});
            throw new DeploymentException(localStrings.getLocalString("enterprise.deployment.util.ra.validation", "Resource Adapter not present: RA Name: {0}, Type: {1}.", new Object[]{raName, type}));
        }

        private boolean isEmbedded(String raName) {
            String ranameWithRAR = raName + ".rar";
            for (BundleDescriptor bundleDescriptor : this.application.getBundleDescriptors(ConnectorDescriptor.class)) {
                if (!raName.equals(bundleDescriptor.getModuleName()) && !ranameWithRAR.equals(bundleDescriptor.getModuleName())) continue;
                return true;
            }
            return false;
        }

        private void validateJNDIRefs(AppResource resource, JNDINamespace namespace) {
            SimpleJndiName newName;
            if (!resource.hasLookup()) {
                if (namespace.find(resource.getName(), resource.getEnv())) {
                    return;
                }
                LOG.log(Level.SEVERE, ResourceValidator.RESOURCE_REF_JNDI_LOOKUP_FAILED, new Object[]{resource.getName(), null, resource.getType()});
                throw new DeploymentException(MessageFormat.format("JNDI lookup failed for the resource: Name: {0}, Lookup: {1}, Type: {2}", resource.getName(), null, resource.getType()));
            }
            SimpleJndiName jndiName = resource.getJndiName();
            JndiNameEnvironment env = resource.getEnv();
            if (this.isResourceInDomainXML(jndiName) || DEFAULT_JNDI_NAMES.contains(jndiName)) {
                return;
            }
            if ((jndiName.isJavaModule() || jndiName.isJavaApp()) && namespace.find(newName = this.convertModuleOrAppJNDIName(jndiName, resource.getEnv()), env)) {
                return;
            }
            if (!jndiName.hasJavaPrefix() && namespace.find(jndiName, env)) {
                return;
            }
            SimpleJndiName convertedJndiName = this.getLogicalJNDIName(jndiName, env);
            if (namespace.find(convertedJndiName, env)) {
                return;
            }
            try {
                if (this.loadOnCurrentInstance()) {
                    InitialContext.doLookup(jndiName.toString());
                }
            }
            catch (NamingException e) {
                throw new DeploymentException(MessageFormat.format("JNDI lookup failed for the resource: Name: {0}, Lookup: {1}, Type: {2}", resource.getName(), jndiName, resource.getType()), (Throwable)e);
            }
        }

        private boolean isResourceInDomainXML(SimpleJndiName jndiName) {
            if (jndiName == null) {
                return false;
            }
            Server svr = ResourceValidator.this.domain.getServerNamed(this.target);
            if (svr != null) {
                return svr.isResourceRefExists(jndiName);
            }
            Cluster cluster = ResourceValidator.this.domain.getClusterNamed(this.target);
            return cluster != null && cluster.isResourceRefExists(jndiName);
        }

        private boolean loadOnCurrentInstance() {
            DeployCommandParameters commandParams = (DeployCommandParameters)this.dc.getCommandParameters(DeployCommandParameters.class);
            Properties appProps = this.dc.getAppProps();
            if (commandParams.enabled.booleanValue()) {
                String objectType;
                if (ResourceValidator.this.domain.isCurrentInstanceMatchingTarget(commandParams.target, commandParams.name(), ResourceValidator.this.server.getName(), (List)this.dc.getTransientAppMetaData("previousTargets", List.class))) {
                    return true;
                }
                if (ResourceValidator.this.server.isDas() && (objectType = appProps.getProperty("object-type")) != null && (objectType.equals("system-admin") || objectType.equals("system-all"))) {
                    return true;
                }
            }
            return false;
        }

        private static class AppResources {
            List<AppResource> myResources = new ArrayList<AppResource>();
            JNDINamespace myNamespace = new JNDINamespace();

            private AppResources() {
            }

            private void store(AppResource resource) {
                this.myResources.add(resource);
                if (resource.hasLookup()) {
                    this.myNamespace.store(resource.name, resource.env);
                }
            }

            private void storeInNamespace(SimpleJndiName name, JndiNameEnvironment env) {
                this.myNamespace.store(name, env);
            }

            private void storeAppScopedResources(Map<String, List<SimpleJndiName>> resourcesList, String appName) {
                this.myNamespace.storeAppScopedResources(resourcesList, appName);
            }
        }

        private static class AppResource {
            private final SimpleJndiName name;
            private final SimpleJndiName lookup;
            private final String type;
            private final JndiNameEnvironment env;
            boolean validate;

            private AppResource(SimpleJndiName name, SimpleJndiName lookup, String type, JndiNameEnvironment env, boolean validate) {
                this.name = name;
                this.lookup = lookup;
                this.type = type;
                this.env = env;
                this.validate = validate;
            }

            private SimpleJndiName getJndiName() {
                return this.lookup;
            }

            private JndiNameEnvironment getEnv() {
                return this.env;
            }

            private SimpleJndiName getName() {
                return this.name;
            }

            private String getType() {
                return this.type;
            }

            private boolean hasLookup() {
                return this.lookup != null && !this.lookup.isEmpty();
            }

            private void noValidation() {
                this.validate = false;
            }
        }

        private static class JNDINamespace {
            private final Map<String, List<SimpleJndiName>> componentNamespaces = new HashMap<String, List<SimpleJndiName>>();
            private final Map<String, List<SimpleJndiName>> moduleNamespaces = new HashMap<String, List<SimpleJndiName>>();
            private final List<SimpleJndiName> appNamespace = new ArrayList<SimpleJndiName>();
            private final List<SimpleJndiName> globalNameSpace = new ArrayList<SimpleJndiName>();
            private final List<SimpleJndiName> nonPortableJndiNames = new ArrayList<SimpleJndiName>();

            private JNDINamespace() {
            }

            private void storeAppScopedResources(Map<String, List<SimpleJndiName>> resources, String appName) {
                if (resources == null) {
                    return;
                }
                List<SimpleJndiName> appLevelResources = resources.get(appName);
                if (appLevelResources != null) {
                    this.appNamespace.addAll(appLevelResources);
                }
                for (Map.Entry<String, List<SimpleJndiName>> resource : resources.entrySet()) {
                    if (resource.getKey().equals(appName)) continue;
                    String moduleName = this.getActualModuleName(resource.getKey());
                    List<SimpleJndiName> jndiNames = this.moduleNamespaces.get(moduleName);
                    if (jndiNames == null) {
                        jndiNames = new ArrayList<SimpleJndiName>();
                        jndiNames.addAll((Collection<SimpleJndiName>)resource.getValue());
                        this.moduleNamespaces.put(moduleName, jndiNames);
                        continue;
                    }
                    jndiNames.addAll((Collection<SimpleJndiName>)resource.getValue());
                }
            }

            public void store(SimpleJndiName jndiName, JndiNameEnvironment env) {
                LOG.log(Level.FINEST, "store(jndiName={0}, env)", jndiName);
                if (jndiName.isJavaComponent()) {
                    String componentId = DOLUtils.getComponentEnvId(env);
                    List<SimpleJndiName> jndiNames = this.componentNamespaces.get(componentId);
                    if (jndiNames == null) {
                        jndiNames = new ArrayList<SimpleJndiName>();
                        jndiNames.add(jndiName);
                        this.componentNamespaces.put(componentId, jndiNames);
                    } else {
                        jndiNames.add(jndiName);
                    }
                } else if (jndiName.isJavaModule()) {
                    String moduleName = this.getActualModuleName(DOLUtils.getModuleName(env));
                    List<SimpleJndiName> jndiNames = this.moduleNamespaces.get(moduleName);
                    if (jndiNames == null) {
                        jndiNames = new ArrayList<SimpleJndiName>();
                        jndiNames.add(jndiName);
                        this.moduleNamespaces.put(moduleName, jndiNames);
                    } else {
                        jndiNames.add(jndiName);
                    }
                } else if (jndiName.isJavaApp()) {
                    this.appNamespace.add(jndiName);
                } else if (jndiName.isJavaGlobal()) {
                    this.globalNameSpace.add(jndiName);
                } else {
                    this.nonPortableJndiNames.add(jndiName);
                }
            }

            public boolean find(SimpleJndiName jndiName, JndiNameEnvironment env) {
                LOG.log(Level.FINE, "find(jndiName={0}, env)", jndiName);
                if (jndiName == null) {
                    return false;
                }
                if (jndiName.isJavaComponent()) {
                    String componentId = DOLUtils.getComponentEnvId(env);
                    List<SimpleJndiName> jndiNames = this.componentNamespaces.get(componentId);
                    return jndiNames != null && jndiNames.contains(jndiName);
                }
                if (jndiName.isJavaModule()) {
                    String moduleName = this.getActualModuleName(DOLUtils.getModuleName(env));
                    List<SimpleJndiName> jndiNames = this.moduleNamespaces.get(moduleName);
                    return jndiNames != null && jndiNames.contains(jndiName);
                }
                if (jndiName.isJavaApp()) {
                    return this.appNamespace.contains(jndiName);
                }
                if (jndiName.isJavaGlobal()) {
                    return this.globalNameSpace.contains(jndiName);
                }
                return this.nonPortableJndiNames.contains(jndiName);
            }

            private String getActualModuleName(String moduleName) {
                if (moduleName != null && (moduleName.endsWith(".jar") || moduleName.endsWith(".war") || moduleName.endsWith(".rar"))) {
                    moduleName = moduleName.substring(0, moduleName.length() - 4);
                }
                return moduleName;
            }
        }
    }
}

