/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocketServiceApp;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;

public abstract class MQWebSocket
extends DefaultWebSocket {
    protected static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();
    protected BrokerResources br = Globals.getBrokerResources();
    protected MemoryManager memManager = null;
    protected Object closeLock = new Object();
    protected boolean closed = false;
    protected MQWebSocketServiceApp websocketApp = null;
    private ProtocolHandler protocolHandler = null;
    private String requestURL = null;

    public static boolean getDEBUG() {
        return DEBUG;
    }

    protected MQWebSocket(MQWebSocketServiceApp app, ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) {
        super(protocolHandler, request, listeners);
        this.requestURL = request.getRequestURI();
        this.websocketApp = app;
        this.protocolHandler = protocolHandler;
        this.memManager = protocolHandler.getConnection().getTransport().getMemoryManager();
    }

    public InetAddress getRemoteAddress() {
        return ((InetSocketAddress)this.protocolHandler.getConnection().getPeerAddress()).getAddress();
    }

    public int getRemotePort() {
        return ((InetSocketAddress)this.protocolHandler.getConnection().getPeerAddress()).getPort();
    }

    protected int getLocalPort() {
        return ((InetSocketAddress)this.protocolHandler.getConnection().getLocalAddress()).getPort();
    }

    protected abstract void writePacket(Packet var1) throws IOException;

    protected abstract void processData(String var1) throws Exception;

    protected abstract void processData(byte[] var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(DataFrame frame) {
        super.onClose(frame);
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.logger.log(8, this.br.getKString("B1504", this.getLogString() + (String)(frame == null ? "" : "[" + String.valueOf(frame) + "]")));
    }

    public boolean isClosed() {
        return this.closed || !this.isConnected();
    }

    protected String getLogString() {
        return "[" + this.requestURL + "@" + ((Object)((Object)this)).hashCode() + "]";
    }
}

