/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

abstract class Monitor {
    Destination d = null;

    Monitor(Destination d) {
        this.d = d;
    }

    protected abstract Hashtable getMonitorData();

    public void run() {
        Packet p = new Packet(false);
        Hashtable entries = this.getMonitorData();
        if (entries == null) {
            return;
        }
        if (Monitor.writeMap(p, entries, this.d.getDestinationName())) {
            try {
                PacketReference ref = PacketReference.createReference(this.d.getPartitionedStore(), p, null);
                this.d.queueMessage(ref, false);
                Set s = this.d.routeNewMessage(ref);
                this.d.forwardMessage(s, ref);
            }
            catch (BrokerException ex) {
                Globals.getLogger().log(4, "Unable to writeMap for  metrics" + String.valueOf(this.d), (Throwable)ex);
            }
            catch (SelectorFormatException ex) {
                Globals.getLogger().logStack(4, "Internal Error ", (Throwable)ex);
            }
        } else {
            Globals.getLogger().log(4, "Unable to writeMap for  metrics" + String.valueOf(this.d));
        }
    }

    public void writeToSpecificMonitorConsumer(Consumer c) {
        Packet p = new Packet(true);
        Hashtable entries = this.getMonitorData();
        if (entries == null) {
            return;
        }
        if (c == null) {
            return;
        }
        if (Monitor.writeMap(p, entries, this.d.getDestinationName())) {
            try {
                PacketReference ref = PacketReference.createReference(this.d.getPartitionedStore(), p, null);
                this.d.queueMessage(ref, false);
                ArrayList<Consumer> arl = new ArrayList<Consumer>(1);
                arl.add(c);
                ref.store(arl);
                c.routeMessage(ref, false);
            }
            catch (BrokerException ex) {
                Globals.getLogger().log(4, "Unable to writeMap for  metrics " + String.valueOf(this.d) + " : targeted for " + String.valueOf(c.getConsumerUID()), (Throwable)ex);
            }
        } else {
            Globals.getLogger().log(4, "Unable to writeMap for  metrics" + String.valueOf(this.d) + " : targeted for " + String.valueOf(c.getConsumerUID()));
        }
    }

    private static boolean writeMap(Packet pkt, Hashtable entries, String destination) {
        try {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            Long curTime = System.currentTimeMillis();
            props.put("type", destination);
            props.put("timestamp", curTime);
            MQAddress addr = Globals.getMQAddress();
            props.put("brokerAddress", addr.toString());
            props.put("brokerHost", addr.getHostName());
            props.put("brokerPort", addr.getPort());
            pkt.setProperties(props);
            pkt.setPacketType(3);
            pkt.setDestination(destination);
            pkt.setPriority(5);
            pkt.setIP(InetAddress.getLocalHost().getAddress());
            pkt.updateSequenceNumber();
            pkt.updateTimestamp();
            pkt.generateSequenceNumber(false);
            pkt.generateTimestamp(false);
            pkt.setIsQueue(false);
            pkt.setTransactionID(0L);
            pkt.setSendAcknowledge(false);
            pkt.setPersistent(BrokerMonitor.PERSIST);
            pkt.setExpiration(BrokerMonitor.TTL == 0L ? 0L : curTime + BrokerMonitor.TTL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(entries);
            objectOutputStream.flush();
            byteArrayOutputStream.flush();
            byte[] messageBody = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
            byteArrayOutputStream.close();
            pkt.setMessageBody(messageBody);
            return true;
        }
        catch (Exception e) {
            Globals.getLogger().log(32, "Error sending metrics data", (Throwable)e);
            return false;
        }
    }
}

