/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Property;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FelixPropertyAdapter
implements Property {
    private final String name;
    private final Object value;

    public FelixPropertyAdapter(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("Missing required parameter: name");
        }
        if (value == null) {
            throw new NullPointerException("Missing required parameter: value");
        }
        this.name = name;
        this.value = value;
    }

    public FelixPropertyAdapter(Map.Entry<String, Object> entry) {
        this(entry.getKey(), entry.getValue());
    }

    @Override
    public Object getConvertedValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        if (this.value instanceof Version) {
            return "version";
        }
        if (this.value instanceof Long) {
            return "long";
        }
        if (this.value instanceof Double) {
            return "double";
        }
        if (this.value instanceof List) {
            return "set";
        }
        return null;
    }

    @Override
    public String getValue() {
        return String.valueOf(this.value);
    }
}

